/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.action;

import de.bos_bremen.ecard.client.action.AbstractSignerAction;
import de.bos_bremen.ecard.client.gui.dialog.AboutDialog;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.licence.LicenceKeyEngine;
import de.bos_bremen.gov2.jca_provider.OCFProvider;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.security.Provider;
import java.security.Security;
import java.text.MessageFormat;
import java.util.prefs.Preferences;

public class InfoAction
extends AbstractSignerAction {
    private static final String ACTION_NAME_KEY = "action.info";
    private static final long serialVersionUID = 6856575634997704885L;

    InfoAction(Component parentComponent) {
        super(ACTION_NAME_KEY, parentComponent);
        this.setKeyAndIcon(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Provider provider = null;
        try {
            provider = Security.getProvider("ocf");
        }
        catch (Exception exception) {
            // empty catch block
        }
        OCFProvider ocfProvider = provider instanceof OCFProvider ? (OCFProvider)provider : new OCFProvider();
        String message = System.getProperty("about.text");
        message = message.replace("#BOREUM_VERSION#", Config.getComponentVersion());
        LOG.info("Preferences...");
        Preferences signerNode = Preferences.userRoot().node("de/bos_bremen/governikus_signer");
        String dialogMessage = MessageFormat.format(message, ocfProvider.getComponentName(), ocfProvider.getComponentVersion(), "", "");
        if (signerNode == null) {
            new AboutDialog(Document.getInstance().getFrame(), dialogMessage).setVisible(true);
            return;
        }
        try {
            LicenceKeyEngine licenceKeyEngine = new LicenceKeyEngine(signerNode.get("licence", ""));
            dialogMessage = MessageFormat.format(message, ocfProvider.getComponentName(), ocfProvider.getComponentVersion(), licenceKeyEngine.getKundennummer(), licenceKeyEngine.getEdition());
        }
        catch (Exception exception) {
            // empty catch block
        }
        new AboutDialog(Document.getInstance().getFrame(), dialogMessage).setVisible(true);
    }
}

