/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.action;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.action.AbstractSignerAction;
import de.bos_bremen.ecard.client.control.process.RootProcessName;
import de.bos_bremen.ecard.client.gui.GUIUtils;
import de.bos_bremen.ecard.client.gui.view.component.filechooser.FileChooserFactory;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.Document;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class ImportConfigFileAction
extends AbstractSignerAction {
    private static final long serialVersionUID = 1L;
    private static final String ACTION_NAME_KEY = "action.import";

    protected ImportConfigFileAction(Component parent) {
        super(ACTION_NAME_KEY, parent);
        this.setKeyAndIcon(true);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        String message = Messages.getString(ACTION_NAME_KEY);
        LOG.info("{}...", (Object)message);
        this.importFile();
        LOG.info("{} : done", (Object)message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importFile() {
        FileInputStream isConfig;
        block13: {
            JFileChooser chooser = this.createFileChooser();
            int returnCode = chooser.showDialog(this.parent, Messages.getString("import.file"));
            File fileConfig = chooser.getSelectedFile();
            if (fileConfig == null || returnCode == 1) {
                return;
            }
            Document documentInstance = Document.getInstance();
            int doit = documentInstance.displayRedundantMessages(this.parent, "import.question", 2, true);
            if (doit != 0) {
                return;
            }
            isConfig = null;
            try {
                isConfig = new FileInputStream(fileConfig);
                Config config = Config.getInstance();
                if (config.checkConfigFile(isConfig)) {
                    Utils.closeStream(isConfig);
                    LOG.info("config load import file ...");
                    isConfig = new FileInputStream(fileConfig);
                    Boolean returnValue = config.load(isConfig);
                    Utils.closeStream(isConfig);
                    LOG.trace("resetProcesses ...");
                    documentInstance.getProcessFactory().resetProcesses();
                    if (documentInstance.getProcessFactory().getProcessChoose().getActiveProcess() != null) {
                        documentInstance.getProcessFactory().getProcessChoose().showProcess(documentInstance.getProcessFactory().getProcessChoose().getActiveProcess());
                    } else if (documentInstance.isSaveConfig()) {
                        documentInstance.getProcessFactory().getProcessChoose().showProcess(RootProcessName.getInstance());
                    }
                    config.storeDefault(true);
                    documentInstance.getProcessFactory().setProperties(config.getProcessProperties());
                    if (returnValue != null && returnValue.booleanValue()) {
                        documentInstance.showMessageDialog(this.parent, "import.ready");
                    } else if (returnValue != null) {
                        documentInstance.showMessageDialog(this.parent, "import.ready.error");
                    }
                    break block13;
                }
                documentInstance.showMessageDialog(this.parent, "error.import.xml");
            }
            catch (HeadlessException | IOException e) {
                try {
                    LOG.error("show error : error.import");
                    documentInstance.displayErrorMessages(this.parent, "error.import", e.toString());
                }
                catch (Throwable throwable) {
                    Utils.closeStream(isConfig);
                    throw throwable;
                }
                Utils.closeStream(isConfig);
            }
        }
        Utils.closeStream(isConfig);
        Config.getInstance().storeDefault();
        GUIUtils.updateFontSizeFromConfig();
    }

    private JFileChooser createFileChooser() {
        JFileChooser chooser = FileChooserFactory.createFileChooser(new File(System.getProperty("user.home")));
        chooser.setPreferredSize(GUIUtils.createChooserDimension(this.parent));
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle(Messages.getString("import.file"));
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                String name = f.getName().toLowerCase();
                if (f.isDirectory()) {
                    return true;
                }
                return name.endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return "XML-File (*.xml)";
            }
        });
        return chooser;
    }
}

