/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.action;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.AbstractSignerAction;
import de.bos_bremen.ecard.client.action.IFDSelectionHandler;
import de.bos_bremen.ecard.client.gui.dialog.ErrorDialog;
import de.bos_bremen.ecard.client.model.error.SignerException;
import java.awt.Component;
import java.awt.event.ActionEvent;

public class IFDSelectionAction
extends AbstractSignerAction {
    private static final long serialVersionUID = 1L;
    private static final String ACTION_NAME_KEY = "action.ifd.selection";
    private transient IFDSelectionHandler handler;
    private String ifdTag;

    protected IFDSelectionAction(Component parent, IFDSelectionHandler handler, String ifdTag) {
        super(ACTION_NAME_KEY, parent);
        this.setKeyAndIcon(false);
        this.handler = handler;
        this.ifdTag = ifdTag;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LOG.trace("selected : {}", (Object)this.ifdTag);
        try {
            this.handler.ifdSelected(this.ifdTag);
        }
        catch (SignerException se) {
            if (this.ifdTag.contains("BNotK")) {
                String message = Messages.getString("dialog.error.import.bnotk.keystore.message");
                LOG.error("show error dialog : error.import.bnotk : {}\n", (Object)message, (Object)se);
                String details = null;
                if (se.getMessage().contains("BNotK card is required")) {
                    details = Messages.getString("dialog.error.import.bnotk.card.required");
                }
                ErrorDialog.showDialog(this.parent, "error.import.bnotk", message, details);
            }
            LOG.error("show error dialog : error.import : {}\n", (Object)Messages.getString("dialog.error.import.keystore.message"), (Object)se);
            ErrorDialog.showDialog(this.parent, "error.import", Messages.getString("dialog.error.import.keystore.message"), null);
        }
    }
}

