/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.action;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.AbstractSignerAction;
import de.bos_bremen.ecard.client.model.Document;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;

public class HelpAction
extends AbstractSignerAction {
    private static final long serialVersionUID = 1L;
    private static String HELP_ID = "";
    private static final String ACTION_NAME_KEY = "action.help";

    public HelpAction(Component parent) {
        super(ACTION_NAME_KEY, parent);
        this.setKeyAndIcon(true);
    }

    HelpAction(String keyname, Component parent) {
        super(keyname, parent);
        this.setKeyAndIcon(true);
    }

    public static void enableHelpKey(Component comp, String id) {
        HELP_ID = id;
    }

    public void setHelpId(String helpid) {
        HelpAction.enableHelpKey(this.parent, helpid);
    }

    public static String getHelpKey() {
        return HELP_ID;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String osName;
        Document documentInstance = Document.getInstance();
        LOG.debug("Try open Boreum help...");
        String signerHelp = System.getProperty("signer.helppath");
        if (signerHelp == null) {
            LOG.warn("signer.helppath is null. Erwartet -Dsigner.helppath=file:/[Path-to]/doc oder -Dsigner.helppath=/doc");
            return;
        }
        LOG.info("signer.helppath = {}", (Object)signerHelp);
        String helpsetFile = System.getProperty("helpset.file");
        if (helpsetFile == null) {
            LOG.warn("helpset.file is null. Expected helpset.file=/helpset_de/index.htm");
            return;
        }
        LOG.info("helpset.file = {}", (Object)helpsetFile);
        String helpDefault = signerHelp + helpsetFile;
        LOG.debug("helpDefault : {}", (Object)helpDefault);
        Object helpUrlDefault = helpDefault;
        LOG.debug("helpUrlDefault: {}", helpUrlDefault);
        if (!((String)helpUrlDefault).contains("file:/")) {
            helpUrlDefault = this.helpPathToUrl(helpDefault);
        }
        if (((osName = System.getProperty("os.name").toLowerCase()).contains(new StringBuffer("win")) || osName.contains(new StringBuffer("mac")) || osName.contains(new StringBuffer("linux"))) && ((String)helpUrlDefault).contains("file:/")) {
            String htmlContent = this.createTempHtmlContent((String)helpUrlDefault);
            try {
                File tempHelpFile = File.createTempFile("DataBoreumHelp", ".htm");
                LOG.info("tempHelpFile = {}", (Object)tempHelpFile.getAbsolutePath());
                PrintWriter pw = new PrintWriter(tempHelpFile, StandardCharsets.UTF_8.name());
                pw.write(htmlContent);
                pw.close();
                this.createDesktopOpenThread(tempHelpFile).start();
                this.createDeleteThread(tempHelpFile).start();
            }
            catch (IOException e) {
                LOG.error("show error : help.error : {}", (Object)e.getMessage());
                documentInstance.displayErrorMessages(documentInstance.getFrame(), "help.error", null);
                LOG.error((Object)e, (Throwable)e);
            }
        } else {
            LOG.error("{} : open failed {}", (Object)osName, (Object)helpDefault);
        }
    }

    private Thread createDesktopOpenThread(final File tempHelpFile) {
        return new Thread(){

            @Override
            public void run() {
                try {
                    AbstractSignerAction.LOG.debug("try Desktop open temp html...");
                    Desktop.getDesktop().open(tempHelpFile);
                    AbstractSignerAction.LOG.debug("Desktop open temp html : success");
                }
                catch (Exception e) {
                    AbstractSignerAction.LOG.debug("Desktop open temp html : failed : {}", (Object)e.getMessage());
                }
            }
        };
    }

    private String helpPathToUrl(String helpDefault) {
        LOG.debug("relativ path-string : {}", (Object)helpDefault);
        LOG.debug("user.dir = {}", (Object)System.getProperty("user.dir"));
        File helpIndex = new File(System.getProperty("user.dir"), helpDefault);
        LOG.debug("Absolute path to the helpset: {}", (Object)helpIndex.getAbsolutePath());
        String helpUrlDefault = "";
        try {
            helpUrlDefault = Paths.get(helpIndex.getAbsolutePath(), new String[0]).toUri().toURL().toString();
        }
        catch (MalformedURLException e) {
            LOG.debug("Path to URL failed: {}", (Object)e.getMessage());
        }
        LOG.debug("URL-String to the helpset: {}", (Object)helpUrlDefault);
        return helpUrlDefault;
    }

    private String createTempHtmlContent(String helpUrlDefault) {
        String html = "<HTML><HEAD><META HTTP-EQUIV='Refresh' CONTENT='0; URL=HELP_URL'></HEAD><BODY><a href=\"HELP_URL\" target=\"_self\" rel=\"help\">HELPURL_TIP</a></BODY></HTML>";
        String helpUrl = helpUrlDefault + (String)(HELP_ID.isEmpty() ? "" : "#t=" + HELP_ID);
        html = html.replace("HELP_URL", helpUrl);
        LOG.info("Refresh URL = {}", (Object)helpUrl);
        String helpUrlDescription = Messages.getString("help.url.tip");
        html = html.replace("HELPURL_TIP", helpUrlDescription);
        html = html.replace("\\", "/");
        return html;
    }

    private Thread createDeleteThread(final File tempHelpFile) {
        return new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e) {
                    AbstractSignerAction.LOG.error("", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                try {
                    Files.delete(tempHelpFile.toPath());
                }
                catch (IOException ex) {
                    tempHelpFile.deleteOnExit();
                }
            }
        };
    }
}

