/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.action;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.AbstractSignerAction;
import de.bos_bremen.ecard.client.gui.GUIUtils;
import de.bos_bremen.ecard.client.gui.view.component.filechooser.FileChooserFactory;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.util.XMLProperties;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class ExportConfigFileAction
extends AbstractSignerAction {
    private static final long serialVersionUID = 1L;
    private static final String ACTION_NAME_KEY = "action.export";

    protected ExportConfigFileAction(Component parent) {
        super(ACTION_NAME_KEY, parent);
        this.setKeyAndIcon(true);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.exportConfigFile();
    }

    public void exportConfigFile() {
        Document documentInstance = Document.getInstance();
        Config config = Config.getInstance();
        XMLProperties properties = documentInstance.getProcessFactory().getProperties();
        Config.getInstance().setProcessProperties(properties);
        Config.getInstance().storeDefault(false);
        try {
            File tempFile = config.getConfigFile();
            JFileChooser chooser = FileChooserFactory.createFileChooser(new File(System.getProperty("user.home")));
            chooser.setPreferredSize(GUIUtils.createChooserDimension(this.parent));
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    String name = f.getName().toLowerCase();
                    if (f.isDirectory()) {
                        return true;
                    }
                    return name.endsWith(".xml");
                }

                @Override
                public String getDescription() {
                    return "XML-Dokument";
                }
            });
            chooser.setCurrentDirectory(tempFile);
            chooser.setFileSelectionMode(0);
            chooser.setDialogTitle(Messages.getString("export.file"));
            if (chooser.showSaveDialog(this.parent) == 0) {
                File file = chooser.getSelectedFile();
                if (file.equals(tempFile)) {
                    documentInstance.displayErrorMessages(null, "export.error1", Messages.getString("dialog.export.error1"), null);
                } else {
                    if (!file.getName().endsWith(".xml")) {
                        file = new File(file.getAbsolutePath() + ".xml");
                    }
                    if (file.exists()) {
                        LOG.trace("Dialog file.exist ...");
                        int selection = documentInstance.showOptionDialog(documentInstance.getFrame(), "file.exist", 2, 3);
                        if (selection == 0) {
                            if (file.delete()) {
                                if (file.createNewFile()) {
                                    config.store(file, false);
                                    documentInstance.showMessageDialog(null, "export.ok");
                                } else {
                                    documentInstance.showMessageDialog(null, "export.error2");
                                }
                            } else {
                                documentInstance.showMessageDialog(null, "export.error2");
                            }
                        } else {
                            documentInstance.showMessageDialog(null, "export.error2");
                        }
                    } else if (file.createNewFile()) {
                        config.store(file, false);
                        documentInstance.showMessageDialog(null, "export.ok");
                    } else {
                        documentInstance.showMessageDialog(null, "export.error2");
                    }
                }
            }
        }
        catch (HeadlessException | IOException e) {
            documentInstance.showMessageDialog(null, "export.error2");
        }
    }
}

