/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.action;

import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.action.AbstractSignerAction;
import de.bos_bremen.ecard.client.control.step.Step;
import de.bos_bremen.ecard.client.model.ApplicationPolicy;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.FrameworkInstanceHandler;
import de.bos_bremen.ecard.client.model.FrameworkStatus;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.util.XMLProperties;
import java.awt.Component;
import java.awt.event.ActionEvent;

public class ExitAction
extends AbstractSignerAction {
    private static final String ACTION_NAME_KEY = "action.exit";
    private static final long serialVersionUID = 3471982482712100475L;

    ExitAction(Component parent) {
        super(ACTION_NAME_KEY, parent);
        this.setKeyAndIcon(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LOG.info("Boreum beenden.");
        LOG.info("delete boreum temp dir: {}", (Object)Step.getTempFolder());
        Utils.deleteRecursive(Step.getTempFolder(), true);
        if (Document.getInstance().displayRedundantMessages(this.parent, "exit", 2) != 0) {
            return;
        }
        Document documentInstance = Document.getInstance();
        if (ApplicationPolicy.hideAfterProcess.equals((Object)documentInstance.getApplicationPolicy())) {
            FrameworkInstanceHandler singleInstanceHandler = documentInstance.getSingleInstanceHandler();
            if (singleInstanceHandler != null) {
                if (documentInstance.getCurrentFrameworkState().equals((Object)FrameworkStatus.FrameworkState.working)) {
                    LOG.info("FrameworkState : {} -> cancelled ", (Object)Document.getInstance().getCurrentFrameworkState());
                    documentInstance.setCurrentFrameworkState(FrameworkStatus.FrameworkState.cancelled);
                }
                LOG.info("FrameworkState : {} ... hide", (Object)Document.getInstance().getCurrentFrameworkState());
                singleInstanceHandler.hide();
            }
        } else {
            Config.getInstance().removeAllListeners();
            XMLProperties properties = documentInstance.getProcessFactory().getProperties();
            Config.getInstance().setProcessProperties(properties);
            Config.getInstance().storeDefault();
            documentInstance.resetLastErrorObject();
            documentInstance.reportError(ErrorCode.ABORTED, false, new Object[0]);
        }
    }
}

