/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.action;

import de.bos_bremen.ci.asn1.x509.FlatCertificate;
import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.AbstractSignerAction;
import de.bos_bremen.ecard.client.gui.GUIUtils;
import de.bos_bremen.ecard.client.gui.view.component.filechooser.FileChooserFactory;
import de.bos_bremen.ecard.client.model.Document;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class CertificateSaveAction
extends AbstractSignerAction {
    private static final long serialVersionUID = 1L;
    private static final String ACTION_NAME_KEY = "action.savecertificate";
    private transient FlatCertificate cert;

    public CertificateSaveAction(Component parent, FlatCertificate cert) {
        super(ACTION_NAME_KEY, parent);
        this.setKeyAndIcon(true);
        this.cert = cert;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        JFileChooser filechooser = FileChooserFactory.defaultFileChooser();
        filechooser.setPreferredSize(GUIUtils.createChooserDimension(this.parent));
        filechooser.setAcceptAllFileFilterUsed(false);
        filechooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".cer") || f.getName().endsWith(".crt");
            }

            @Override
            public String getDescription() {
                return Messages.getString("action.savecertificate.filefilter.description");
            }
        });
        int value = filechooser.showSaveDialog(this.parent);
        if (value == 0) {
            File selectedFile = filechooser.getSelectedFile();
            if (selectedFile.getName().indexOf(".") == -1) {
                selectedFile = new File(selectedFile.getParentFile(), selectedFile.getName() + ".cer");
            }
            if (selectedFile.exists()) {
                if (Document.getInstance().displayRedundantMessages(this.parent, "savecertificate.overwrite", 2, 3, false) == 0) {
                    this.saveInto(selectedFile);
                }
            } else {
                this.saveInto(selectedFile);
            }
        }
    }

    private void saveInto(File file) {
        try (FileOutputStream fos = new FileOutputStream(file);){
            byte[] encoded = this.cert.getEncoded();
            fos.write(encoded);
            fos.flush();
        }
        catch (IOException e) {
            this.showSaveFailure();
            LOG.error((Object)e, (Throwable)e);
        }
    }

    private void showSaveFailure() {
        Document.getInstance().displayRedundantMessages(this.parent, "savecertificate.failure", 1, 0, true);
    }
}

