/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.action;

import de.bos_bremen.ci.asn1.x509.FlatCertificate;
import de.bos_bremen.ecard.client.action.AbstractResetSettingsAction;
import de.bos_bremen.ecard.client.action.AbstractSignerAction;
import de.bos_bremen.ecard.client.action.AliasSelectionAction;
import de.bos_bremen.ecard.client.action.AliasSelectionHandler;
import de.bos_bremen.ecard.client.action.CertificateSaveAction;
import de.bos_bremen.ecard.client.action.ChangeFontAction;
import de.bos_bremen.ecard.client.action.ConfigureAction;
import de.bos_bremen.ecard.client.action.ContextSensitiveHelpAction;
import de.bos_bremen.ecard.client.action.ExitAction;
import de.bos_bremen.ecard.client.action.ExportConfigFileAction;
import de.bos_bremen.ecard.client.action.HelpAction;
import de.bos_bremen.ecard.client.action.IFDSelectionAction;
import de.bos_bremen.ecard.client.action.IFDSelectionHandler;
import de.bos_bremen.ecard.client.action.ImportConfigFileAction;
import de.bos_bremen.ecard.client.action.InfoAction;
import de.bos_bremen.ecard.client.action.LicenceKeyDialogAction;
import de.bos_bremen.ecard.client.action.LoadKeyStoreAction;
import de.bos_bremen.ecard.client.action.LoadPDFSignatureImageAction;
import de.bos_bremen.ecard.client.action.ManageSubsequentProcessAction;
import de.bos_bremen.ecard.client.action.ProcessAction;
import de.bos_bremen.ecard.client.action.ProcessActionHandler;
import de.bos_bremen.ecard.client.action.RedisplayDialogsAction;
import de.bos_bremen.ecard.client.action.RemoveFileAction;
import de.bos_bremen.ecard.client.action.RemoveFileHandler;
import de.bos_bremen.ecard.client.action.RemoveKeyProvidersAction;
import de.bos_bremen.ecard.client.action.RemoveKeyProvidersHandler;
import de.bos_bremen.ecard.client.action.ResetCardAction;
import de.bos_bremen.ecard.client.action.ResetConfigFileAction;
import de.bos_bremen.ecard.client.action.SaveConfigFileAction;
import de.bos_bremen.ecard.client.action.SelectFileAction;
import de.bos_bremen.ecard.client.action.SelectLastCopyFolderAction;
import de.bos_bremen.ecard.client.action.SelectProcessAction;
import de.bos_bremen.ecard.client.action.SelectSignedFileAction;
import de.bos_bremen.ecard.client.action.SelectTargetFolderAction;
import de.bos_bremen.ecard.client.action.SelectTargetFolderHandler;
import de.bos_bremen.ecard.client.action.SelectTargetFolderSameAsSourceAction;
import de.bos_bremen.ecard.client.action.SelectedCertificateHandler;
import de.bos_bremen.ecard.client.action.SelectedFileHandler;
import de.bos_bremen.ecard.client.action.SendProtocolAction;
import de.bos_bremen.ecard.client.action.ShowCertificateAction;
import de.bos_bremen.ecard.client.action.ShowFileAction;
import de.bos_bremen.ecard.client.action.ShowProtocolAction;
import de.bos_bremen.ecard.client.action.SubsequentProcessHandler;
import de.bos_bremen.ecard.client.control.process.ProcessName;
import de.bos_bremen.ecard.client.gui.FontSize;
import de.bos_bremen.ecard.client.gui.view.component.table.action.ViewFilesAction;
import java.awt.Component;
import javax.swing.Action;

public class ActionFactory {
    private final AbstractSignerAction exitAction;
    private final AbstractSignerAction configureAction;
    private final AbstractSignerAction helpAction;
    private final AbstractSignerAction contextSensitiveHelpAction;
    private final AbstractSignerAction infoAction;
    private final AbstractSignerAction licenceKeyDialogAction;
    private final AbstractSignerAction redisplayDialogsAction;
    private AbstractSignerAction importConfigFileAction;
    private AbstractSignerAction exportConfigFileAction;
    private AbstractSignerAction resetConfigFileAction;
    private final AbstractSignerAction saveConfigFileAction;
    private Component parent;

    public ActionFactory(Component parentComponent) {
        this.parent = parentComponent;
        this.exitAction = this.createExitAction();
        this.configureAction = this.createConfigureAction();
        this.helpAction = this.createHelpAction();
        this.contextSensitiveHelpAction = this.createContextSensitiveHelpAction();
        this.infoAction = this.createInfoAction();
        this.licenceKeyDialogAction = this.createLicenceKeyDialogAction();
        this.redisplayDialogsAction = this.createRedisplayDialogsAction();
        this.importConfigFileAction = this.createImportConfigFileAction();
        this.exportConfigFileAction = this.createExportConfigFileAction();
        this.resetConfigFileAction = this.createResetConfigFileAction();
        this.saveConfigFileAction = this.createSaveConfigFileAction();
    }

    public AbstractSignerAction getExitAction() {
        return this.exitAction;
    }

    public AbstractSignerAction getConfigureAction() {
        return this.configureAction;
    }

    public AbstractSignerAction getHelpAction() {
        return this.helpAction;
    }

    public AbstractSignerAction getContextSensitiveHelpAction() {
        return this.contextSensitiveHelpAction;
    }

    public AbstractSignerAction getInfoAction() {
        return this.infoAction;
    }

    public AbstractSignerAction getLicenceDialogAction() {
        return this.licenceKeyDialogAction;
    }

    public AbstractSignerAction getRedisplayDialogsAction() {
        return this.redisplayDialogsAction;
    }

    public AbstractSignerAction getImportConfigFileAction() {
        return this.importConfigFileAction;
    }

    public AbstractSignerAction getExportConfigFileAction() {
        return this.exportConfigFileAction;
    }

    public AbstractSignerAction getResetConfigFileAction() {
        return this.resetConfigFileAction;
    }

    public AbstractSignerAction getSaveConfigFileAction() {
        return this.saveConfigFileAction;
    }

    public ResetCardAction createResetCardAction() {
        return new ResetCardAction(this.parent);
    }

    private AbstractSignerAction createConfigureAction() {
        return new ConfigureAction(this.parent);
    }

    private AbstractSignerAction createExitAction() {
        return new ExitAction(this.parent);
    }

    private AbstractSignerAction createHelpAction() {
        return new HelpAction(this.parent);
    }

    private AbstractSignerAction createContextSensitiveHelpAction() {
        return new ContextSensitiveHelpAction(this.parent);
    }

    private AbstractSignerAction createInfoAction() {
        return new InfoAction(this.parent);
    }

    private AbstractSignerAction createLicenceKeyDialogAction() {
        return new LicenceKeyDialogAction(this.parent);
    }

    private AbstractSignerAction createRedisplayDialogsAction() {
        return new RedisplayDialogsAction(this.parent);
    }

    private AbstractSignerAction createImportConfigFileAction() {
        return new ImportConfigFileAction(this.parent);
    }

    private AbstractSignerAction createExportConfigFileAction() {
        return new ExportConfigFileAction(this.parent);
    }

    private SaveConfigFileAction createSaveConfigFileAction() {
        return new SaveConfigFileAction(this.parent);
    }

    private AbstractSignerAction createResetConfigFileAction() {
        return new ResetConfigFileAction(this.parent);
    }

    public AbstractSignerAction createShowCertificateAction(SelectedCertificateHandler keyProviderHandler) {
        return new ShowCertificateAction(this.parent, keyProviderHandler);
    }

    public AbstractSignerAction createLoadSoftwareKeyStore(SelectedFileHandler handler, boolean loadPrivateKeys, boolean loadCertificates) {
        return new LoadKeyStoreAction(this.parent, handler, loadPrivateKeys, loadCertificates);
    }

    public AbstractSignerAction createIFDSelectionAction(IFDSelectionHandler handler, String terminalName) {
        return new IFDSelectionAction(this.parent, handler, terminalName);
    }

    public AbstractSignerAction createAliasSelectionAction(AliasSelectionHandler handler, String alias) {
        return new AliasSelectionAction(this.parent, handler, alias);
    }

    public Action createRemoveKeyProvidersAction(RemoveKeyProvidersHandler handler) {
        return new RemoveKeyProvidersAction(this.parent, handler);
    }

    public Action createSelectProcess(SelectedFileHandler handler) {
        return new SelectProcessAction(this.parent, handler);
    }

    public Action createSelectFile(SelectedFileHandler handler, String componentKey, int selectionMode, boolean enableMultiSelection, boolean mustExists) {
        return new SelectFileAction(componentKey, this.parent, handler, selectionMode, enableMultiSelection, mustExists);
    }

    public Action createSelectSignedFile(SelectedFileHandler handler, String key) {
        return new SelectSignedFileAction(key, this.parent, handler);
    }

    public Action createSelectTargetFolder(SelectTargetFolderHandler handler, String key) {
        return new SelectTargetFolderAction(key, this.parent, handler);
    }

    public Action createSelectLocalCopyFolder(SelectTargetFolderHandler handler, String key) {
        return new SelectLastCopyFolderAction(key, this.parent, handler);
    }

    public Action createSelectTargetFolderSameAsSource(SelectTargetFolderHandler handler, String key) {
        return new SelectTargetFolderSameAsSourceAction(key, this.parent, handler);
    }

    public Action createRemoveFile(RemoveFileHandler handler, String key) {
        return new RemoveFileAction(key, this.parent, handler);
    }

    public Action createManageSubsequentProcess(SubsequentProcessHandler subsequentProcessHandler) {
        return new ManageSubsequentProcessAction(this.parent, subsequentProcessHandler);
    }

    public Action createCertificateSaveAction(FlatCertificate cert) {
        return new CertificateSaveAction(this.parent, cert);
    }

    public Action createShowFileAction(ViewFilesAction viewFileAction) {
        return new ShowFileAction(this.parent, viewFileAction);
    }

    public Action createProcessAction(ProcessName processName, ProcessActionHandler handler) {
        return new ProcessAction(this.parent, processName, handler);
    }

    public Action getResetProcessSettingsAction(ProcessName processName) {
        return new AbstractResetSettingsAction(this.parent, processName);
    }

    public Action getResetProcessSettingsAction(ProcessName processName, boolean verbose) {
        return new AbstractResetSettingsAction(this.parent, processName, verbose);
    }

    public Component getParent() {
        return this.parent;
    }

    public void setParent(Component parent) {
        this.parent = parent;
    }

    public Action createLoadPDFSignatureImageAction(SelectedFileHandler handler) {
        return new LoadPDFSignatureImageAction(this.parent, handler);
    }

    public AbstractSignerAction createShowProtocolAction(boolean isForMenu) {
        return new ShowProtocolAction(this.parent, isForMenu);
    }

    public AbstractSignerAction createSendProtocolAction(boolean isForMenu) {
        return new SendProtocolAction(this.parent, isForMenu);
    }

    public HelpAction createContextSensitiveHelpAction(String key) {
        if (key != null && key.length() > 0) {
            return new ContextSensitiveHelpAction(this.parent, key);
        }
        return new ContextSensitiveHelpAction(this.parent);
    }

    public ChangeFontAction createChangeFontAction(boolean isForMenu, FontSize fontSize) {
        return new ChangeFontAction(this.parent, isForMenu, fontSize);
    }
}

