/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.action;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.gui.IconScalingUtils;
import de.bos_bremen.ecard.client.gui.MultiLineTooltips;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IconButtonUtil;
import java.awt.Component;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractSignerAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    protected final String actionKeyName;
    protected final Component parent;
    private String iconName = null;
    private ImageIcon icon = null;
    private ImageIcon rolloverIcon = null;
    private ImageIcon disabledIcon = null;
    protected static final Logger LOG = LogManager.getLogger(AbstractSignerAction.class);

    protected AbstractSignerAction(String messageKey, Component parentComponent) {
        super(Messages.getResource(messageKey) != null ? Messages.getString(messageKey) : (Messages.getResource(messageKey + ".text") != null ? Messages.getString(messageKey + ".text") : null));
        this.actionKeyName = messageKey;
        this.parent = parentComponent;
    }

    protected void setKeyAndIcon(boolean loadIcon) {
        String key = this.getActionKey();
        if (key != null) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(key));
        }
        this.iconName = null;
        if (loadIcon) {
            this.iconName = Messages.getResource(this.actionKeyName + ".icon");
        }
        this.icon = IconButtonUtil.getPropertyIcon(this.actionKeyName);
        this.rolloverIcon = IconButtonUtil.getRolloverIcon(this.actionKeyName);
        this.disabledIcon = IconScalingUtils.dimMultiResIcon(this.icon);
        this.putValue("SmallIcon", this.icon);
        char mnemonic = this.getMnemonic();
        if (mnemonic > '\u0000') {
            this.putValue("MnemonicKey", mnemonic);
        }
        String tooltip = Messages.getString(this.actionKeyName + ".tooltip", "");
        String wrappedTooltip = MultiLineTooltips.wrapToolTip(tooltip);
        if (!tooltip.isEmpty()) {
            this.putValue("ShortDescription", wrappedTooltip);
        }
    }

    private String getActionKey() {
        String actionKey = null;
        try {
            actionKey = Messages.getResource(this.actionKeyName + ".key");
        }
        catch (Exception ex) {
            actionKey = null;
        }
        return actionKey;
    }

    public char getMnemonic() {
        String mnemonicString = null;
        char mnemonic = '\u0000';
        try {
            mnemonicString = Messages.getString(this.actionKeyName + ".mnemonic");
            mnemonic = mnemonicString.charAt(0);
        }
        catch (Exception ex) {
            mnemonic = '\u0000';
        }
        return mnemonic;
    }

    public ImageIcon getRolloverIcon() {
        return this.rolloverIcon;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public ImageIcon getDisabledIcon() {
        return this.disabledIcon;
    }

    public ChangeListener createChangeListenerForMenuItem() {
        return changeEvent -> {
            if (this.getRolloverIcon() == null) {
                return;
            }
            Object patt5084$temp = changeEvent.getSource();
            if (patt5084$temp instanceof JMenuItem) {
                JMenuItem item = (JMenuItem)patt5084$temp;
                if (item.isArmed()) {
                    item.setIcon(this.getRolloverIcon());
                } else {
                    item.setIcon(this.getIcon());
                }
            }
        };
    }

    public String getActionKeyName() {
        return this.actionKeyName;
    }

    public boolean hasIcon() {
        return this.iconName != null;
    }
}

