/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.action;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.AbstractSignerAction;
import de.bos_bremen.ecard.client.control.process.ProcessFactory;
import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.control.process.ProcessName;
import de.bos_bremen.ecard.client.control.step.Step;
import de.bos_bremen.ecard.client.control.step.StepI;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.FrameworkStatus;
import de.bos_bremen.ecard.client.model.formular.process.ProcessFormular;
import de.bos_bremen.ecard.client.util.XMLProperties;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.List;

public class AbstractResetSettingsAction
extends AbstractSignerAction {
    private static final String ACTION_NAME_PREFIX_KEY = "action.reset.";
    private static final String ACTION_NAME_POSTFIX_KEY = "settings";
    private final transient ProcessName process;
    private static final long serialVersionUID = 3471982482712100475L;
    private boolean verbose = false;

    public AbstractResetSettingsAction(Component parent, ProcessName process) {
        super(ACTION_NAME_PREFIX_KEY + process.getName() + ACTION_NAME_POSTFIX_KEY, parent);
        this.process = process;
        this.setKeyAndIcon(true);
    }

    public AbstractResetSettingsAction(Component parent, ProcessName process, boolean verbose) {
        this(parent, process);
        this.verbose = verbose;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Document documentInstance = Document.getInstance();
        FrameworkStatus.FrameworkState currentFrameworkState = documentInstance.getCurrentFrameworkState();
        try {
            LOG.info("FrameworkState : {} -> initializing ", (Object)Document.getInstance().getCurrentFrameworkState());
            documentInstance.setCurrentFrameworkState(FrameworkStatus.FrameworkState.initializing);
            ProcessFactory processFactory = documentInstance.getProcessFactory();
            Config.getInstance().setProcessProperties(processFactory.getProperties());
            ProcessI processInstance = processFactory.getProcess(this.process);
            List<Step> steps = processInstance.getSteps();
            for (StepI stepI : steps) {
                XMLProperties fileProperties = Config.getInstance().getProcessProperties().extractPropertiesForNode(this.process.toString() + "/" + stepI.getStepName().getName());
                fileProperties.clear();
            }
            processFactory.setProperties(this.process, Config.getInstance().getProcessProperties());
            ProcessFormular processesFormular = processFactory.getProcessesFormular(processInstance);
            processesFormular.setDefault();
            if (!this.verbose) {
                String string2 = Messages.getString("dialog.reset.processsettings.message");
                string2 = MessageFormat.format(string2, this.process.getDisplayName());
                documentInstance.displayRedundantMessages(this.parent, "reset.processsettings", string2, 1, 1, true);
            }
            if (this.process != null && processFactory.getProcessChoose() != null && processFactory.getProcessChoose().getActiveProcess() != null && this.process.equals(processFactory.getProcessChoose().getActiveProcess())) {
                processFactory.getProcess(this.process).stopProcess();
                processFactory.getProcess(this.process).startProcess(processesFormular);
            }
        }
        finally {
            documentInstance.setCurrentFrameworkState(currentFrameworkState);
        }
    }
}

