/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client;

import de.bos_bremen.ci.Hex;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.cms.CMSSignedData;
import de.bos_bremen.ci_view.CIViewSwing;
import de.bos_bremen.ecard.client.control.process.ProcessName;
import de.bos_bremen.ecard.client.gui.ProcessChooseView;
import de.bos_bremen.ecard.client.gui.dialog.ErrorDialog;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.gov2.jca_provider.OCFProvider;
import de.governikus.csl.pdf.sign.impl.pdfbox.metadata.PDFMetaData;
import java.awt.Desktop;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Utils {
    private static final Logger LOG = LogManager.getLogger(Utils.class);
    private static final String OS_NAME = System.getProperties().getProperty("os.name").toLowerCase();
    private static final String[] FILE_EXTENSION_PKCS7 = new String[]{"p7", "p7s", "pkcs7"};
    public static final int BUFFER_SIZE = 8192;

    private Utils() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean notEmpty(String str) {
        return str != null && !"".equals(str);
    }

    public static boolean canWrite(String path) {
        if (path == null) {
            return false;
        }
        try {
            try {
                URI uri = new URI(path);
                if (uri.getScheme().startsWith("http")) {
                    return true;
                }
            }
            catch (Exception uri) {
                // empty catch block
            }
            File file = new File(path);
            if (!file.exists()) {
                return false;
            }
            if (!file.isDirectory()) {
                return false;
            }
            file = File.createTempFile("CanDelete", "txt", file);
            boolean result = Utils.isFileWriteable(file);
            if (file.exists()) {
                try {
                    Files.delete(file.toPath());
                }
                catch (IOException ex) {
                    LOG.debug("{} konnte nicht geloescht werden", (Object)file.getAbsolutePath());
                    file.deleteOnExit();
                }
            }
            return result;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isFileWriteable(File file) {
        try {
            FileOutputStream fos = new FileOutputStream(file, true);
            fos.close();
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public static boolean isDetachedSignature(File source) {
        try {
            return !new CMSSignedData(source).hasEnvelopedContent();
        }
        catch (ParseException e) {
            LOG.trace("{} - is detached signature ? -> false", (Object)source);
            LOG.trace(e.getMessage());
            return false;
        }
    }

    public static void openFile(File file) throws IOException {
        if (Desktop.isDesktopSupported()) {
            try {
                LOG.debug("Desktop open: {}", (Object)file);
                Desktop.getDesktop().open(file);
                return;
            }
            catch (IOException e) {
                LOG.error("Desktop Toolkit couldn't open file: {}", (Object)file.getAbsolutePath(), (Object)e);
                LOG.warn("Try open with cmd...");
            }
        }
        LOG.info("Opening file using Desktop did not work, try alternatives for OS: {}", (Object)OS_NAME);
        if (OS_NAME.contains("linux")) {
            LOG.debug("{}. Open file: {}", (Object)OS_NAME, (Object)file.getAbsolutePath());
            Utils.openFileLinux(file);
        } else if (OS_NAME.contains("windows")) {
            LOG.debug("{}. Open file: {}", (Object)OS_NAME, (Object)file.getAbsolutePath());
            Utils.openFileWindows(file);
        } else if (OS_NAME.contains("mac")) {
            LOG.debug("{}. Open file: {}", (Object)OS_NAME, (Object)file.getAbsolutePath());
            Utils.openFileMac(file);
        }
    }

    private static void openFileLinux(File file) throws IOException {
        String[] cmd = new String[]{"xdg-open", file.getAbsolutePath()};
        LOG.debug((Object)cmd);
        Runtime.getRuntime().exec(cmd);
    }

    private static void openFileWindows(File file) throws IOException {
        String[] cmd = new String[]{"explorer", file.getAbsolutePath()};
        LOG.debug((Object)cmd);
        Runtime.getRuntime().exec(cmd);
    }

    private static void openFileMac(File file) throws IOException {
        String[] cmd = new String[]{"open", file.getAbsolutePath()};
        LOG.debug((Object)cmd);
        Runtime.getRuntime().exec(cmd);
    }

    public static void printFile(File sourceFile) throws IOException {
        if (Desktop.isDesktopSupported()) {
            LOG.debug("try Desktop.print(..)");
            Desktop.getDesktop().print(sourceFile);
        } else {
            LOG.error("Konnte kein System finden zum Durcken fuer os.name= {}", (Object)OS_NAME);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean copyFile(File source, File target, boolean ignoreExists) {
        if (source == null || target == null) {
            return false;
        }
        if (!ignoreExists && target.exists()) {
            return false;
        }
        try (FileInputStream fis = new FileInputStream(source);){
            boolean bl;
            try (FileOutputStream fos = new FileOutputStream(target);){
                byte[] buffer = new byte[8192];
                int readBytes = fis.read(buffer);
                while (readBytes != -1) {
                    fos.write(buffer, 0, readBytes);
                    readBytes = fis.read(buffer);
                }
                bl = true;
            }
            return bl;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static boolean copyFile(File source, File target) {
        return Utils.copyFile(source, target, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFolderWriteable(File storeFile) {
        if (storeFile.isFile()) {
            storeFile = storeFile.getParentFile();
        }
        File testFolderFile = new File(storeFile, "test.lock");
        try {
            boolean bl;
            FileOutputStream ostr = new FileOutputStream(testFolderFile);
            try {
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ostr.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    LOG.error("", (Throwable)ex);
                    boolean bl2 = false;
                    return bl2;
                }
            }
            ostr.close();
            return bl;
        }
        finally {
            Utils.deleteRecursive(testFolderFile, false);
        }
    }

    public static String toURL(String host, String port, String path) {
        if (!((String)host).startsWith("http")) {
            host = "http://" + (String)host;
        }
        if (((String)host).endsWith("/")) {
            host = ((String)host).substring(0, ((String)host).lastIndexOf("/"));
        }
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        return (String)host + ":" + port + (String)path;
    }

    public static byte[] createSHA256Hash(File file) {
        LOG.info("");
        byte[] aSHA256Bytes = null;
        if (file == null) {
            return aSHA256Bytes;
        }
        if (!file.exists()) {
            return aSHA256Bytes;
        }
        if (!file.isFile()) {
            return aSHA256Bytes;
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            MessageDigest aMessageDigest = MessageDigest.getInstance("SHA-256", Document.getInstance().getSecurityProvider());
            byte[] buffer = new byte[8192];
            int readBytes = 0;
            while ((readBytes = fileInputStream.read(buffer)) > 0) {
                aMessageDigest.update(buffer, 0, readBytes);
            }
            aSHA256Bytes = aMessageDigest.digest();
        }
        catch (IOException ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        catch (NoSuchAlgorithmException ex) {
            LOG.error("Es konnte kein Algorithmus zur Erstellung eines SHA-1 Wertes gefunden werden");
        }
        return aSHA256Bytes;
    }

    public static boolean checkSHA(byte[] inReadSHA256, byte[] inCurrentSHA256) {
        return inCurrentSHA256 == null || inReadSHA256 != null && MessageDigest.isEqual(inReadSHA256, inCurrentSHA256);
    }

    public static void sendMail(String recipient, String subject, String body, File attachment) throws IOException, MessagingException {
        ArrayList<String> recipients = new ArrayList<String>();
        recipients.add(recipient);
        ArrayList<File> attachments = new ArrayList<File>();
        attachments.add(attachment);
        Utils.sendMail(recipients, subject, body, attachments);
    }

    public static void sendMail(List<String> to, String subject, String body, List<File> attachments) throws IOException, MessagingException {
        System.setProperty("mail.mime.encodeparameters", "false");
        MimeMessage msg = Utils.createMimeMessage(to, subject, body, attachments);
        msg.addHeader("X-Unsent", "1");
        final File eml = File.createTempFile("mail", ".eml");
        eml.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(eml);
        msg.writeTo((OutputStream)fos);
        fos.close();
        new Thread(){

            @Override
            public void run() {
                try {
                    Utils.openFile(eml);
                }
                catch (Exception e) {
                    ErrorDialog.showDialog(null, null, "Mail Error", "Error sending mail.", e.getLocalizedMessage());
                    Thread.currentThread().interrupt();
                }
            }
        }.start();
    }

    private static MimeMessage createMimeMessage(List<String> toList, String subject, String body, List<File> attachments) throws MessagingException {
        MimeMessage mail = new MimeMessage((Session)null);
        for (String to : toList) {
            if (to.startsWith("SMTP:")) {
                to = to.substring("SMTP:".length());
            }
            InternetAddress add = new InternetAddress(to);
            LOG.debug("to: {}", (Object)to);
            mail.setRecipient(Message.RecipientType.TO, (Address)add);
        }
        mail.setSubject(subject, "utf-8");
        LOG.debug("subject: {}", (Object)subject);
        mail.setSentDate(new Date());
        MimeMultipart mp = new MimeMultipart();
        LOG.debug("text: {}", (Object)body);
        if (body != null) {
            MimeBodyPart mbp1 = new MimeBodyPart();
            mbp1.setContent((Object)body, "text/plain; charset=utf-8");
            mp.addBodyPart((BodyPart)mbp1);
        }
        LOG.debug("attachment count: {}", (Object)attachments.size());
        for (File f : attachments) {
            MimeBodyPart mbp = new MimeBodyPart();
            mbp.setDataHandler(new DataHandler((DataSource)new FileDataSource(f)));
            try {
                mbp.setFileName(MimeUtility.encodeText((String)f.getName(), (String)"utf-8", null));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            mp.addBodyPart((BodyPart)mbp);
            LOG.debug(f.getAbsolutePath());
        }
        mail.setContent((Multipart)mp);
        return mail;
    }

    public static boolean isSamePath(String targetFolderStr, String parentFolderStr) {
        if (targetFolderStr != null && parentFolderStr != null) {
            return Utils.isSamePath(new File(targetFolderStr), new File(parentFolderStr));
        }
        return false;
    }

    public static boolean isSamePath(File targetFolder, String parentFolderStr) {
        if (targetFolder != null && parentFolderStr != null) {
            File parentFolder = new File(parentFolderStr);
            return Utils.isSamePath(targetFolder, parentFolder);
        }
        return false;
    }

    public static boolean isSamePath(String targetFolderStr, File parentFolder) {
        if (targetFolderStr != null && parentFolder != null) {
            File targetFolder = new File(targetFolderStr);
            return Utils.isSamePath(targetFolder, parentFolder);
        }
        return false;
    }

    public static boolean isSamePath(File targetFolder, File parentFolder) {
        if (targetFolder != null && parentFolder != null) {
            try {
                return targetFolder.getCanonicalPath().equalsIgnoreCase(parentFolder.getCanonicalPath());
            }
            catch (IOException ex) {
                return false;
            }
        }
        return false;
    }

    public static String htmlToAscii(String textHtml) {
        if (textHtml != null) {
            textHtml = Utils.parse(textHtml);
            textHtml = Utils.removeHTMLTAG(textHtml, "html");
            textHtml = Utils.removeHTMLTAG(textHtml, "body");
            textHtml = Utils.removeHTMLTAG(textHtml, "b");
            textHtml = Utils.removeHTMLTAG(textHtml, "i");
            textHtml = Utils.removeHTMLTAG(textHtml, "hr");
            textHtml = Utils.removeHTMLTAG(textHtml, "h1");
            textHtml = Utils.removeHTMLTAG(textHtml, "h2");
            textHtml = Utils.removeHTMLTAG(textHtml, "h3");
            textHtml = textHtml.replace(new StringBuilder("&uuml;"), new StringBuilder("\ufffd"));
            textHtml = textHtml.replace(new StringBuilder("&Uuml;"), new StringBuilder("&uuml;"));
            textHtml = textHtml.replace(new StringBuilder("&auml;"), new StringBuilder("\ufffd"));
            textHtml = textHtml.replace(new StringBuilder("&Auml;"), new StringBuilder("\ufffd"));
            textHtml = textHtml.replace(new StringBuilder("&ouml;"), new StringBuilder("\ufffd"));
            textHtml = textHtml.replace(new StringBuilder("&Ouml;"), new StringBuilder("\ufffd"));
            textHtml = textHtml.replace(new StringBuilder("&suml;"), new StringBuilder("\ufffd"));
            textHtml = textHtml.replace(new StringBuilder("<br>"), new StringBuilder("\n"));
            textHtml = textHtml.replace(new StringBuilder("<br/>"), new StringBuilder("\n"));
            return textHtml;
        }
        return "";
    }

    private static String removeHTMLTAG(String textHtml, String string) {
        textHtml = textHtml.replace(new StringBuilder("<" + string + ">"), new StringBuilder(""));
        textHtml = textHtml.replace(new StringBuilder("</" + string + ">"), new StringBuilder(""));
        textHtml = textHtml.replace(new StringBuilder("<" + string + "/>"), new StringBuilder(""));
        return textHtml;
    }

    private static String parse(String textHtml) {
        char[] charArray;
        StringBuilder builder = new StringBuilder();
        for (char c : charArray = textHtml.toCharArray()) {
            builder.append(c);
        }
        return builder.toString();
    }

    public static File getSecurityInstallDir() {
        String javaHome = System.getProperty("java.home");
        if (javaHome == null) {
            throw new SecurityException("error.installation.dir.not.found");
        }
        File f = new File(javaHome, "lib");
        f = new File(f, "security");
        return f;
    }

    public static void deleteRecursive(File dir, boolean deleteOnExit) {
        block4: {
            File[] files;
            if (dir.isDirectory() && (files = dir.listFiles()) != null) {
                for (File file : files) {
                    Utils.deleteRecursive(file, deleteOnExit);
                }
            }
            try {
                Files.delete(dir.toPath());
            }
            catch (IOException e) {
                if (!deleteOnExit) break block4;
                dir.deleteOnExit();
            }
        }
    }

    public static void deleteTempSignedFiles(File javaIoTempdir, String prefix) {
        LOG.trace("");
        if (javaIoTempdir == null) {
            return;
        }
        if (!javaIoTempdir.isDirectory()) {
            return;
        }
        File[] files = javaIoTempdir.listFiles();
        if (files == null) {
            return;
        }
        LOG.debug("try delete tmp pdf file start with '{}' in {}", (Object)prefix, (Object)javaIoTempdir);
        for (File file : files) {
            if (!file.getName().startsWith(prefix)) continue;
            try {
                LOG.trace("try delete tmp pdf file : {}", (Object)file.getName());
                Files.delete(file.toPath());
                LOG.debug("deleted tmp pdf file : {}", (Object)file.getName());
            }
            catch (IOException e) {
                LOG.error("try delete tmp pdf file on exit : {}", (Object)file.getName());
                file.deleteOnExit();
            }
        }
    }

    public static int getProxyPortAsInt(String value) {
        int result = 80;
        try {
            result = Integer.parseInt(value);
        }
        catch (Exception ex) {
            LOG.debug(ex.getMessage());
        }
        return result;
    }

    public static boolean moveFile(File src, File dest) {
        if (src == null || dest == null) {
            return false;
        }
        if (src.renameTo(dest)) {
            return true;
        }
        if (Utils.copyFile(src, dest)) {
            try {
                LOG.trace("try delete : {}", (Object)src.getAbsolutePath());
                Files.delete(src.toPath());
                LOG.debug("deleted : {}", (Object)src.getAbsolutePath());
            }
            catch (IOException e) {
                LOG.info("try delete on exit : {}", (Object)src.getAbsolutePath());
                src.deleteOnExit();
            }
            return true;
        }
        return false;
    }

    public static byte[] toByteArray(InputStream is) throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            Utils.toOutputStream(is, os);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    public static void toOutputStream(InputStream is, OutputStream os) throws IOException {
        Utils.toOutputStream(is, os, 8192);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toOutputStream(InputStream is, OutputStream os, int bufferSize) throws IOException {
        try {
            int bytesReaded;
            byte[] buffer = new byte[bufferSize];
            while ((bytesReaded = is.read(buffer)) != -1) {
                os.write(buffer, 0, bytesReaded);
            }
            os.flush();
        }
        finally {
            Utils.closeStream(is);
        }
    }

    public static void closeStream(Closeable stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException e) {
            LOG.error("can not close a stream", (Throwable)e);
        }
    }

    public static void closeConnection(HttpURLConnection con) {
        if (con == null) {
            return;
        }
        con.disconnect();
    }

    public static boolean isCMSFile(String value) {
        if (value == null || "".equals(value)) {
            return false;
        }
        value = value.toLowerCase();
        int index = value.lastIndexOf(46) + 1;
        CharSequence suffix = value.subSequence(index, value.length());
        for (String s : FILE_EXTENSION_PKCS7) {
            if (!s.contentEquals(suffix)) continue;
            return true;
        }
        return false;
    }

    public static void logInformation(Logger l) {
        Provider[] providers;
        l.info("Security provider: {}", (Object)Config.getSecurityProvider().getName());
        l.info("----------------------------");
        Provider ocf = Security.getProvider("OCF");
        Provider bc = Security.getProvider("BC");
        l.info("");
        l.info("+++++++++++++++++++++++++ Information +++++++++++++++++++++++++");
        l.info("+++");
        l.info("+++ Application: {}", (Object)Config.getComponentName());
        l.info("+++ Tag/Version: {}", (Object)Config.getComponentVersion());
        l.info("+++");
        l.info("");
        if (ocf != null) {
            l.info("+++ MCARD: {}", (Object)ocf.getName());
            l.info("+++ Tag/Version: {}", (Object)((OCFProvider)ocf).getComponentVersion());
            l.info("+++");
        }
        if (bc != null) {
            l.info("+++ Governikus Crypto Provider: {}", (Object)bc.getName());
            l.info("+++ SecurityProvider Info: {}", (Object)bc.getInfo());
            l.info("+++");
        }
        l.info("+++ {}", (Object)Hex.getComponentName());
        l.info("+++ Tag/Version: {}", (Object)Hex.getComponentVersion());
        l.info("+++");
        l.info("+++ {}", (Object)CIViewSwing.getComponentName());
        l.info("+++ Tag/Version: {}", (Object)CIViewSwing.getComponentVersion());
        l.info("+++");
        l.info("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        l.info("");
        l.info("----------------------------");
        for (Provider provider : providers = Security.getProviders()) {
            l.info("Provider: {}", (Object)provider.getName());
        }
        l.info("----------------------------");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean isEncrypted(File selectedPdfFile) {
        if (selectedPdfFile == null) {
            return false;
        }
        if ((double)selectedPdfFile.length() == 0.0) {
            return false;
        }
        if (!selectedPdfFile.getName().toLowerCase().endsWith("pdf")) {
            return false;
        }
        PDFMetaData pdfMetaData = null;
        FileInputStream fileInputStream = new FileInputStream(selectedPdfFile);
        pdfMetaData = new PDFMetaData((InputStream)fileInputStream);
        Utils.closeStream((Closeable)pdfMetaData);
        boolean bl = false;
        fileInputStream.close();
        Utils.closeStream((Closeable)pdfMetaData);
        return bl;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        boolean bl2 = e.getMessage().contains("Cannot decrypt PDF") || e.getMessage().contains("document encrypted") || e.getMessage().contains("document is encrypted") || e.getMessage().contains("document can not be read. Not pdf?");
                        Utils.closeStream((Closeable)pdfMetaData);
                        return bl2;
                    }
                }
                catch (Throwable throwable3) {
                    Utils.closeStream(pdfMetaData);
                    throw throwable3;
                }
            }
        }
    }

    public static ProcessName getActiveProcess() {
        Document documentInstance = Document.getInstance();
        ProcessChooseView processChooseView = documentInstance.getProcessFactory().getProcessChoose();
        return processChooseView.getActiveProcess();
    }
}

