/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client;

import de.bos_bremen.debug_mode.DebugLevel;
import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.AbstractSignerAction;
import de.bos_bremen.ecard.client.action.ActionFactory;
import de.bos_bremen.ecard.client.action.ProcessAction;
import de.bos_bremen.ecard.client.action.ProcessActionHandler;
import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.gui.ClientView;
import de.bos_bremen.ecard.client.gui.FontSize;
import de.bos_bremen.ecard.client.gui.GUIUtils;
import de.bos_bremen.ecard.client.gui.IconScalingUtils;
import de.bos_bremen.ecard.client.gui.MultiLineTooltips;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.CurvedBorder;
import de.bos_bremen.ecard.client.gui.view.component.LocaleChanger;
import de.bos_bremen.ecard.client.model.ApplicationPolicy;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.licence.ProductFunctions;
import java.awt.Cursor;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;

public class SignerMenuBar
extends JMenuBar {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle RES_BUNDLE = ResourceBundle.getBundle(SignerMenuBar.class.getName());
    private AbstractSignerAction showProtocolAction;
    private AbstractSignerAction sendProtocolAction;
    private final ClientView clientView;
    private final transient ProductFunctions productFunctions;
    private final transient ProcessActionHandler actionHandler;
    private final JRootPane rootPane;

    public SignerMenuBar(JRootPane rootPane, ClientView clientView, ProductFunctions productFunctions, ProcessActionHandler actionHandler) {
        this.rootPane = rootPane;
        this.clientView = clientView;
        this.productFunctions = productFunctions;
        this.actionHandler = actionHandler;
        this.makeReadable();
        this.makeFocusable();
        this.addKeyListener(ComponentUtils.createKeyListenerFor(this));
        if (productFunctions.enableGeneralMenu().isVisible()) {
            this.createFileMenu();
            this.createViewMenu();
            this.createConfigMenu();
            this.createHelpMenu();
        } else {
            this.createNoMenuActions();
        }
    }

    private void createNoMenuActions() {
        KeyStroke helpKeyStroke = KeyStroke.getKeyStroke(Messages.getString("action.contextsinsitivehelp.key"));
        this.rootPane.getInputMap(2).put(helpKeyStroke, "helpAction");
        this.rootPane.getActionMap().remove("helpAction");
        this.rootPane.getActionMap().put("helpAction", Document.getInstance().getActionFactory().getHelpAction());
    }

    private void createConfigMenu() {
        if (this.productFunctions.enableGeneralActions().isVisible()) {
            Document documentInstance = Document.getInstance();
            JMenu configMenu = new JMenu(Messages.getString("MenuName.config"));
            configMenu.setMnemonic(ComponentUtils.getMnemonic("MenuName.config"));
            configMenu.setToolTipText(Messages.getString("MenuName.config.tooltip"));
            if (this.productFunctions.enableGeneralActionsSettings().isVisible()) {
                AbstractSignerAction configureAction = documentInstance.getActionFactory().getConfigureAction();
                JMenuItem configItem = new JMenuItem(configureAction);
                configItem.addChangeListener(configureAction.createChangeListenerForMenuItem());
                configMenu.add(configItem);
                configureAction.setEnabled(this.productFunctions.enableGeneralActionsSettings().isEditable());
            }
            if (this.productFunctions.enableGeneralActionsSettings().isVisible()) {
                configMenu.addSeparator();
            }
            if (!documentInstance.isSaveConfig()) {
                AbstractSignerAction saveConfigAction = documentInstance.getActionFactory().getSaveConfigFileAction();
                JMenuItem saveConfigItem = configMenu.add(saveConfigAction);
                saveConfigItem.addChangeListener(saveConfigAction.createChangeListenerForMenuItem());
            }
            if (this.productFunctions.enableGeneralActionsImport().isVisible() && documentInstance.isSaveConfig()) {
                AbstractSignerAction importAction = documentInstance.getActionFactory().getImportConfigFileAction();
                JMenuItem importItem = new JMenuItem(importAction);
                importItem.addChangeListener(importAction.createChangeListenerForMenuItem());
                configMenu.add(importItem);
                importAction.setEnabled(this.productFunctions.enableGeneralActionsImport().isEditable());
            }
            if (this.productFunctions.enableGeneralActionsExport().isVisible()) {
                AbstractSignerAction exportAction = documentInstance.getActionFactory().getExportConfigFileAction();
                JMenuItem exportItem = new JMenuItem(exportAction);
                exportItem.addChangeListener(exportAction.createChangeListenerForMenuItem());
                configMenu.add(exportItem);
                exportAction.setEnabled(this.productFunctions.enableGeneralActionsImport().isEditable());
            }
            if (this.productFunctions.enableGeneralActionsReset().isVisible() && documentInstance.isSaveConfig()) {
                AbstractSignerAction resetAction = documentInstance.getActionFactory().getResetConfigFileAction();
                JMenuItem resetItem = new JMenuItem(resetAction);
                resetItem.addChangeListener(resetAction.createChangeListenerForMenuItem());
                configMenu.add(resetItem);
                resetAction.setEnabled(this.productFunctions.enableGeneralActionsReset().isEditable());
            }
            if (this.productFunctions.enableGeneralActionsExport().isVisible() || (this.productFunctions.enableGeneralActionsImport().isVisible() || this.productFunctions.enableGeneralActionsReset().isVisible()) && documentInstance.isSaveConfig()) {
                configMenu.addSeparator();
            }
            if (this.productFunctions.enableGeneralActionsSettingsProtocol().isVisible()) {
                Config c = Config.getInstance();
                DebugLevel pl = c.getProtocolLevel();
                boolean showProtocolActions = !pl.equals((Object)DebugLevel.none);
                this.showProtocolAction = documentInstance.getActionFactory().createShowProtocolAction(true);
                JMenuItem showProtocolItem = new JMenuItem(this.showProtocolAction);
                showProtocolItem.addChangeListener(this.showProtocolAction.createChangeListenerForMenuItem());
                configMenu.add(showProtocolItem);
                this.showProtocolAction.setEnabled(this.productFunctions.enableGeneralActionsSettingsProtocol().isEditable() && showProtocolActions);
                this.sendProtocolAction = documentInstance.getActionFactory().createSendProtocolAction(true);
                JMenuItem sendProtocolItem = new JMenuItem(this.sendProtocolAction);
                sendProtocolItem.addChangeListener(this.sendProtocolAction.createChangeListenerForMenuItem());
                configMenu.add(sendProtocolItem);
                this.sendProtocolAction.setEnabled(this.productFunctions.enableGeneralActionsSettingsProtocol().isEditable() && showProtocolActions);
            }
            this.add(configMenu);
        }
    }

    private void createHelpMenu() {
        ActionFactory actionFactory = Document.getInstance().getActionFactory();
        JMenu helpMenu = new JMenu(Messages.getString("MenuName.help"));
        helpMenu.setMnemonic(ComponentUtils.getMnemonic("MenuName.help"));
        AbstractSignerAction helpAction = actionFactory.getHelpAction();
        JMenuItem helpItem = new JMenuItem(helpAction);
        helpItem.addChangeListener(helpAction.createChangeListenerForMenuItem());
        helpMenu.add(helpItem);
        helpMenu.addSeparator();
        if (this.productFunctions.enableGeneralLicence().isVisible()) {
            AbstractSignerAction licenceAction = actionFactory.getLicenceDialogAction();
            JMenuItem licenceItem = new JMenuItem(licenceAction);
            licenceItem.addChangeListener(licenceAction.createChangeListenerForMenuItem());
            helpMenu.add(licenceItem);
            helpMenu.addSeparator();
        }
        AbstractSignerAction infoAction = actionFactory.getInfoAction();
        JMenuItem infoItem = new JMenuItem(infoAction);
        infoItem.addChangeListener(infoAction.createChangeListenerForMenuItem());
        helpMenu.add(infoItem);
        try {
            this.setHelpMenu(helpMenu);
        }
        catch (Throwable e) {
            this.add(helpMenu);
        }
    }

    private void createViewMenu() {
        JMenu viewMenu = new JMenu(Messages.getString("MenuName.view"));
        viewMenu.setMnemonic(ComponentUtils.getMnemonic("MenuName.view"));
        if (this.productFunctions.enableGeneralActions().isVisible()) {
            if (this.productFunctions.enableGeneralActionsSettingsLanguage().isVisible()) {
                this.createLanguageMenu(viewMenu);
                this.createFontMenu(viewMenu);
                viewMenu.addSeparator();
            }
            AbstractSignerAction redisplayAction = Document.getInstance().getActionFactory().getRedisplayDialogsAction();
            JMenuItem redisplayItem = viewMenu.add(redisplayAction);
            redisplayItem.addChangeListener(redisplayAction.createChangeListenerForMenuItem());
        }
        this.add(viewMenu);
    }

    private void createFileMenu() {
        JMenu fileMenu = new JMenu(Messages.getString("MenuName.file"));
        fileMenu.setMnemonic(ComponentUtils.getMnemonic("MenuName.file"));
        fileMenu.setToolTipText(Messages.getResource("MenuName.file.tooltip"));
        if (!Document.getInstance().getProductFunctions().enableGeneralIntegratedWS().isEditable()) {
            List<ProcessI> processes = Document.getInstance().getProcessFactory().getProcesses();
            boolean addSeparator = false;
            for (ProcessI processI : processes) {
                if (!processI.getLicenceTyp().isVisible() || processI.getProcessName().getProcessIndex() >= 4 || Document.getInstance().getApplicationPolicy().equals((Object)ApplicationPolicy.hideAfterProcess)) continue;
                addSeparator = true;
                ProcessAction processAction = (ProcessAction)Document.getInstance().getActionFactory().createProcessAction(processI.getProcessName(), this.actionHandler);
                JMenuItem processItem = new JMenuItem(processAction);
                processItem.addChangeListener(processAction.createChangeListenerForMenuItem());
                fileMenu.add(processItem);
                processItem.setEnabled(processI.getLicenceTyp().isEditable());
            }
            if (addSeparator) {
                fileMenu.addSeparator();
            }
        }
        AbstractSignerAction exitAction = Document.getInstance().getActionFactory().getExitAction();
        JMenuItem exitItem = new JMenuItem(exitAction);
        exitItem.addChangeListener(exitAction.createChangeListenerForMenuItem());
        fileMenu.add(exitItem);
        this.add(fileMenu);
    }

    private void createLanguageMenu(JMenu configMenu) {
        JMenu languageSubMenu = new JMenu(Messages.getString("config.dialog.language"));
        languageSubMenu.setMnemonic(ComponentUtils.getMnemonic("config.dialog.language"));
        languageSubMenu.addChangeListener(this.createChangeListener(languageSubMenu, "config.dialog.language.icon", "config.dialog.language.rollover.icon"));
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem germanLanguageItem = new JRadioButtonMenuItem(Locale.GERMAN.getDisplayLanguage(Locale.GERMAN));
        String key = Messages.getString("config.dialog.language.de.key");
        germanLanguageItem.setAccelerator(KeyStroke.getKeyStroke(key));
        germanLanguageItem.setIcon(IconScalingUtils.createMultiResIcon("config.dialog.language.de.icon"));
        JRadioButtonMenuItem englishLanguageItem = new JRadioButtonMenuItem(Locale.ENGLISH.getDisplayLanguage(Locale.ENGLISH));
        key = Messages.getString("config.dialog.language.en.key");
        englishLanguageItem.setAccelerator(KeyStroke.getKeyStroke(key));
        englishLanguageItem.setIcon(IconScalingUtils.createMultiResIcon("config.dialog.language.en.icon"));
        if (Config.getInstance().getLocale().equals(Locale.ENGLISH)) {
            englishLanguageItem.setSelected(true);
            germanLanguageItem.setSelected(false);
        } else {
            germanLanguageItem.setSelected(true);
            englishLanguageItem.setSelected(false);
        }
        System.setProperty("helpset.file", Messages.getString("helpset.file"));
        germanLanguageItem.addActionListener(e -> {
            Runnable t = () -> {
                Cursor defaultCursor = this.clientView.getCursor();
                this.rootPane.setCursor(Cursor.getPredefinedCursor(3));
                germanLanguageItem.setSelected(true);
                englishLanguageItem.setSelected(false);
                LocaleChanger.getInstance().setLocale(Locale.GERMAN, true);
                this.rootPane.setCursor(defaultCursor);
            };
            SwingUtilities.invokeLater(t);
        });
        englishLanguageItem.addActionListener(e -> {
            Runnable t = () -> {
                Cursor defaultCursor = this.clientView.getCursor();
                this.rootPane.setCursor(Cursor.getPredefinedCursor(3));
                germanLanguageItem.setSelected(false);
                englishLanguageItem.setSelected(true);
                LocaleChanger.getInstance().setLocale(Locale.ENGLISH, true);
                this.rootPane.setCursor(defaultCursor);
            };
            SwingUtilities.invokeLater(t);
        });
        group.add(germanLanguageItem);
        group.add(englishLanguageItem);
        languageSubMenu.add(germanLanguageItem);
        languageSubMenu.add(englishLanguageItem);
        configMenu.add(languageSubMenu);
        languageSubMenu.setEnabled(this.productFunctions.enableGeneralActionsSettingsLanguage().isEditable());
    }

    private void createFontMenu(JMenu configMenu) {
        JMenu fontSubMenu = new JMenu(Messages.getString("action.font.text"));
        fontSubMenu.addChangeListener(this.createChangeListener(fontSubMenu, "action.font.menu.icon", "action.font.menu.rollover.icon"));
        fontSubMenu.setMnemonic(ComponentUtils.getMnemonic("action.font.text"));
        JRadioButtonMenuItem smallFontItem = new JRadioButtonMenuItem(Messages.getString("action.font.small.text"));
        smallFontItem.addChangeListener(this.createChangeListener(smallFontItem, "action.font.menu.small.icon", "action.font.menu.small.rollover.icon"));
        String key = Messages.getString("action.font.small.key");
        smallFontItem.setAccelerator(KeyStroke.getKeyStroke(key));
        smallFontItem.setToolTipText(Messages.getString("action.font.small.tooltip"));
        JRadioButtonMenuItem normalFontItem = new JRadioButtonMenuItem(Messages.getString("action.font.normal.text"));
        normalFontItem.addChangeListener(this.createChangeListener(normalFontItem, "action.font.menu.normal.icon", "action.font.menu.normal.rollover.icon"));
        key = Messages.getString("action.font.normal.key");
        normalFontItem.setAccelerator(KeyStroke.getKeyStroke(key));
        normalFontItem.setToolTipText(Messages.getString("action.font.normal.tooltip"));
        JRadioButtonMenuItem bigFontItem = new JRadioButtonMenuItem(Messages.getString("action.font.big.text"));
        bigFontItem.addChangeListener(this.createChangeListener(bigFontItem, "action.font.menu.big.icon", "action.font.menu.big.rollover.icon"));
        key = Messages.getString("action.font.big.key");
        bigFontItem.setAccelerator(KeyStroke.getKeyStroke(key));
        bigFontItem.setToolTipText(Messages.getString("action.font.big.tooltip"));
        switch (Document.getInstance().getFontSize()) {
            case BIG: {
                bigFontItem.setSelected(true);
                break;
            }
            case SMALL: {
                smallFontItem.setSelected(true);
                break;
            }
            default: {
                normalFontItem.setSelected(true);
            }
        }
        smallFontItem.addActionListener(e -> {
            Runnable t = () -> this.changeFont(FontSize.SMALL);
            SwingUtilities.invokeLater(t);
        });
        normalFontItem.addActionListener(e -> {
            Runnable t = () -> {
                this.changeFont(FontSize.NORMAL);
                normalFontItem.setSelected(true);
            };
            SwingUtilities.invokeLater(t);
        });
        bigFontItem.addActionListener(e -> {
            Runnable t = () -> {
                this.changeFont(FontSize.BIG);
                bigFontItem.setSelected(true);
            };
            SwingUtilities.invokeLater(t);
        });
        ButtonGroup group = new ButtonGroup();
        group.add(smallFontItem);
        group.add(normalFontItem);
        group.add(bigFontItem);
        fontSubMenu.add(smallFontItem);
        fontSubMenu.add(normalFontItem);
        fontSubMenu.add(bigFontItem);
        configMenu.add(fontSubMenu);
        fontSubMenu.setEnabled(true);
    }

    private void changeFont(FontSize font) {
        Cursor defaultCursor = this.clientView.getCursor();
        this.clientView.setCursor(Cursor.getPredefinedCursor(3));
        Document.getInstance().setFontSize(font);
        GUIUtils.setSignerThemeInUIManager();
        LocaleChanger.getInstance().setLocale(Config.getInstance().getLocale(), true);
        this.clientView.setCursor(defaultCursor);
    }

    public Action getShowProtocolAction() {
        return this.showProtocolAction;
    }

    public Action getSendProtocolAction() {
        return this.sendProtocolAction;
    }

    private void makeFocusable() {
        this.setFocusable(true);
        this.setBorder(CurvedBorder.EMPTY_BORDER);
        this.addFocusListener(ComponentUtils.createFocusListenerFor(this));
    }

    private void makeReadable() {
        this.getAccessibleContext().setAccessibleName(RES_BUNDLE.getString("menubar.name"));
        String tooltipText = RES_BUNDLE.getString("menubar.tooltiptext");
        this.setToolTipText(MultiLineTooltips.wrapToolTip(tooltipText));
        this.getAccessibleContext().setAccessibleDescription(tooltipText);
    }

    public ChangeListener createChangeListener(JMenuItem menuItem, String iconKey, String hoverIconKey) {
        ImageIcon icon = IconScalingUtils.createMultiResIcon(iconKey);
        menuItem.setIcon(icon);
        ImageIcon hoverIcon = IconScalingUtils.createMultiResIcon(hoverIconKey);
        return changeEvent -> {
            Object patt20300$temp = changeEvent.getSource();
            if (patt20300$temp instanceof JMenuItem) {
                JMenuItem item = (JMenuItem)patt20300$temp;
                if (item.isArmed()) {
                    item.setIcon(hoverIcon);
                } else {
                    item.setIcon(icon);
                }
            }
        };
    }

    public ChangeListener createChangeListener(JMenu menu, String iconKey, String hoverIconKey) {
        ImageIcon icon = IconScalingUtils.createMultiResIcon(iconKey);
        menu.setIcon(icon);
        ImageIcon hoverIcon = IconScalingUtils.createMultiResIcon(hoverIconKey);
        return changeEvent -> {
            Object patt21177$temp = changeEvent.getSource();
            if (patt21177$temp instanceof JMenu) {
                JMenu jmenu = (JMenu)patt21177$temp;
                if (jmenu.isSelected() || jmenu.isArmed()) {
                    jmenu.setIcon(hoverIcon);
                } else {
                    jmenu.setIcon(icon);
                }
            }
        };
    }
}

