/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Messages {
    private static final Logger LOG = LogManager.getLogger(Messages.class);
    private static final String BUNDLE_NAME = "de.bos_bremen.ecard.client.messages";
    private static Map<ResourcesType, Map<ResourceBundle, String>> processResourceBundles = new HashMap<ResourcesType, Map<ResourceBundle, String>>();
    private static HashMap<String, String> messages = new HashMap();

    private Messages() {
    }

    public static String getString(String key) {
        String string = Messages.getResource(key);
        if (string != null) {
            return string;
        }
        return "!" + key + "!";
    }

    public static String getString(String key, String defaultValue) {
        return Messages.getResource(key, defaultValue);
    }

    private static String getProcessUserResource(String key) {
        String processUserRessource = Messages.getProcessUserResource(ResourcesType.project, key);
        if (processUserRessource == null && (processUserRessource = Messages.getProcessUserResource(ResourcesType.process, key)) == null) {
            processUserRessource = Messages.getProcessUserResource(ResourcesType.wizard, key);
        }
        return processUserRessource;
    }

    private static String getProcessUserResource(ResourcesType resourcesType, String key) {
        Map<ResourceBundle, String> map = processResourceBundles.get((Object)resourcesType);
        if (map != null) {
            for (ResourceBundle bundle : map.keySet()) {
                try {
                    return bundle.getString(key);
                }
                catch (MissingResourceException missingResourceException) {
                }
            }
        }
        return null;
    }

    public static String getResource(String key) {
        return Messages.getProcessUserResource(key);
    }

    public static String getResource(String key, String defaultValue) {
        String resource = Messages.getResource(key);
        if (resource == null) {
            resource = defaultValue;
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveUsed() {
        ArrayList<String> keys = new ArrayList<String>(messages.keySet());
        Collections.sort(keys);
        OutputStreamWriter fw = null;
        try {
            File tempFile = File.createTempFile("UsedProperties", ".txt");
            LOG.debug("SaveUsed: {}", (Object)tempFile.getAbsolutePath());
            fw = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), StandardCharsets.UTF_8);
            for (String key : keys) {
                fw.write(key + " = " + messages.get(key));
                fw.write("\n");
            }
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    LOG.debug("");
                }
            }
        }
    }

    public static void setLocale(Locale locale) {
        processResourceBundles.put(ResourcesType.wizard, Messages.updateResourceBundles(processResourceBundles.get((Object)ResourcesType.wizard), locale));
        processResourceBundles.put(ResourcesType.process, Messages.updateResourceBundles(processResourceBundles.get((Object)ResourcesType.process), locale));
        processResourceBundles.put(ResourcesType.project, Messages.updateResourceBundles(processResourceBundles.get((Object)ResourcesType.project), locale));
    }

    private static Map<ResourceBundle, String> updateResourceBundles(Map<ResourceBundle, String> resourceBundles, Locale locale) {
        if (resourceBundles != null) {
            Iterator<String> bundleNames = resourceBundles.values().iterator();
            HashMap<ResourceBundle, String> tmpProcessResourceBundles = new HashMap<ResourceBundle, String>();
            while (bundleNames.hasNext()) {
                String tmpBundleName = bundleNames.next();
                ResourceBundle resourceBundle = ResourceBundle.getBundle(tmpBundleName, locale);
                tmpProcessResourceBundles.put(resourceBundle, tmpBundleName);
            }
            resourceBundles.clear();
            resourceBundles.putAll(tmpProcessResourceBundles);
        }
        return resourceBundles;
    }

    public static void addResourceBundle(String bundleName, ResourceBundle bundle) {
        Map<ResourceBundle, String> processResourceHashMap = processResourceBundles.get((Object)ResourcesType.process);
        if (processResourceHashMap == null) {
            processResourceHashMap = new HashMap<ResourceBundle, String>();
        }
        processResourceHashMap.put(bundle, bundleName);
        processResourceBundles.put(ResourcesType.process, processResourceHashMap);
    }

    public static void addResourceBundle(ResourcesType resourcesType, String bundleName, ResourceBundle bundle) {
        Map<ResourceBundle, String> map = processResourceBundles.get((Object)resourcesType);
        if (map == null) {
            map = new HashMap<ResourceBundle, String>();
        }
        map.put(bundle, bundleName);
        processResourceBundles.put(resourcesType, map);
    }

    static {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(BUNDLE_NAME);
        Messages.addResourceBundle(ResourcesType.wizard, BUNDLE_NAME, resourceBundle);
    }

    public static enum ResourcesType {
        wizard,
        process,
        project;

    }
}

