/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client;

import de.bos_bremen.debug_mode.DebugLevel;
import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.SignerMenuBar;
import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.action.ActionFactory;
import de.bos_bremen.ecard.client.action.ProcessActionHandler;
import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.control.process.ProcessName;
import de.bos_bremen.ecard.client.control.step.Step;
import de.bos_bremen.ecard.client.control.step.working.WorkingStep;
import de.bos_bremen.ecard.client.gui.ClientView;
import de.bos_bremen.ecard.client.gui.GUIUtils;
import de.bos_bremen.ecard.client.gui.IconScalingUtils;
import de.bos_bremen.ecard.client.gui.SplashScreen;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.LocaleChanger;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.ConfigListener;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.FrameworkStatus;
import de.bos_bremen.ecard.client.model.ProcessPolicy;
import de.bos_bremen.ecard.client.model.ProcessSignedFile;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.error.SignerErrorHandler;
import de.bos_bremen.ecard.client.model.formular.process.ProcessFormular;
import de.bos_bremen.ecard.client.model.formular.steps.SelectSignedFilesFormular;
import de.bos_bremen.ecard.client.model.licence.ProductFunctions;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GUIClientStarter
extends JFrame
implements ProcessActionHandler,
PropertyChangeListener,
ConfigListener {
    private static final long serialVersionUID = -6766402540978133035L;
    private static final Logger LOG = LogManager.getLogger(GUIClientStarter.class);
    private ClientView clientView;
    private SignerMenuBar menubar;
    private SplashScreen splashScreen;

    public GUIClientStarter() {
        super(Messages.getString("application.name"));
        this.setSplashScreenVisible(true);
        this.createTrayIcon();
        Document.getInstance().setParent(this);
        this.setLookAndFeel();
        this.setDefaultCloseOperation(0);
    }

    private void createTrayIcon() {
        String trayIcon = null;
        try {
            trayIcon = System.getProperty("tray.icon");
        }
        catch (MissingResourceException ex) {
            LOG.debug("no tray.icon ist set in system properties");
        }
        if (trayIcon == null || trayIcon.isEmpty()) {
            super.setIconImage(ComponentUtils.getImage("application"));
        } else {
            try {
                super.setIconImage(IconScalingUtils.createMultiResIconFromImgSet("tray.icon").getImage());
            }
            catch (Exception e) {
                super.setIconImage(ComponentUtils.getImage("application"));
            }
        }
    }

    private void setLookAndFeel() {
        GUIUtils.setSignerThemeInUIManager();
    }

    private void initGUI() {
        if (Document.getInstance().getErrorHandler() == null) {
            Document.getInstance().setErrorHandler(new SignerErrorHandler(this));
        }
        LocaleChanger.getInstance().setLocale(Config.getInstance().getLocale(), false);
        Locale.setDefault(Config.getInstance().getLocale());
        this.setTitle(this.getSignerTitle());
        this.clientView = new ClientView();
        this.getContentPane().add(this.clientView);
        this.addWindowListener(this.getClientWindowListenerAction());
        ProductFunctions productFunctions = Document.getInstance().getProductFunctions();
        this.setJMenuBar(new SignerMenuBar(this.getRootPane(), this.clientView, productFunctions, this));
        LOG.trace("************** Boreum-Gr\u00f6\u00dfe ****************");
        LOG.trace("ScreenResolution : {}", (Object)Toolkit.getDefaultToolkit().getScreenResolution());
        LOG.trace("ScreenSize = maxSize : {}", (Object)Toolkit.getDefaultToolkit().getScreenSize());
        Dimension size = GUIUtils.createMainDialogDimension();
        this.setMinimumSize(size);
        this.setSize(size);
        this.setMaximumSize(GUIUtils.createMainMaxDimension());
        LOG.trace("Size min : {}", (Object)this.getMinimumSize());
        LOG.trace("Size --- : {}", (Object)this.getSize());
        LOG.trace("Size max : {}", (Object)this.getMaximumSize());
        LOG.trace("********************************************");
        this.setLocationRelativeTo(null);
    }

    public WindowListener getClientWindowListenerAction() {
        return new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                LOG.info("Boreum close");
                LOG.info("delete boreum temp dir : {}", (Object)Step.getTempFolder());
                Step.deleteTempFolder();
                if (!FrameworkStatus.FrameworkState.finished.equals((Object)Document.getInstance().getCurrentFrameworkState())) {
                    Document.getInstance().reportError(ErrorCode.ABORTED, false, new Object[0]);
                } else {
                    Document.getInstance().reportError(ErrorCode.OK, false, "");
                }
            }

            @Override
            public void windowActivated(WindowEvent e) {
                if (GUIClientStarter.this.getRootPane() != null) {
                    GUIClientStarter.this.getRootPane().revalidate();
                    GUIClientStarter.this.getRootPane().repaint();
                }
            }
        };
    }

    public void startInvisibleClient(boolean saveConfig) {
        LOG.debug("Start ... save config : {}", (Object)saveConfig);
        long startTime = System.currentTimeMillis();
        Document documentInstance = Document.getInstance();
        Config.init((Component)this, false);
        documentInstance.setSaveConfig(saveConfig);
        Utils.logInformation(LOG);
        this.initGUI();
        LocaleChanger.getInstance().addObserver(this);
        try {
            this.checkSecurityPolicies();
            this.setLookAndFeel();
            this.initMenuBar();
            Config.getInstance().addListener(this);
        }
        catch (Throwable t) {
            LOG.error("Error installing unlimited strength crypto files", t);
        }
        LOG.debug("Start : {} sec seit Boreum start", (Object)((double)(System.currentTimeMillis() - startTime) / 1000.0));
    }

    private void initMenuBar() {
        Locale locale = LocaleChanger.getInstance().getActualLocale();
        this.setLocale(locale);
        Document.getInstance().setActionFactory(new ActionFactory(this));
        this.setTitle(this.getSignerTitle());
        ProductFunctions productFunctions = Document.getInstance().getProductFunctions();
        this.setJMenuBar(new SignerMenuBar(this.getRootPane(), this.clientView, productFunctions, this));
        this.getJMenuBar().revalidate();
        this.repaint();
    }

    protected void checkSecurityPolicies() {
        LOG.info("");
        this.setSplashScreenVisible(false);
    }

    @Override
    public void startProcess(ProcessName process) {
        this.clientView.getProcessChooseView().showProcess(process);
    }

    public ClientView getClientView() {
        return this.clientView;
    }

    public boolean isSplashScreenVisible() {
        return this.splashScreen != null && this.splashScreen.isVisible();
    }

    public void setSplashScreenVisible(boolean visible) {
        if (visible) {
            if (this.splashScreen == null) {
                this.splashScreen = new SplashScreen((Component)this);
            }
            this.splashScreen.showWindow();
        } else {
            if (this.splashScreen == null) {
                return;
            }
            this.splashScreen.closeWindow();
            this.splashScreen = null;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.setLocale(LocaleChanger.getInstance().getActualLocale());
        Document.getInstance().setActionFactory(new ActionFactory(this));
        this.setTitle(this.getSignerTitle());
        ProductFunctions productFunctions = Document.getInstance().getProductFunctions();
        this.setJMenuBar(new SignerMenuBar(this.getRootPane(), this.clientView, productFunctions, this));
        this.getJMenuBar().revalidate();
        this.repaint();
    }

    private String getSignerTitle() {
        Boolean usePeriod = Config.getInstance().isUsePeriod();
        Long period = Config.getInstance().getPeriod();
        if (usePeriod.equals(Boolean.TRUE) && period <= 40L) {
            return Messages.getString("application.name") + " " + MessageFormat.format(Messages.getString("dialog.licencekey.trial.title"), period);
        }
        return Messages.getString("application.name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fillClientView(ProcessFormular processFormular, ProcessName processName, String licenceXML, ProcessPolicy processPolicy) {
        Document documentInstance;
        boolean fillFormular = false;
        Document document = documentInstance = Document.getInstance();
        synchronized (document) {
            block16: {
                ProcessI process;
                block15: {
                    SelectSignedFilesFormular selectSignedFilesFormular;
                    ProcessFormular oldProcessesFormular;
                    boolean filesExist = false;
                    List<ProcessSignedFile> selectedFiles = null;
                    process = documentInstance.getProcessFactory().getProcess(processName);
                    if (process != null && (oldProcessesFormular = documentInstance.getProcessFactory().getProcessesFormular(process)) instanceof SelectSignedFilesFormular && (selectSignedFilesFormular = (SelectSignedFilesFormular)((Object)oldProcessesFormular)).getSelectedFiles() != null && !selectSignedFilesFormular.getSelectedFiles().isEmpty()) {
                        selectedFiles = selectSignedFilesFormular.getSelectedFiles();
                        filesExist = true;
                    }
                    boolean isVisible = documentInstance.getFrame() != null && documentInstance.getFrame().isVisible();
                    boolean startOtherProzess = false;
                    if (isVisible && this.clientView.getProcessChooseView().getActiveProcess() != null && !this.clientView.getProcessChooseView().getActiveProcess().equals(processName)) {
                        switch (documentInstance.displayRedundantMessages(this, "change.process", MessageFormat.format(Messages.getString("change.process.message"), processName.getDisplayName(), this.clientView.getProcessChooseView().getActiveProcess().getDisplayName()), 2, 3, false)) {
                            case 0: {
                                startOtherProzess = true;
                                break;
                            }
                            default: {
                                LOG.info("return false");
                                return fillFormular;
                            }
                        }
                    }
                    if (FrameworkStatus.FrameworkState.processing.equals((Object)documentInstance.getCurrentFrameworkState())) {
                        LOG.info("return false");
                        return fillFormular;
                    }
                    if (!isVisible || this.clientView.getProcessChooseView().getActiveProcess() == null || startOtherProzess || !filesExist || !FrameworkStatus.FrameworkState.working.equals((Object)documentInstance.getCurrentFrameworkState())) break block15;
                    switch (documentInstance.displayRedundantMessages(this, "addfile", 3, 3, false)) {
                        case 0: {
                            LOG.info("Datei hinzuf\u00fcgen...");
                            if (processFormular instanceof SelectSignedFilesFormular) {
                                SelectSignedFilesFormular selectSignedFilesFormular2 = (SelectSignedFilesFormular)((Object)processFormular);
                                selectSignedFilesFormular2.getSelectedFiles().addAll(selectedFiles);
                            }
                            documentInstance.getProcessFactory().setProcessesFormularInstance(process, processFormular);
                            LOG.trace("");
                            break block16;
                        }
                        case 1: {
                            LOG.info("Datei nicht hinzuf\u00fcgen...");
                            documentInstance.getProcessFactory().setProcessesFormularInstance(process, processFormular);
                            LOG.trace("");
                            break block16;
                        }
                        default: {
                            LOG.info("Abbrechen/Schliessen");
                            return fillFormular;
                        }
                    }
                }
                LOG.debug("sign: call fillFormular");
                documentInstance.getProcessFactory().setProcessesFormularInstance(process, processFormular);
                fillFormular = true;
                LOG.debug("sign:fillFormular returned {}", (Object)fillFormular);
            }
            if (fillFormular) {
                LOG.info("show Process sign");
                documentInstance.getProcessFactory().getProcessChoose().showProcess(processName);
                documentInstance.getProductFunctions().loadDynamicLicence(licenceXML);
                this.setupProcessPolicy(processPolicy);
            }
            LOG.info("sign: formular filled : {}", (Object)fillFormular);
        }
        return fillFormular;
    }

    public void setupProcessPolicy(ProcessPolicy processPolicy) {
        Document documentInstance = Document.getInstance();
        documentInstance.setProcessPolicy(processPolicy);
        ProcessName aktivProcess = documentInstance.getProcessFactory().getProcessChoose().getActiveProcess();
        if (aktivProcess == null) {
            return;
        }
        ProcessI process = documentInstance.getProcessFactory().getProcess(aktivProcess);
        if (ProcessPolicy.firstStep.equals((Object)processPolicy)) {
            while (process.hasPreviousStep()) {
                process.previousStep();
            }
            process.setCurrentStep(process.getCurrentStep().getStepName().getName());
            return;
        }
        if (ProcessPolicy.skipCompletedStep.equals((Object)processPolicy) || ProcessPolicy.lastStep.equals((Object)processPolicy)) {
            while (process.hasNextStep()) {
                process.nextStep();
            }
            if (!process.getCurrentStep().isStateComplete() && process.hasPreviousStep()) {
                do {
                    process.previousStep();
                } while (process.getCurrentStep().isStateComplete() && process.hasPreviousStep());
            }
            process.setCurrentStep(process.getCurrentStep().getStepName().getName());
            return;
        }
        if (ProcessPolicy.runProcess.equals((Object)processPolicy) && process.canProcess() && process.canRunProcess()) {
            process.getProcessFormular().notifyAllChangeListener();
            while (process.hasNextStep()) {
                process.nextStep();
            }
            process.setCurrentStep(process.getCurrentStep().getStepName().getName());
            if (documentInstance.getFrame() != null) {
                documentInstance.getFrame().setVisible(true);
                GUIUtils.updateFontSizeFromConfig();
                documentInstance.getFrame().setAlwaysOnTop(true);
                documentInstance.getFrame().setAlwaysOnTop(false);
            }
            SwingUtilities.invokeLater(((WorkingStep)process.getCurrentStep())::run);
        }
    }

    @Override
    public void configChanged() {
        if (this.menubar == null) {
            return;
        }
        DebugLevel dl = Config.getInstance().getProtocolLevel();
        if (dl.equals((Object)DebugLevel.none)) {
            this.menubar.getSendProtocolAction().setEnabled(false);
            this.menubar.getShowProtocolAction().setEnabled(false);
        } else {
            this.menubar.getSendProtocolAction().setEnabled(true);
            this.menubar.getShowProtocolAction().setEnabled(true);
        }
    }
}

