/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client;

import de.bos_bremen.ecard.client.URLConnector;
import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.gui.MultiLineTooltips;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.error.SignerException;
import de.governikus.csl.SignerValidationProcessor;
import de.governikus.csl.server.ProxyServer;
import de.governikus.csl.transport.HttpClient;
import de.governikus.csl.transport.HttpHeader;
import de.governikus.csl.transport.HttpRequest;
import de.governikus.csl.transport.HttpResponse;
import de.governikus.csl.transport.ResponseData;
import de.governikus.csl.transport.entity.multipart.AbstractMultipartFormBodyPart;
import de.governikus.csl.transport.entity.multipart.MultipartFormBodyPart;
import de.governikus.csl.transport.entity.multipart.MultipartFormRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import javax.swing.JFrame;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommonsUrlConnector
implements URLConnector {
    private static final Logger LOG = LogManager.getLogger(CommonsUrlConnector.class);
    static File tempFile = null;
    private DateFormat aDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");

    public CommonsUrlConnector(JFrame inParent) {
    }

    public static File getTempDir() {
        if (tempFile == null) {
            try {
                tempFile = Files.createTempDirectory("governikusSignerTmp", new FileAttribute[0]).toFile();
            }
            catch (IOException e) {
                tempFile = new File(System.getProperty("java.io.tmpdir"));
            }
            tempFile.deleteOnExit();
        }
        return tempFile;
    }

    @Override
    public File getFile(URL url, String localFileName) throws SignerException {
        if (localFileName == null || localFileName.equals("")) {
            LOG.debug("localFileName == \"\"");
            localFileName = URLDecoder.decode(url.toString(), StandardCharsets.UTF_8);
            LOG.debug("localFileName.decode = {}", (Object)localFileName);
            if (localFileName.indexOf("://") != -1) {
                localFileName = localFileName.substring(localFileName.indexOf("://") + 3);
            }
            LOG.debug("localFileName = {}", (Object)localFileName);
            localFileName = localFileName.replace('.', '_');
            LOG.debug("localFileName = {} ", (Object)localFileName);
            localFileName = localFileName.replace('/', '_');
            LOG.debug("localFileName = {} ", (Object)localFileName);
        }
        return this.getFile(url, new File(CommonsUrlConnector.getTempDir(), localFileName));
    }

    /*
     * Loose catch block
     */
    @Override
    public File getFile(URL url, File localFile) throws SignerException {
        InputStream rcIn;
        HttpResponse response;
        block15: {
            int status;
            FileOutputStream outSt;
            block14: {
                LOG.info("url: {}", (Object)url);
                LOG.info("local file: {}", (Object)localFile);
                ProxyServer proxyServer = Config.getInstance().getProxyServer();
                if (proxyServer != null) {
                    LOG.trace("ProxyServer : {}", (Object)proxyServer);
                    proxyServer.evalAutoConfigUrl(url.toString());
                    LOG.info("ProxyServer f\u00fcr URL {} \n gefunden : {}", (Object)url, (Object)proxyServer);
                    SignerValidationProcessor.getInstance().setProxyServer(proxyServer);
                }
                response = null;
                rcIn = null;
                outSt = new FileOutputStream(localFile);
                HttpClient httpClient = SignerValidationProcessor.getInstance().getHttpClient();
                LOG.trace((Object)SignerValidationProcessor.getInstance().getProxyConfiguration());
                response = httpClient.get(url.toURI(), new HttpHeader[0]);
                status = response.getStatus();
                if (status != 404) break block14;
                LOG.error("Status 404. Die angeforderte Datei wurde auf dem Server nicht gefunden: {}", (Object)url);
                LOG.error("Download Tempdatei ist leer: {}", (Object)localFile.getAbsolutePath());
                String urlMessage = MultiLineTooltips.wrappString(url.toString(), 80);
                Document.getInstance().reportError(ErrorCode.FILE_NOT_FOUND, false, urlMessage);
                File file = localFile;
                ((OutputStream)outSt).close();
                Utils.closeStream(rcIn);
                Utils.closeStream((Closeable)response);
                return file;
            }
            try {
                if (status != 200) {
                    LOG.warn("Wird erwartet 200. Unerwartete Antwort {} auf die Anfrage: {}", (Object)status, (Object)url);
                }
                rcIn = response.getContent();
                byte[] buf = new byte[8192];
                long startTime = System.currentTimeMillis();
                int read = rcIn.read(buf);
                while (read != -1) {
                    ((OutputStream)outSt).write(buf, 0, read);
                    read = rcIn.read(buf);
                }
                long duration = System.currentTimeMillis() - startTime;
                LOG.trace("Download {} 1024*8 duration: {}ms", (Object)localFile.getName(), (Object)duration);
                break block15;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                finally {
                    ((OutputStream)outSt).close();
                }
            }
            catch (Exception e) {
                try {
                    throw new SignerException(ErrorCode.CONNECTION_ERROR, url.toString(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    Utils.closeStream(rcIn);
                    Utils.closeStream(response);
                    throw throwable;
                }
            }
        }
        Utils.closeStream(rcIn);
        Utils.closeStream((Closeable)response);
        return localFile;
    }

    @Override
    public void sendGet(URL url, String[] parameterName, String[] parameterValue) throws SignerException {
        LOG.info("get url: {}", (Object)url);
        ProxyServer proxyServer = Config.getInstance().getProxyServer();
        if (proxyServer != null) {
            LOG.trace("Config ProxyServer: {}", (Object)proxyServer);
            proxyServer.evalAutoConfigUrl(url.toString());
            LOG.info("ProxyServer f\u00fcr URL {} \n in PAC gefunden : {}", (Object)url, (Object)proxyServer);
            SignerValidationProcessor.getInstance().setProxyServer(proxyServer);
        }
        InputStream rcIn = null;
        String getParameter = "";
        boolean uriHasAlreadyParameter = url.toExternalForm().indexOf("?") != -1;
        StringBuilder st = new StringBuilder();
        for (int i = 0; i < parameterName.length; ++i) {
            st.append(i == 0 && !uriHasAlreadyParameter ? "?" : "&");
            st.append(parameterName[i] + "=" + parameterValue[i]);
        }
        getParameter = st.toString();
        getParameter = getParameter.replace(" ", "%20");
        String neueURI = url.toExternalForm() + getParameter;
        try {
            HttpClient httpClient = SignerValidationProcessor.getInstance().getHttpClient();
            rcIn = httpClient.get(new URI(neueURI), new HttpHeader[0]).getContent();
            byte[] buf = new byte[4096];
            StringBuilder strBuf = new StringBuilder();
            long startTime = System.currentTimeMillis();
            int read = rcIn.read(buf);
            while (read != -1) {
                String readedBytes = new String(buf, 0, read, StandardCharsets.UTF_8);
                strBuf.append(readedBytes);
                read = rcIn.read(buf);
            }
            long duration = System.currentTimeMillis() - startTime;
            LOG.trace("SendGet 1024*4 duration: {}ms", (Object)duration);
            LOG.debug((CharSequence)strBuf);
        }
        catch (IOException | IllegalArgumentException | URISyntaxException e) {
            try {
                throw new SignerException(ErrorCode.CONNECTION_ERROR, url.toString(), (Throwable)e);
            }
            catch (Throwable throwable) {
                Utils.closeStream(rcIn);
                throw throwable;
            }
        }
        Utils.closeStream(rcIn);
    }

    @Override
    public String sendPost(URL url, String parameterName, File fileToSend) throws SignerException {
        LOG.info("url: {}", (Object)url);
        LOG.info("file to send: {}", (Object)fileToSend);
        ProxyServer proxyServer = Config.getInstance().getProxyServer();
        if (proxyServer != null) {
            LOG.trace("ProxyServer: {}", (Object)proxyServer);
            proxyServer.evalAutoConfigUrl(url.toString());
            LOG.info("ProxyServer f\u00fcr URL {} \n in PAC gefunden : {}", (Object)url, (Object)proxyServer);
            SignerValidationProcessor.getInstance().setProxyServer(proxyServer);
        }
        LinkedHashMap<Object, Object> paramMap = new LinkedHashMap<Object, Object>();
        String params = url.getFile();
        if (params.indexOf("?") != -1) {
            params = params.substring(url.getFile().indexOf("?") + 1);
            do {
                LOG.trace("");
                String paramKey = params.substring(0, params.indexOf("="));
                params = params.substring(params.indexOf("=") + 1);
                String paramValue = null;
                if (params.indexOf("&") != -1) {
                    paramValue = params.substring(0, params.indexOf("&"));
                    params = params.substring(params.indexOf("&") + 1);
                } else {
                    paramValue = params;
                    params = null;
                }
                paramMap.put(paramKey, paramValue);
            } while (params != null);
        }
        LOG.trace("");
        paramMap.put("size", String.valueOf(fileToSend.length()));
        Date tmpDate = new Date(fileToSend.lastModified());
        paramMap.put("modified", this.aDateFormat.format(tmpDate));
        paramMap.put(parameterName + "0", fileToSend.getName());
        String boundary = "----------------------------" + Long.toHexString(new Random().nextLong());
        paramMap.put("Content-type", "multipart/form-data; boundary=" + boundary);
        LOG.trace("");
        String postResponseStr = null;
        try {
            int cnt;
            LOG.trace("");
            int buffer = this.calculateBufferFor(fileToSend.length());
            byte[] tmp = new byte[buffer];
            ByteArrayOutputStream baos = new ByteArrayOutputStream(buffer);
            baos.write(("--" + boundary + "\r\n").getBytes());
            baos.write("Content-Disposition: form-data; name=\"storage_dir\"\r\n\r\n".getBytes());
            baos.write(((String)((HashMap)paramMap).get("storage_dir") + "\r\n").getBytes());
            baos.write(("--" + boundary + "\r\n").getBytes());
            baos.write("Content-Disposition: form-data; name=\"size\"\r\n\r\n".getBytes());
            baos.write(((String)((HashMap)paramMap).get("size") + "\r\n").getBytes());
            baos.write(("--" + boundary + "\r\n").getBytes());
            baos.write("Content-Disposition: form-data; name=\"modified\"\r\n\r\n".getBytes());
            baos.write(((String)((HashMap)paramMap).get("modified") + "\r\n").getBytes());
            baos.write(("--" + boundary + "\r\n").getBytes());
            baos.write(("Content-Disposition: form-data; name=\"" + parameterName + "0\"; filename=\"" + fileToSend.getName() + "\"\r\nContent-Type: application/octet-stream\r\n\r\n").getBytes());
            FileInputStream in = new FileInputStream(fileToSend);
            long startTime = System.currentTimeMillis();
            while ((cnt = in.read(tmp)) > -1) {
                baos.write(tmp, 0, cnt);
            }
            in.close();
            baos.write(("\r\n--" + boundary + "--\r\n\r\n").getBytes());
            baos.close();
            long duration = System.currentTimeMillis() - startTime;
            LOG.trace("read for fileSave 1024*8 {} duration: {}ms ", (Object)fileToSend.getName(), (Object)duration);
            paramMap.remove("size");
            paramMap.remove("storage_dir");
            paramMap.remove("modified");
            paramMap.remove(parameterName + "0");
            HttpClient httpClient = SignerValidationProcessor.getInstance().getHttpClient();
            LOG.trace("send post ... {}", (Object)url);
            LOG.trace("... \u00fcber proxy : {}", (Object)SignerValidationProcessor.getInstance().getProxyConfiguration());
            startTime = System.currentTimeMillis();
            ResponseData response = httpClient.sendPOSTRequest(url.toString(), paramMap, baos.toByteArray());
            duration = System.currentTimeMillis() - startTime;
            LOG.trace("send post for fileSave 1024*8 {} duration: {}ms ", (Object)fileToSend.getName(), (Object)duration);
            LOG.trace("send post ok");
            try (ByteArrayInputStream is = new ByteArrayInputStream(response.getResponse());){
                LOG.trace("");
                postResponseStr = this.getResponseAsString(is);
            }
            LOG.info(postResponseStr);
        }
        catch (FileNotFoundException e) {
            throw new SignerException(ErrorCode.FILE_NOT_FOUND, fileToSend.toString(), (Throwable)e);
        }
        catch (IOException e) {
            throw new SignerException(ErrorCode.CONNECTION_ERROR, url.toString(), (Throwable)e);
        }
        return postResponseStr;
    }

    private int calculateBufferFor(long fileLength) {
        int length = (int)fileLength;
        int buffer = 8192;
        return length < buffer ? length : buffer;
    }

    @Override
    public String sendPost(URL url, String[] parameterNames, String[] parameterValues) throws SignerException {
        LOG.info("url: {}", (Object)url);
        LOG.trace(parameterNames[0]);
        LOG.trace(parameterValues[0]);
        ProxyServer proxyServer = Config.getInstance().getProxyServer();
        if (proxyServer != null) {
            LOG.trace("Config ProxyServer: {}", (Object)proxyServer);
            proxyServer.evalAutoConfigUrl(url.toString());
            LOG.info("ProxyServer f\u00fcr URL gefunden: \n{} \n -> {}", (Object)proxyServer, (Object)url);
            SignerValidationProcessor.getInstance().setProxyServer(proxyServer);
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String params = url.getFile();
        if (params.indexOf("?") != -1) {
            params = params.substring(url.getFile().indexOf("?") + 1);
            do {
                String paramKey = params.substring(0, params.indexOf("="));
                params = params.substring(params.indexOf("=") + 1);
                String paramValue = null;
                if (params.indexOf("&") != -1) {
                    paramValue = params.substring(0, params.indexOf("&"));
                    params = params.substring(params.indexOf("&") + 1);
                } else {
                    paramValue = params;
                    params = null;
                }
                paramMap.put(paramKey, paramValue);
            } while (params != null);
        }
        MultipartFormRequest request = new MultipartFormRequest();
        for (int i = 0; i < parameterValues.length; ++i) {
            paramMap.put(parameterNames[i], parameterValues[i]);
            request.addBodyPart((MultipartFormBodyPart)new StringBodyPart(parameterValues[i], parameterNames[i]));
        }
        HttpHeader[] header = new HttpHeader[paramMap.size()];
        int ptr = 0;
        for (Map.Entry entry : paramMap.entrySet()) {
            header[ptr++] = new HttpHeader((String)entry.getKey(), (String)entry.getValue());
        }
        String postResponseStr = null;
        try {
            HttpClient httpClient = SignerValidationProcessor.getInstance().getHttpClient();
            LOG.trace("httpClient.post ...");
            HttpResponse response = httpClient.post(url.toURI(), (HttpRequest)request, header);
            LOG.trace("httpClient.post : ok");
            try (InputStream is = response.getContent();){
                LOG.trace("is ...");
                postResponseStr = this.getResponseAsString(is);
                LOG.trace("is : ok");
            }
            LOG.debug("Response: {}", (Object)postResponseStr);
        }
        catch (Exception e) {
            throw new SignerException(ErrorCode.CONNECTION_ERROR, url.toString(), (Throwable)e);
        }
        return postResponseStr;
    }

    private String getResponseAsString(InputStream istr) throws IOException {
        try {
            String string;
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                byte[] buf = new byte[4096];
                int read = istr.read(buf);
                while (read != -1) {
                    bos.write(buf, 0, read);
                    read = istr.read(buf);
                }
                string = new String(bos.toByteArray(), StandardCharsets.UTF_8);
            }
            return string;
        }
        finally {
            Utils.closeStream(istr);
        }
    }

    public static HttpURLConnection setupHTTPConnection(URL url, Proxy proxy) throws IOException {
        Proxy p = proxy != null ? proxy : Proxy.NO_PROXY;
        HttpURLConnection con = (HttpURLConnection)url.openConnection(p);
        con.setInstanceFollowRedirects(true);
        con.setConnectTimeout(1000);
        con.setRequestProperty("accept", "application/x-ns-proxy-autoconfig, */*;q=0.8");
        return con;
    }

    class StringBodyPart
    extends AbstractMultipartFormBodyPart {
        private String value;

        public StringBodyPart(String value, String name) {
            super(name);
            this.value = value;
            this.contentType = "application/octet-stream";
            this.contentTransferEncoding = "UTF-8";
        }

        protected void writeBody(OutputStream outstream) throws IOException {
            try (ByteArrayInputStream bais = new ByteArrayInputStream(this.value.getBytes(StandardCharsets.UTF_8));){
                IOUtils.copy((InputStream)bais, (OutputStream)outstream);
            }
        }
    }
}

