/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client;

import de.governikus.csl.SignerValidationProcessor;
import de.governikus.csl.proxy.NettingsDialog;
import de.governikus.csl.remote.sign.bnotk.BNotKHttpFacade;
import de.governikus.csl.server.ProxyServer;
import de.governikus.csl.transport.AcceptAllTrustStrategy;
import de.governikus.csl.transport.ApacheHttpClient;
import de.governikus.csl.transport.ApacheHttpEntityFacade;
import de.governikus.csl.transport.ApacheHttpResponse;
import de.governikus.csl.transport.HttpHeader;
import de.governikus.csl.transport.HttpRequest;
import de.governikus.csl.transport.HttpResponse;
import de.governikus.csl.transport.TransportFactoryConfiguration;
import de.governikus.csl.transport.TrustedCertHostnameVerifier;
import de.governikus.csl.transport.TrustedCertTrustStrategy;
import de.governikus.csl.transport.exception.ConnectionException;
import de.governikus.csl.transport.proxy.ProxyExceptionsResolver;
import de.governikus.csl.uom.configuration.ProxyConfiguration;
import java.io.IOException;
import java.net.URI;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.InvalidCredentialsException;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.UserTokenHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.PrivateKeyStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoreumHttpClient
extends ApacheHttpClient
implements BNotKHttpFacade {
    private static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String AUTHORIZATION = "Authorization";
    private static final int MAX_CONNECTIONS = 16384;
    private static final Logger LOG = LoggerFactory.getLogger(BoreumHttpClient.class);
    protected CloseableHttpClient httpclient;
    private TransportFactoryConfiguration config;
    private final List<String> proxyAuthPrefs;
    private HttpHost proxy;
    private BasicCredentialsProvider proxyCredsProvider;
    private ProxyExceptionsResolver proxyExceptionResolver = new ProxyExceptionsResolver();
    private static HashMap<String, String> authHeaders = new HashMap();

    public BoreumHttpClient(TransportFactoryConfiguration config) {
        this(config, null, null);
        LOG.trace("");
    }

    public BoreumHttpClient(TransportFactoryConfiguration config, String extJceProviderName, KeyStore extClientKeyStore) {
        super(config);
        this.config = config;
        LOG.trace("");
        this.proxyAuthPrefs = new ArrayList<String>();
        this.proxyAuthPrefs.add("Basic");
        this.proxyAuthPrefs.add("NTLM");
        SSLContextBuilder sslContextBuilder = SSLContextBuilder.create();
        sslContextBuilder.setProtocol("TLSv1.2");
        DefaultHostnameVerifier hostNameVerifier = new DefaultHostnameVerifier();
        if (!config.getTrustedServerCerts().isEmpty()) {
            LOG.debug("trying to add trusted certificate(s)");
            try {
                sslContextBuilder.loadTrustMaterial(null, (TrustStrategy)new TrustedCertTrustStrategy(config.getTrustedServerCerts()));
            }
            catch (KeyStoreException | NoSuchAlgorithmException e) {
                LOG.error("Couldn't add trusted certificates", (Throwable)e);
            }
            hostNameVerifier = new TrustedCertHostnameVerifier(config.getTrustedServerCerts());
        } else if (config.isAcceptAllSSLServerCertificates()) {
            LOG.warn("All server certificates are accepted for ssl connections. This is a security breach");
            try {
                sslContextBuilder.loadTrustMaterial(null, (TrustStrategy)new AcceptAllTrustStrategy());
            }
            catch (KeyStoreException | NoSuchAlgorithmException e) {
                LOG.error("Couldn't add AcceptAllTrustStrategy", (Throwable)e);
            }
            hostNameVerifier = new NoopHostnameVerifier();
        }
        if (extClientKeyStore == null) {
            LOG.trace("");
            KeyStore clientKeystore = config.getClientKeystore();
            if (clientKeystore != null) {
                LOG.debug("trying to add keymaterial");
                try {
                    String clientKeyAlias;
                    PrivateKeyStrategy keySelector = null;
                    char[] keyPw = null;
                    String clientKeyPassword = config.getClientKeyPassword();
                    if (clientKeyPassword != null) {
                        keyPw = clientKeyPassword.toCharArray();
                    }
                    if ((clientKeyAlias = config.getClientKeyAlias()) != null) {
                        keySelector = (x, y) -> clientKeyAlias;
                    }
                    sslContextBuilder.loadKeyMaterial(clientKeystore, keyPw, keySelector);
                }
                catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                    LOG.error("Couldn't add keymaterial", (Throwable)e);
                }
            }
        }
        LOG.trace("");
        SSLContext sslContext = null;
        try {
            if (extJceProviderName != null && !extJceProviderName.isBlank()) {
                sslContextBuilder.setProvider(extJceProviderName);
                sslContextBuilder.loadKeyMaterial(extClientKeyStore, null);
            }
            sslContext = sslContextBuilder.build();
        }
        catch (Exception e) {
            LOG.error("Couldnt' create SSLContex", (Throwable)e);
        }
        ProxyConfiguration proxyConfiguration = config.getProxyConfiguration();
        if (proxyConfiguration != null) {
            LOG.trace("");
            this.prepareProxySettingsX(proxyConfiguration);
        }
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostNameVerifier);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslConnectionSocketFactory).register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        connManager.setMaxTotal(16384);
        connManager.setDefaultMaxPerRoute(config.getMaxConnectionsPerHost());
        UserTokenHandler userTokenHandler = new UserTokenHandler(){

            public Object getUserToken(HttpContext context) {
                return null;
            }
        };
        this.httpclient = HttpClients.custom().disableAutomaticRetries().setDefaultCredentialsProvider((CredentialsProvider)this.proxyCredsProvider).setUserTokenHandler(userTokenHandler).setConnectionManager((HttpClientConnectionManager)connManager).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
        LOG.trace("");
    }

    private void prepareProxySettingsX(ProxyConfiguration proxyConfiguration) {
        LOG.trace("");
        String proxyHost = proxyConfiguration.getProxyHost();
        if (proxyHost == null || proxyHost.isEmpty()) {
            LOG.trace("Kein ProxyHost.");
            return;
        }
        int proxyPort = proxyConfiguration.getProxyPort();
        LOG.info("csl config proxy: ({}:{})", (Object)proxyHost, (Object)proxyPort);
        this.proxy = new HttpHost(proxyHost, proxyPort);
        LOG.trace("csl proxy user:passwort ?");
        String proxyUser = proxyConfiguration.getUsername();
        String proxyPassword = proxyConfiguration.getPassword();
        if (proxyUser != null && !proxyUser.isEmpty()) {
            LOG.info("csl config proxy username:password used ...");
            this.proxyCredsProvider = new BasicCredentialsProvider();
            this.proxyCredsProvider.setCredentials(new AuthScope(proxyHost, proxyPort, AuthScope.ANY_REALM, "Basic"), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
            this.proxyCredsProvider.setCredentials(new AuthScope(proxyHost, proxyPort, AuthScope.ANY_REALM, "NTLM"), (Credentials)new NTCredentials(proxyUser, proxyPassword, null, null));
        } else {
            LOG.trace("csl proxyConfiguration ohne user:passw bzw. noch nicht bekannt");
        }
        List proxyExceptions = proxyConfiguration.getProxyExceptions();
        if (proxyExceptions != null && !proxyExceptions.isEmpty()) {
            this.proxyExceptionResolver.addProxyExceptions(proxyExceptions);
        }
    }

    private boolean useProxyX(URI url) {
        LOG.trace("");
        return this.proxy != null && this.proxyExceptionResolver.isProxyRequired(url.getHost());
    }

    private RequestConfig getRequestConfigX(URI url) {
        LOG.trace("");
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectionRequestTimeout(this.config.getConnectionManagerTimeout()).setConnectTimeout(this.config.getConnectionTimeout()).setSocketTimeout(this.config.getSocketTimeout());
        if (this.useProxyX(url)) {
            requestConfigBuilder.setProxy(this.proxy).setProxyPreferredAuthSchemes(this.proxyAuthPrefs);
        }
        return requestConfigBuilder.build();
    }

    public HttpResponse delete(URI uri, HttpHeader ... headers) throws ConnectionException {
        LOG.trace("");
        HttpDelete httpDelete = new HttpDelete(uri);
        httpDelete.setConfig(this.getRequestConfigX(uri));
        this.addHeaderX((HttpUriRequest)httpDelete, headers);
        this.addAuthHeader((HttpRequestBase)httpDelete, uri);
        HttpClientContext context = HttpClientContext.create();
        if (this.proxyCredsProvider != null) {
            context.setCredentialsProvider((CredentialsProvider)this.proxyCredsProvider);
        }
        try {
            return new ApacheHttpResponse(this.doRequest((HttpRequestBase)httpDelete, context, null, headers));
        }
        catch (Exception e) {
            throw new ConnectionException(uri, (Throwable)e);
        }
    }

    public HttpResponse post(URI uri, HttpRequest entity, HttpHeader ... headers) throws ConnectionException {
        LOG.trace("");
        return new ApacheHttpResponse(this.postIt(uri, entity, headers));
    }

    public CloseableHttpResponse postIt(URI uri, HttpRequest entity, HttpHeader ... headers) throws ConnectionException {
        LOG.trace("");
        HttpPost ppostRequest = new HttpPost(uri);
        ppostRequest.setConfig(this.getRequestConfigX(uri));
        ApacheHttpEntityFacade ae = null;
        if (entity != null) {
            ae = new ApacheHttpEntityFacade(entity){

                public boolean isRepeatable() {
                    return true;
                }
            };
            ppostRequest.setEntity((HttpEntity)ae);
        }
        this.addHeaderX((HttpUriRequest)ppostRequest, headers);
        this.addAuthHeader((HttpRequestBase)ppostRequest, uri);
        HttpClientContext context = HttpClientContext.create();
        if (this.proxyCredsProvider != null) {
            context.setCredentialsProvider((CredentialsProvider)this.proxyCredsProvider);
        }
        try {
            LOG.trace("");
            return this.doRequest((HttpRequestBase)ppostRequest, context, ae, headers);
        }
        catch (Exception e) {
            throw new ConnectionException(uri, (Throwable)e);
        }
    }

    public HttpResponse put(URI uri, HttpRequest entity, HttpHeader ... headers) throws ConnectionException {
        LOG.trace("");
        return new ApacheHttpResponse(this.putIt(uri, entity, headers));
    }

    public CloseableHttpResponse putIt(URI uri, HttpRequest entity, HttpHeader ... headers) throws ConnectionException {
        LOG.trace("");
        HttpPut putRequest = new HttpPut(uri);
        putRequest.setConfig(this.getRequestConfigX(uri));
        ApacheHttpEntityFacade ae = null;
        if (entity != null) {
            ae = new ApacheHttpEntityFacade(entity){

                public boolean isRepeatable() {
                    return true;
                }
            };
            putRequest.setEntity((HttpEntity)ae);
        }
        this.addHeaderX((HttpUriRequest)putRequest, headers);
        this.addAuthHeader((HttpRequestBase)putRequest, uri);
        HttpClientContext context = HttpClientContext.create();
        if (this.proxyCredsProvider != null) {
            context.setCredentialsProvider((CredentialsProvider)this.proxyCredsProvider);
        }
        try {
            return this.doRequest((HttpRequestBase)putRequest, context, ae, headers);
        }
        catch (Exception e) {
            throw new ConnectionException(uri, (Throwable)e);
        }
    }

    private String addAuthHeader(HttpRequestBase req, URI uri) {
        LOG.trace("");
        String[] p = uri.getPath().split("\\/");
        String uriContextPath = uri.getHost() + ":" + uri.getPort() + "/" + (p.length > 1 ? p[1] : "");
        if (authHeaders.containsKey(uriContextPath)) {
            req.addHeader(AUTHORIZATION, authHeaders.get(uriContextPath));
        }
        return uriContextPath;
    }

    public HttpResponse get(URI uri, HttpHeader ... headers) throws ConnectionException {
        LOG.trace("");
        return new ApacheHttpResponse(this.getIt(uri, headers));
    }

    public CloseableHttpResponse getIt(URI uri, HttpHeader ... headers) throws ConnectionException {
        LOG.trace("");
        HttpGet getRequest = new HttpGet(uri);
        getRequest.setConfig(this.getRequestConfigX(uri));
        this.addHeaderX((HttpUriRequest)getRequest, headers);
        this.addAuthHeader((HttpRequestBase)getRequest, uri);
        HttpClientContext context = HttpClientContext.create();
        if (this.proxyCredsProvider != null) {
            LOG.trace("proxy user/passw used...");
            context.setCredentialsProvider((CredentialsProvider)this.proxyCredsProvider);
        }
        try {
            return this.doRequest((HttpRequestBase)getRequest, context, null, headers);
        }
        catch (Exception e) {
            throw new ConnectionException(uri, (Throwable)e);
        }
    }

    public CloseableHttpResponse doRequest(HttpRequestBase request, HttpClientContext context, ApacheHttpEntityFacade entity, HttpHeader ... headers) throws IOException, InvalidCredentialsException {
        URI uri = request.getURI();
        LOG.trace("request uri : {}", (Object)uri);
        String uriContextPath = this.addAuthHeader(request, uri);
        String httpHeaders = this.toString(request.getAllHeaders());
        LOG.trace("HttpRequest Headers : \n{}", (Object)httpHeaders);
        LOG.trace("httpclient execute ...");
        CloseableHttpResponse response = this.httpclient.execute((HttpUriRequest)request, (HttpContext)context);
        httpHeaders = this.toString(response.getAllHeaders());
        LOG.trace("HttpResponse Headers : \n{}", (Object)httpHeaders);
        LOG.trace("httpclient execute ok");
        LOG.trace("request uri ok : {}", (Object)uri);
        int code = response.getStatusLine().getStatusCode();
        LOG.info("First HTTP return code: {}", (Object)code);
        while (code == 401 || code == 407) {
            LOG.info("HTTP return code: {}", (Object)code);
            LOG.info("Proxy auth state: {}", (Object)context.getProxyAuthState());
            request.releaseConnection();
            LOG.info("Configured proxyhost: '{}'", (Object)SignerValidationProcessor.getInstance().getProxyConfiguration().getProxyHost());
            if (code == 407) {
                LOG.warn("'407 Proxy Authentication Required'. Warte auf die Eingabe der Proxy-Zugangsdaten...");
                ProxyServer ps = SignerValidationProcessor.getInstance().getProxyConfiguration();
                NettingsDialog d = new NettingsDialog(ps.getProxyHost(), ps.getProxyPort(), uri.toURL());
                d.setVisible(true);
                LOG.trace("");
                int result = d.getResult();
                if (result != 0) {
                    ps.setUsername(null);
                    ps.setPassword(null);
                    LOG.trace("ValidationProcessor set ProxyServer : {}", (Object)ps);
                    LOG.warn("Der Benutzer hat die Eingabe der Proxy-Zugangsdaten abgebrochen.");
                    SignerValidationProcessor.getInstance().setProxyServer(ps);
                    throw new InvalidCredentialsException("Authentication cancelled for proxy " + ps.getProxyHost() + ":" + ps.getProxyPort());
                }
                ps.setUsername(d.getUser());
                ps.setPassword(d.getPassword());
                LOG.info("user/password used.");
                SignerValidationProcessor.getInstance().setProxyServer(ps);
                this.prepareProxySettingsX(ps);
                if (request instanceof HttpGet) {
                    request = new HttpGet(uri);
                } else if (request instanceof HttpPost) {
                    HttpPost r = new HttpPost(uri);
                    r.setEntity((HttpEntity)entity);
                    request = r;
                } else if (request instanceof HttpPut) {
                    HttpPut r = new HttpPut(uri);
                    r.setEntity((HttpEntity)entity);
                    request = r;
                } else if (request instanceof HttpDelete) {
                    request = new HttpDelete(uri);
                }
                request.setConfig(this.getRequestConfigX(uri));
                this.addHeaderX((HttpUriRequest)request, headers);
                if (authHeaders.containsKey(uriContextPath)) {
                    request.addHeader(AUTHORIZATION, authHeaders.get(uriContextPath));
                }
                context = HttpClientContext.create();
                if (this.proxyCredsProvider != null) {
                    context.setCredentialsProvider((CredentialsProvider)this.proxyCredsProvider);
                }
            } else if (response.containsHeader(WWW_AUTHENTICATE) && response.getHeaders(WWW_AUTHENTICATE)[0].getValue().startsWith("Basic")) {
                LOG.trace("WWW-Authenticate : Basic");
                NettingsDialog d = new NettingsDialog(uri.getHost(), uri.getPort(), uri.toURL(), false);
                d.setVisible(true);
                LOG.trace("");
                int result = d.getResult();
                if (result != 0) {
                    authHeaders.remove(uriContextPath);
                    throw new InvalidCredentialsException("Authentication cancelled for URL " + uri);
                }
                String method = response.getHeaders(WWW_AUTHENTICATE)[0].getValue().trim();
                int i = method.indexOf("charset=");
                String encoding = "US-ASCII";
                if (i > -1 && (encoding = method.substring(i + 8)).toUpperCase().contains("UTF-8")) {
                    encoding = "UTF-8";
                }
                method = method.substring(0, method.indexOf(32));
                String header = method + " " + Base64.getEncoder().encodeToString((d.getUser() + ":" + new String(d.getPassword())).getBytes(encoding));
                if (request.containsHeader(AUTHORIZATION)) {
                    request.removeHeaders(AUTHORIZATION);
                }
                authHeaders.put(uriContextPath, header);
                request.addHeader(AUTHORIZATION, header);
            } else {
                LOG.trace("");
                return response;
            }
            LOG.trace("");
            request = this.removeInvalidHeaders(request);
            httpHeaders = this.toString(request.getAllHeaders());
            LOG.trace("HttpRequest Headers : \n{}", (Object)httpHeaders);
            response = this.httpclient.execute((HttpUriRequest)request, (HttpContext)context);
            code = response.getStatusLine().getStatusCode();
        }
        LOG.trace("");
        return response;
    }

    public void close() throws IOException {
        this.httpclient.close();
    }

    private void addHeaderX(HttpUriRequest request, HttpHeader[] headers) {
        LOG.trace("");
        if (request == null) {
            return;
        }
        if (headers != null) {
            LOG.trace("Headers hinzuf\u00fcgen ...");
            for (HttpHeader header : headers) {
                if (this.isHeaderInvalid(header)) continue;
                request.addHeader(header.getName(), header.getValue());
            }
        }
        if (this.defaultHeader == null || this.defaultHeader.isEmpty()) {
            return;
        }
        LOG.trace("Default Headers hinzuf\u00fcgen: ...");
        for (Map.Entry entry : this.defaultHeader.entrySet()) {
            if (this.isHeaderInvalid((String)entry.getKey()) || entry.getValue() == null || ((String)entry.getValue()).isEmpty()) continue;
            request.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        LOG.trace("");
    }

    public HttpClient getHttpClient() {
        LOG.trace("");
        return this.httpclient;
    }

    public BNotKHttpFacade deriveBNotK(String jceProviderName, KeyStore clientKeyStore) {
        LOG.trace("");
        return new BoreumHttpClient(this.config, jceProviderName, clientKeyStore);
    }

    private String toString(Header[] headers) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (Header header : headers) {
            builder.append("\n").append(header);
        }
        builder.append("\n]");
        return builder.toString();
    }

    private boolean isHeaderInvalid(HttpHeader header) {
        boolean invalid = this.isHeaderInvalid(header.getName());
        boolean headerValueIsEmpty = header.getValue() == null || header.getValue().isEmpty();
        return invalid || headerValueIsEmpty;
    }

    private boolean isHeaderInvalid(String headerName) {
        boolean doesNotExists = headerName.contains("precheck") || headerName.contains("post-check");
        boolean isNotHeaderButValue = headerName.contains("max-age") || headerName.contains("must-revalidate");
        boolean canBeOmitted = headerName.contains("Pragma");
        return doesNotExists || isNotHeaderButValue || canBeOmitted;
    }

    private HttpRequestBase removeInvalidHeaders(HttpRequestBase request) {
        Header[] headers = request.getAllHeaders();
        if (headers == null) {
            return request;
        }
        for (Header header : headers) {
            if (!this.isHeaderInvalid(header.getName())) continue;
            request.removeHeaders(header.getName());
        }
        return request;
    }
}

