/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client;

import de.bos_bremen.ci.Hex;
import de.bos_bremen.ecard.client.CommonsUrlConnector;
import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.ProcessSignedFile;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.error.SignerException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AbstractProcessHelper {
    private static final Logger LOG = LogManager.getLogger(AbstractProcessHelper.class);

    protected List<ProcessSignedFile> getInputfiles(String[] inputFile, List<ProcessSignedFile> inOutFileList, boolean openDirectory) throws SignerException {
        for (int i = 0; inputFile != null && i < inputFile.length; ++i) {
            LOG.trace("File [{}] : {}", (Object)i, (Object)inputFile[i]);
            if (inputFile[i].indexOf("://") != -1 && inputFile[i].indexOf("file:") == -1) {
                String stringToken;
                URL urlFileToDownload;
                StringTokenizer strTokenizer = new StringTokenizer(inputFile[i], "|", false);
                String fileUrlString = strTokenizer.nextToken();
                if (fileUrlString.indexOf(" ") != -1) {
                    fileUrlString = fileUrlString.replaceAll(" ", "%20");
                }
                try {
                    urlFileToDownload = new URL(fileUrlString);
                }
                catch (MalformedURLException e) {
                    throw new SignerException(ErrorCode.CONNECTION_ERROR, (Throwable)e);
                }
                String tempFileName = urlFileToDownload.getFile();
                if (strTokenizer.hasMoreTokens() && (stringToken = strTokenizer.nextToken()) != null && !stringToken.isEmpty()) {
                    tempFileName = stringToken;
                }
                if (tempFileName.indexOf("/") != -1) {
                    tempFileName = tempFileName.substring(tempFileName.lastIndexOf(47) + 1);
                }
                if (tempFileName.indexOf("%20") != -1) {
                    tempFileName = tempFileName.replaceAll("%20", " ");
                    LOG.info("temp file name = {}", (Object)tempFileName);
                }
                CommonsUrlConnector urlConnector = new CommonsUrlConnector(null);
                try {
                    LOG.info("Von URL = {}", (Object)urlFileToDownload);
                    File tempFile = urlConnector.getFile(urlFileToDownload, tempFileName);
                    LOG.info("... Temp Datei wurde lokal erstellt = {}", (Object)tempFile);
                    tempFile.deleteOnExit();
                    if (strTokenizer.hasMoreTokens()) {
                        String stringToken2 = strTokenizer.nextToken();
                        byte[] parseHexString = Hex.parseHexString((String)stringToken2, (int)0, (int)stringToken2.length());
                        ProcessSignedFile viewableFile = new ProcessSignedFile(tempFile, parseHexString);
                        if (!viewableFile.isUnchanged()) {
                            Document.getInstance().reportError(ErrorCode.HASHEDFILE_CHANGED, true, urlFileToDownload);
                            byte[] newOriginalHash = Utils.createSHA256Hash(tempFile);
                            viewableFile = new ProcessSignedFile(tempFile, newOriginalHash);
                        }
                        inOutFileList.add(viewableFile);
                    } else {
                        inOutFileList.add(new ProcessSignedFile(tempFile));
                    }
                    LOG.trace("document.setFile");
                }
                catch (SignerException ex) {
                    Document.getInstance().reportError(ex, false, urlFileToDownload);
                    LOG.error("Datei konnte nicht herunter geladen werden");
                }
                catch (StringIndexOutOfBoundsException ex) {
                    Document.getInstance().reportError(new SignerException(ErrorCode.UNKNOWN, (Throwable)ex), false, urlFileToDownload);
                    LOG.error(ex.getMessage() != null ? ex.getMessage() : "String index out of range");
                }
                continue;
            }
            File file = new File(inputFile[i]);
            if (file.isDirectory()) {
                if (openDirectory) {
                    LOG.info("Das Verzeichnis {} wird ausgelesen und allen Inhaltsdateien der Liste hinzugefuegt.", (Object)file.getAbsolutePath());
                    File[] dirFiles = file.listFiles();
                    if (dirFiles != null) {
                        if (dirFiles.length == 0) {
                            inOutFileList.add(this.createProcessSignedFile(file));
                            Document.getInstance().reportError(ErrorCode.SOURCE_DIR_EMPTY, false, file.getAbsolutePath());
                        } else {
                            String[] dirFileNames = new String[dirFiles.length];
                            for (int j = 0; j < dirFiles.length; ++j) {
                                dirFileNames[j] = dirFiles[j].getAbsolutePath();
                            }
                            this.getInputfiles(dirFileNames, inOutFileList, false);
                        }
                    } else {
                        LOG.error("Das Verzeichnis {} hat keine Leseberechtigung", (Object)file.getAbsolutePath());
                        Document.getInstance().reportError(ErrorCode.CANNOT_READ_FOLDER, false, file.getAbsolutePath());
                    }
                } else {
                    LOG.error("Das Verzeichnis {} wird nicht eingebunden, da keine Rekursion unterstuetzt wird.", (Object)file.getAbsolutePath());
                }
            } else {
                inOutFileList.add(this.createProcessSignedFile(file));
            }
            if (file.exists()) continue;
            LOG.error("Die Datei {} existiert nicht und kann daher nicht mit in die Liste uebernommen werden", (Object)file.getAbsolutePath());
            Document.getInstance().reportError(ErrorCode.FILE_NOT_FOUND, false, file.getAbsolutePath());
        }
        return inOutFileList;
    }

    protected ProcessSignedFile createProcessSignedFile(File file) {
        return new ProcessSignedFile(file);
    }
}

