/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.decrypt.model.formular.process.impl;

import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.control.process.ProcessName;
import de.bos_bremen.ecard.client.control.step.StepFactory;
import de.bos_bremen.ecard.client.decrypt.model.formular.process.DecryptProcessFormular;
import de.bos_bremen.ecard.client.model.KeyUsage;
import de.bos_bremen.ecard.client.model.ProcessFileSeen;
import de.bos_bremen.ecard.client.model.SubsequentProcess;
import de.bos_bremen.ecard.client.model.TargetFolderType;
import de.bos_bremen.ecard.client.model.error.SignerException;
import de.bos_bremen.ecard.client.model.formular.process.impl.AbstractProcessFormular;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;

public class DecryptFormular
extends AbstractProcessFormular
implements DecryptProcessFormular {
    private List<ProcessFileSeen> selectedFiles;
    private EnumMap<StepFactory.StepName, Boolean> skipStep = new EnumMap(StepFactory.StepName.class);
    private List<KeyProvider> keyProviderList = new ArrayList<KeyProvider>();
    private Boolean extractZipArchive;
    private String targetFolder;
    private TargetFolderType targetFolderType;
    private String localCopyFolder;
    private SubsequentProcess currentSubsequentProcess;
    private Boolean usePassword = false;

    public DecryptFormular(DecryptFormular formular) {
        super((AbstractProcessFormular)formular);
        this.selectedFiles = formular.selectedFiles != null ? new ArrayList<ProcessFileSeen>(formular.selectedFiles) : new ArrayList();
        this.skipStep = formular.skipStep != null ? new EnumMap<StepFactory.StepName, Boolean>(formular.skipStep) : new EnumMap(StepFactory.StepName.class);
        this.keyProviderList = formular.keyProviderList != null ? new ArrayList<KeyProvider>(formular.keyProviderList) : new ArrayList();
        this.extractZipArchive = formular.extractZipArchive;
        this.targetFolder = formular.targetFolder;
        this.targetFolderType = formular.targetFolderType;
        this.usePassword = formular.usePassword;
    }

    public DecryptFormular() {
    }

    public void addSelectedFile(ProcessFileSeen file) {
        if (this.selectedFiles == null) {
            this.selectedFiles = new ArrayList<ProcessFileSeen>();
        }
        this.selectedFiles.add(file);
        this.notifyAllChangeListener(null, file, StepFactory.StepName.selectfiles);
    }

    public boolean containSelectedFiles(ProcessFileSeen file) {
        if (this.selectedFiles != null && !this.selectedFiles.isEmpty()) {
            for (ProcessFileSeen aktFile : this.selectedFiles) {
                if (aktFile.getFile() == null || file.getFile() == null || !aktFile.getFile().equals((Object)file.getFile())) continue;
                return true;
            }
        }
        return false;
    }

    public List<ProcessFileSeen> getSelectedFiles() {
        return this.selectedFiles;
    }

    public boolean removeSelectedFile(ProcessFileSeen fileToRemove) {
        boolean removed;
        if (this.selectedFiles == null) {
            this.selectedFiles = new ArrayList<ProcessFileSeen>();
        }
        if (removed = this.selectedFiles.remove(fileToRemove)) {
            this.notifyAllChangeListener(fileToRemove, null, StepFactory.StepName.selectfiles);
        }
        return removed;
    }

    public void removeAllFiles() {
        ArrayList<ProcessFileSeen> list = new ArrayList<ProcessFileSeen>();
        if (this.selectedFiles != null) {
            list.addAll(this.selectedFiles);
        } else {
            this.selectedFiles = new ArrayList<ProcessFileSeen>();
        }
        for (ProcessFileSeen psf : list) {
            this.removeSelectedFile(psf);
        }
    }

    public void setSelectedFiles(List<File> files, boolean replaceFiles) {
        if (replaceFiles || this.selectedFiles == null) {
            this.selectedFiles = new ArrayList<ProcessFileSeen>();
        }
        if (files != null) {
            for (File file : files) {
                ProcessFileSeen processFileSeen = new ProcessFileSeen(file);
                if (this.containSelectedFiles(processFileSeen)) continue;
                this.selectedFiles.add(processFileSeen);
            }
        }
        this.notifyAllChangeListener(null, this.selectedFiles, StepFactory.StepName.selectfiles);
    }

    public void skipStep(boolean useDefaults, StepFactory.StepName stepName) {
        this.skipStep.put(stepName, useDefaults);
    }

    public Boolean skipStep(StepFactory.StepName stepName) {
        if (this.skipStep.containsKey(stepName)) {
            return this.skipStep.get(stepName);
        }
        return Boolean.FALSE;
    }

    public boolean addKeyProvider(KeyProvider provider, KeyUsage keyUsage) {
        if (keyUsage != KeyUsage.DECRYPT || provider == null) {
            return false;
        }
        if (this.keyProviderList.contains(provider)) {
            return true;
        }
        boolean result = this.keyProviderList.add(provider);
        if (result) {
            this.notifyAllChangeListener(null, provider, StepFactory.StepName.selectkeys);
        }
        return result;
    }

    public List<KeyProvider> getKeyProvider(KeyUsage keyUsage) {
        if (keyUsage != KeyUsage.DECRYPT) {
            return Collections.emptyList();
        }
        return new ArrayList<KeyProvider>(this.keyProviderList);
    }

    public boolean removeKeyProvider(KeyProvider provider, KeyUsage keyUsage) {
        if (keyUsage != KeyUsage.DECRYPT) {
            return false;
        }
        ProcessName p = Utils.getActiveProcess();
        if (p == null || "none".equals(p.toString())) {
            LOG.info("no active process -> return");
            return false;
        }
        boolean result = this.keyProviderList.remove(provider);
        if (result) {
            this.notifyAllChangeListener(provider, null, StepFactory.StepName.decrypt);
        }
        return result;
    }

    public boolean setSelectedAlias(KeyProvider provider, String alias, KeyUsage keyUsage) {
        if (keyUsage != KeyUsage.DECRYPT) {
            return false;
        }
        if (!this.keyProviderList.contains(provider)) {
            return false;
        }
        int indexOf = this.keyProviderList.indexOf(provider);
        provider.setSelectedAlias(alias);
        this.keyProviderList.remove(indexOf);
        this.keyProviderList.add(indexOf, provider);
        this.notifyAllChangeListener(provider, null, StepFactory.StepName.decrypt);
        return true;
    }

    @Override
    public void extractZipArchiv(boolean extract) {
        this.extractZipArchive = extract;
    }

    @Override
    public Boolean extractZipArchiv() {
        return this.extractZipArchive;
    }

    public String getTargetFolder() {
        return this.targetFolder;
    }

    public TargetFolderType getTargetFolderType() {
        return this.targetFolderType;
    }

    public boolean setTargetFolder(String folder) {
        String oldValue = this.targetFolder;
        this.targetFolder = folder;
        this.notifyAllChangeListener(oldValue, this.targetFolder, StepFactory.StepName.selecttargetfolder);
        return true;
    }

    public boolean setTargetFolderType(TargetFolderType folderType) {
        this.targetFolderType = folderType;
        return true;
    }

    public void setDefault() {
        this.setSelectedFiles(new ArrayList<File>(), true);
        EnumMap<StepFactory.StepName, Boolean> oldSkipStep = new EnumMap<StepFactory.StepName, Boolean>(this.skipStep);
        for (StepFactory.StepName key : oldSkipStep.keySet()) {
            if (!Boolean.TRUE.equals(this.skipStep.get(key))) continue;
            this.skipStep.remove(key);
            this.skipStep(false, key);
        }
        ArrayList<KeyProvider> oldKeyProviderList = new ArrayList<KeyProvider>(this.keyProviderList);
        for (KeyProvider provider : oldKeyProviderList) {
            this.removeKeyProvider(provider, KeyUsage.DECRYPT);
        }
        this.extractZipArchiv(false);
        this.setTargetFolderType(TargetFolderType.sameAsSourceFolder);
        this.setTargetFolder(null);
    }

    public void notifyAllChangeListener() {
        this.notifyAllChangeListener(null, Boolean.TRUE, StepFactory.StepName.selectfiles);
    }

    public void setFileAsSeen(ProcessFileSeen file) throws SignerException {
        try {
            file.setSeen(true);
        }
        finally {
            this.notifyAllChangeListener();
        }
    }

    public String getLocalCopyFolder() {
        return this.localCopyFolder;
    }

    public void setLocalCopyFolder(String targetFolder) {
        String oldValue = this.localCopyFolder;
        this.localCopyFolder = targetFolder;
        this.notifyAllChangeListener(oldValue, targetFolder, StepFactory.StepName.selecttargetfolder);
    }

    public SubsequentProcess getSubsequentProcess() {
        return this.currentSubsequentProcess;
    }

    public void setSubsequentProcess(SubsequentProcess subsequentProcess) {
        this.currentSubsequentProcess = subsequentProcess;
    }

    @Override
    public void usePassword(boolean usePassword) {
        boolean oldValue = this.usePassword;
        this.usePassword = usePassword;
        this.notifyAllChangeListener(oldValue, usePassword, StepFactory.StepName.selectkeys);
    }

    @Override
    public Boolean usePassword() {
        return this.usePassword;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("\nDecryptFormular");
        List<ProcessFileSeen> files = this.getSelectedFiles();
        stringBuilder.append("\nSelectedFiles: ");
        if (files == null || files.isEmpty()) {
            stringBuilder.append("---");
        } else {
            for (ProcessFileSeen file : files) {
                stringBuilder.append(file.getFile().getAbsolutePath()).append(";");
            }
        }
        stringBuilder.append("\n");
        stringBuilder.append("ExtractZipArchive: ").append(this.extractZipArchive).append("\n");
        stringBuilder.append("TargetFolder: ").append(this.getTargetFolder()).append("\n");
        stringBuilder.append("TargetFolderType: ").append(this.getTargetFolderType()).append("\n");
        stringBuilder.append("UsePassword: ").append(this.usePassword).append("\n");
        stringBuilder.append("KeyProviderList: ");
        if (this.keyProviderList == null || this.keyProviderList.isEmpty()) {
            stringBuilder.append("---");
        } else {
            for (KeyProvider key : this.keyProviderList) {
                stringBuilder.append(key.getSelectedAlias()).append(";");
            }
        }
        return stringBuilder.toString();
    }

    public void setSerialnumber(String serialnumber) {
    }

    public String getSerialnumber() {
        return null;
    }
}

