/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.decrypt.gui.step;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.control.step.AbstractSelectTargetDir;
import de.bos_bremen.ecard.client.decrypt.control.step.SelectTargetDir;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.step.AbstractSelectTargetDirView;
import de.bos_bremen.ecard.client.gui.view.component.GridBagPanel;
import de.bos_bremen.ecard.client.gui.view.component.JComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.LocaleChanger;
import de.bos_bremen.ecard.client.gui.view.component.buttons.AccessibleRadioButton;
import de.bos_bremen.ecard.client.gui.view.component.label.AccessibleJLabel;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.model.licence.ProductFunctions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SelectTargetDirView
extends AbstractSelectTargetDirView
implements ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOG = LogManager.getLogger(SelectTargetDirView.class);
    private transient SelectTargetDir decryptStep;
    private AccessibleRadioButton unzipYes;
    private AccessibleRadioButton unzipNo;
    private static final String PROCESS_DECRYPT_TARGETFOLDER = "process/decrypt/targetfolder";

    public SelectTargetDirView(SelectTargetDir step) {
        super((AbstractSelectTargetDir)step);
        LOG.trace("decrypt : selecttargetfolder");
        LocaleChanger.getInstance().addObserver((PropertyChangeListener)this);
    }

    protected void createComponents() {
        super.createComponents();
        LOG.trace("decrypt : selecttargetfolder");
        this.unzipYes = new AccessibleRadioButton(Messages.getString((String)"radiobutton.yes"));
        this.unzipYes.setMnemonic(Messages.getString((String)"radiobutton.yes.mnemonic").charAt(0));
        this.unzipYes.addActionListener((ActionListener)this);
        this.unzipNo = new AccessibleRadioButton(Messages.getString((String)"radiobutton.no"));
        this.unzipNo.setMnemonic(Messages.getString((String)"radiobutton.no.mnemonic").charAt(0));
        this.unzipNo.addActionListener((ActionListener)this);
        ButtonGroup group = new ButtonGroup();
        group.add((AbstractButton)this.unzipYes);
        group.add((AbstractButton)this.unzipNo);
    }

    protected JPanel createContentPanel() {
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        ProductFunctions productFunctions = Document.getInstance().getProductFunctions();
        LicenceTyp unzipLicence = productFunctions.getLicence("process/decrypt/targetfolder/unzip");
        if (unzipLicence.isVisible()) {
            content.add((Component)this.createUnzipComponents(), "North");
        }
        content.add((Component)super.createContentPanel(), "Center");
        return content;
    }

    private GridBagPanel createUnzipComponents() {
        GridBagPanel content = new GridBagPanel();
        content.setBorder((Border)ComponentUtils.createTitledCurvedBorderForTitle((String)Messages.getString((String)"step.selecttargetfolder.targetdir.extractzipafterdecrypt.title")));
        content.setFocusable(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.insets = new Insets(3, 3, 3, 3);
        ProductFunctions productFunctions = Document.getInstance().getProductFunctions();
        LicenceTyp unzipLicence = productFunctions.getLicence("process/decrypt/targetfolder/unzip");
        LicenceTyp targetfolderLicence = productFunctions.getLicence("process/decrypt/targetfolder/targetfolder");
        JComponentUtils.setLookByLicence((JComponent)new AccessibleJLabel(Messages.getString((String)"step.selecttargetfolder.targetdir.extractzipafterdecrypt")), (LicenceTyp)unzipLicence, (JPanel)content, (GridBagConstraints)gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 10;
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.5;
        gbc.weighty = 0.5;
        gbc.insets = new Insets(5, 3, 5, 3);
        JComponentUtils.setLookByLicence((JComponent)this.unzipYes, (LicenceTyp)unzipLicence, (JPanel)content, (GridBagConstraints)gbc);
        gbc.gridx = 1;
        JComponentUtils.setLookByLicence((JComponent)this.unzipNo, (LicenceTyp)unzipLicence, (JPanel)content, (GridBagConstraints)gbc);
        if (!targetfolderLicence.useInProcess()) {
            this.step.setTargetFolderTyp(null);
        }
        if (!unzipLicence.isVisible()) {
            this.unzipYes.setVisible(false);
            this.unzipNo.setVisible(false);
        }
        if (!unzipLicence.useInProcess()) {
            this.unzipYes.setEnabled(false);
            this.unzipNo.setSelected(false);
            this.getStep().extractZipAfterDecrypt(false);
        }
        return content;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.getStep().extractZipAfterDecrypt(evt.getSource() != null && this.unzipYes.equals(evt.getSource()) && this.unzipYes.isSelected());
    }

    public void stateChanged(ChangeEvent event) {
        LOG.trace("decrypt : selecttargetfolder");
        if (this.getStep().isExtractZipAfterDecrypt()) {
            this.unzipYes.setSelected(true);
        } else {
            this.unzipNo.setSelected(true);
        }
        super.stateChanged(event);
    }

    protected SelectTargetDir getStep() {
        AbstractSelectTargetDir abstractSelectTargetDir;
        if (this.decryptStep == null && (abstractSelectTargetDir = this.step) instanceof SelectTargetDir) {
            SelectTargetDir selectTargetDir;
            this.decryptStep = selectTargetDir = (SelectTargetDir)abstractSelectTargetDir;
        }
        return this.decryptStep;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        LOG.trace("decrypt : selecttargetfolder");
        this.removeAll();
        this.createComponents();
        this.initGUI();
        this.revalidate();
    }

    public void setActive(boolean active) {
        super.setActive(active);
        LOG.trace("decrypt : selecttargetfolder");
        if (active) {
            LOG.debug("set active : decrypt : selecttargetfolder : nothing to do");
            LOG.info("\n------------------------- Entschl\u00fcsseln/Zielverzeichnis w\u00e4hlen : ausgewaehlt ----------------------");
        }
    }
}

