/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.decrypt.gui.step;

import de.bos_bremen.ci.asn1.x509.Certificate;
import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.AliasSelectionHandler;
import de.bos_bremen.ecard.client.action.SelectedCertificateHandler;
import de.bos_bremen.ecard.client.control.step.KeyProviderStep;
import de.bos_bremen.ecard.client.control.step.SkippableStep;
import de.bos_bremen.ecard.client.control.step.StepChangedListener;
import de.bos_bremen.ecard.client.decrypt.control.step.SelectKeys;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.DescriptionPanel;
import de.bos_bremen.ecard.client.gui.view.component.JComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.LocaleChanger;
import de.bos_bremen.ecard.client.gui.view.component.SkipStepHandler;
import de.bos_bremen.ecard.client.gui.view.component.SkipStepPanel;
import de.bos_bremen.ecard.client.gui.view.component.buttons.AccessibleRadioButton;
import de.bos_bremen.ecard.client.gui.view.component.buttons.CurvedToggleIconButton;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IFDCurvedToggleIconButton;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IconButton;
import de.bos_bremen.ecard.client.gui.view.component.label.AccessibleJLabel;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.KeyUsage;
import de.bos_bremen.ecard.client.model.keyprovider.AbstractKeyProvider;
import de.bos_bremen.ecard.client.model.keyprovider.AliasListener;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProvider;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProviderEntry;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProviderSource;
import de.bos_bremen.ecard.client.model.keyprovider.SoftwareKey;
import de.bos_bremen.ecard.client.model.keyprovider.TerminalKey;
import de.bos_bremen.ecard.client.model.keyprovider.mcard.TerminalListener;
import de.bos_bremen.ecard.client.model.keyprovider.mcard.TerminalModel;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.model.licence.ProductFunctions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SelectKeysView
extends JPanel
implements StepChangedListener,
SelectedCertificateHandler,
AdjustmentListener,
AliasSelectionHandler,
PropertyChangeListener,
SkipStepHandler,
TerminalListener,
AliasListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger(SelectKeysView.class);
    private AccessibleJLabel aliasLabel;
    protected JPanel ifdPanel;
    protected JPanel aliasPanel;
    protected JPanel ifdBorderPanel;
    protected JPanel aliasBorderPanel;
    protected JPanel bottomButtonPanel;
    protected IconButton showCertificateButton;
    private final transient SelectKeys selectKeysStep;
    private final List<IFDCurvedToggleIconButton> ifdList = new ArrayList<IFDCurvedToggleIconButton>();
    private final List<CurvedToggleIconButton> aliasList = new ArrayList<CurvedToggleIconButton>();
    private SkipStepPanel skipStep;
    private JScrollPane ifdScrollPane;
    private JScrollPane aliasScrollPane;
    private DescriptionPanel descPanel;
    private JPanel certificateBorderPanel;
    private AccessibleRadioButton useCertificate;
    private AccessibleRadioButton usePassword;
    private IFDButtonGroup ifdGroup;

    public SelectKeysView(SelectKeys step) {
        LOG.trace("decrypt : selectkeys");
        this.selectKeysStep = step;
        this.selectKeysStep.addStateChangeListener(this);
        LocaleChanger.getInstance().addObserver((PropertyChangeListener)this);
        this.initKeyProviderList();
        this.initGui();
        JComponentUtils.setLookByLicence((JComponent)this, (LicenceTyp)this.selectKeysStep.getLicenceTyp());
        this.layoutGui(false);
        this.updateIfdList();
        this.layoutIfdPanel();
    }

    private void initKeyProviderList() {
        LOG.trace("decrypt : selectkeys");
        this.selectKeysStep.getKeyProviderList().add(new SoftwareKey((AliasListener)this, (KeyProviderStep)this.selectKeysStep, this.getKeyUsage(), false));
        this.selectKeysStep.getKeyProviderList().add(new TerminalKey((TerminalListener)this, (AliasListener)this, (KeyProviderStep)this.selectKeysStep, this.getKeyUsage()));
    }

    private void initGui() {
        LOG.trace("decrypt : selectkeys");
        String property = "step." + this.selectKeysStep.keyUsage.toString().toLowerCase() + ".keychooser";
        this.usePassword = new AccessibleRadioButton(Messages.getString((String)(property + ".usePassword.text")), Messages.getResource((String)(property + ".usePassword.tooltip")));
        this.usePassword.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 1) {
                LOG.debug("select keys -> password");
                this.selectKeysStep.usePassword(this.usePassword.isSelected());
                this.stateChanged(null);
            }
        });
        this.useCertificate = new AccessibleRadioButton(Messages.getString((String)(property + ".useCertificate.text")), Messages.getResource((String)(property + ".useCertificate.tooltip")));
        this.useCertificate.setSelected(true);
        this.useCertificate.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 1) {
                LOG.debug("select keys -> certificate");
                this.selectKeysStep.usePassword(this.usePassword.isSelected());
                this.stateChanged(null);
            }
        });
        this.descPanel = new DescriptionPanel(property);
        this.ifdPanel = new JPanel();
        this.ifdBorderPanel = new JPanel();
        this.ifdBorderPanel = ComponentUtils.setTitledFocusableBorder((JPanel)this.ifdBorderPanel, (String)Messages.getString((String)(property + ".title1")));
        this.aliasLabel = new AccessibleJLabel("<html>" + Messages.getString((String)(property + ".2.text")) + "</html>");
        this.aliasPanel = new JPanel();
        this.aliasBorderPanel = new JPanel();
        this.aliasBorderPanel = ComponentUtils.setTitledFocusableBorder((JPanel)this.aliasBorderPanel, (String)Messages.getString((String)(property + ".title2")));
        this.showCertificateButton = new IconButton();
        this.showCertificateButton.setAction((Action)Document.getInstance().getActionFactory().createShowCertificateAction((SelectedCertificateHandler)this));
        this.showCertificateButton.setFocusable(true);
        this.showCertificateButton.setFocusPainted(true);
        this.bottomButtonPanel = new JPanel();
        ButtonGroup decryptChoiceGroup = new ButtonGroup();
        decryptChoiceGroup.add((AbstractButton)this.usePassword);
        decryptChoiceGroup.add((AbstractButton)this.useCertificate);
        this.skipStep = new SkipStepPanel((SkipStepHandler)this);
        this.ifdScrollPane = new JScrollPane();
        this.ifdScrollPane.getHorizontalScrollBar().addAdjustmentListener(this);
        this.ifdScrollPane.setBorder(null);
        this.ifdScrollPane.setVerticalScrollBarPolicy(21);
        this.aliasScrollPane = new JScrollPane();
        this.aliasScrollPane.getHorizontalScrollBar().addAdjustmentListener(this);
        this.aliasScrollPane.setBorder(null);
        this.aliasScrollPane.setVerticalScrollBarPolicy(21);
    }

    private JPanel layoutDescriptionPanel() {
        LOG.trace("decrypt : selectkeys");
        JPanel descriptionPanel = new JPanel(new BorderLayout());
        descriptionPanel.add((Component)this.descPanel, "North");
        return descriptionPanel;
    }

    private void layoutGui(boolean showAlias) {
        LOG.trace("decrypt : selectkeys");
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add((Component)this.layoutDescriptionPanel(), "North");
        this.add((Component)this.layoutCenterPanel(showAlias), "Center");
        this.revalidate();
        this.repaint();
    }

    private JPanel layoutCenterPanel(boolean showAlias) {
        LOG.trace("decrypt : selectkeys");
        ProductFunctions productFunctions = Document.getInstance().getProductFunctions();
        LicenceTyp passwordLicence = productFunctions.getLicence(this.selectKeysStep.getLicenceTypKey() + "/password");
        LicenceTyp certificateLicence = productFunctions.getLicence(this.selectKeysStep.getLicenceTypKey() + "/certificate");
        JPanel passwordPanel = this.layoutPasswordPanel();
        JPanel certificatePanel = this.layoutCertificatePanel(showAlias);
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)JComponentUtils.setLookByLicence((JComponent)passwordPanel, (LicenceTyp)passwordLicence), "North");
        centerPanel.add((Component)JComponentUtils.setLookByLicence((JComponent)certificatePanel, (LicenceTyp)certificateLicence), "Center");
        centerPanel.add((Component)this.skipStep, "South");
        return centerPanel;
    }

    private JPanel layoutPasswordPanel() {
        JPanel passwordPanel = new JPanel(new GridBagLayout());
        passwordPanel.setBorder((Border)ComponentUtils.createTitledCurvedBorderForTitle((String)Messages.getString((String)"step.decrypt.keychooser.usePassword.title")));
        passwordPanel.add((Component)this.usePassword, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 15, 0, 0), 0, 0));
        return passwordPanel;
    }

    private JPanel layoutCertificatePanel(boolean showAlias) {
        JPanel center = new JPanel(new BorderLayout());
        center.setBorder(new EmptyBorder(0, 35, 0, 0));
        center.add((Component)this.ifdBorderPanel, "North");
        center.add((Component)this.createCertificatePanel(showAlias), "Center");
        JPanel layoutCertificatePanel = new JPanel(new BorderLayout());
        layoutCertificatePanel.setBorder((Border)ComponentUtils.createTitledCurvedBorderForTitle((String)Messages.getString((String)"step.decrypt.keychooser.useCertificate.title")));
        JPanel identUseCertificate = new JPanel(new BorderLayout());
        identUseCertificate.setBorder(new EmptyBorder(0, 15, 5, 0));
        identUseCertificate.add((Component)this.useCertificate, "North");
        layoutCertificatePanel.add((Component)identUseCertificate, "North");
        layoutCertificatePanel.add((Component)center, "Center");
        return layoutCertificatePanel;
    }

    private JPanel createCertificatePanel(boolean showAlias) {
        this.certificateBorderPanel = new JPanel(new BorderLayout());
        this.certificateBorderPanel.add((Component)this.ifdBorderPanel, "North");
        GridBagLayout gbl = new GridBagLayout();
        this.bottomButtonPanel.removeAll();
        this.bottomButtonPanel.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.insets = new Insets(5, 5, 0, 0);
        if (showAlias) {
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.fill = 1;
            JPanel centerAliasPanel = new JPanel(gbl);
            centerAliasPanel.add((Component)this.aliasLabel, gbc);
            gbc.weighty = 1.0;
            gbc.fill = 2;
            centerAliasPanel.add((Component)this.aliasBorderPanel, gbc);
            this.certificateBorderPanel.add((Component)centerAliasPanel, "Center");
            GridBagConstraints gbcUpdatePanel = new GridBagConstraints();
            gbcUpdatePanel.anchor = 16;
            gbcUpdatePanel.fill = 0;
            gbcUpdatePanel.weighty = 1.0;
            gbcUpdatePanel.insets = new Insets(0, 5, 0, 5);
            gbcUpdatePanel.weightx = 1.0;
            this.bottomButtonPanel.add((Component)this.showCertificateButton, gbcUpdatePanel);
        }
        this.certificateBorderPanel.add((Component)this.bottomButtonPanel, "South");
        return this.certificateBorderPanel;
    }

    private void updateAndShowAliasPanel() {
        LOG.trace("decrypt : selectkeys");
        this.updateAliasList();
        this.updateAliasPanel();
        this.layoutGui(true);
    }

    private void updateIfdList() {
        LOG.trace("decrypt : selectkeys");
        this.ifdList.clear();
        this.ifdGroup = new IFDButtonGroup();
        for (AbstractKeyProvider keyProvider : this.selectKeysStep.getKeyProviderList()) {
            List buttons = keyProvider.getIFDCurvedToggleIconButton();
            if (buttons == null) continue;
            for (IFDCurvedToggleIconButton button : buttons) {
                if (button.getKeyProviderEntry().getKeyProviderType() == KeyProviderSource.CARD) {
                    LOG.warn("Die Entschluessselung mit der Karte wird nicht mehr unterstuetzt.");
                    button.setText(KeyProviderSource.CARD.name());
                }
                button.addKeyListener(this.createKeyAdapterFor(button));
                this.ifdGroup.add((AbstractButton)button);
                this.updateIFDButton(button);
                this.ifdList.add(button);
            }
        }
    }

    private JLabel createErrorLabel(String key) {
        LOG.trace("decrypt : selectkeys : {}", (Object)Messages.getString((String)key));
        return new JLabel(Messages.getString((String)key));
    }

    private JLabel createErrorLabel() {
        String errorMessage = Messages.getString((String)"decrypt.selectkeys.card.certificate.not.supported");
        LOG.debug(errorMessage);
        JLabel label = new JLabel(errorMessage);
        label.setFocusable(true);
        label.addFocusListener(ComponentUtils.createFocusListenerFor((JLabel)label));
        return label;
    }

    private void updateAliasList() {
        LOG.trace("decrypt : selectkeys");
        LOG.debug("Updating aliasList...");
        this.aliasList.clear();
        KeyProvider keyProvider = this.selectKeysStep.getSelectedKeyProvider();
        if (keyProvider == null) {
            LOG.error("No KeyProviders were found");
            return;
        }
        LOG.info(keyProvider.getIFDName());
        List allAliases = keyProvider.getAllAliases();
        for (String alias : allAliases) {
            String buttonLabel = "<html>" + keyProvider.getDisplayName(alias) + "<br>(" + keyProvider.getUsageName(alias) + ")</html>";
            this.aliasList.add(new CurvedToggleIconButton("action.alias", buttonLabel, alias));
        }
        for (CurvedToggleIconButton button : this.aliasList) {
            String alias = button.getAlias();
            button.setEnabled(true);
            button.setFocusable(true);
            button.setFocusPainted(true);
            button.addActionListener((ActionListener)Document.getInstance().getActionFactory().createAliasSelectionAction((AliasSelectionHandler)this, alias));
        }
        LOG.debug("aliasList updated.");
    }

    private void layoutIfdPanel() {
        LOG.trace("decrypt : selectkeys");
        this.updateButtonPanel(this.ifdBorderPanel, this.ifdPanel, this.ifdList, this.ifdScrollPane, "step." + this.selectKeysStep.keyUsage.toString().toLowerCase() + ".error.noIfds");
    }

    private void updateButtonPanel(JPanel borderPanel, JPanel panel, List<?> buttons, JScrollPane scrollPane, String key) {
        if (borderPanel == null || panel == null || buttons == null || scrollPane == null) {
            throw new IllegalArgumentException("unallowed null value");
        }
        borderPanel.removeAll();
        panel.removeAll();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weighty = 1.0;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 5, 0, 0);
        if (buttons.isEmpty()) {
            gbc.weightx = 1.0;
            panel.add((Component)this.createErrorLabel(key), gbc);
        }
        for (int i = 0; i < buttons.size(); ++i) {
            CurvedToggleIconButton but;
            if (i == buttons.size() - 1) {
                gbc.weightx = 1.0;
                gbc.insets = new Insets(0, 5, 0, 0);
            }
            if ((but = (CurvedToggleIconButton)buttons.get(i)).getText().equals(KeyProviderSource.CARD.name())) {
                gbc.insets = new Insets(0, 10, 0, 0);
                panel.add((Component)this.createErrorLabel(), gbc);
                continue;
            }
            panel.add((Component)((CurvedToggleIconButton)buttons.get(i)), gbc);
        }
        scrollPane.setViewportView(panel);
        this.adjustScrollPaneSize(scrollPane, scrollPane.getHorizontalScrollBar(), panel);
        borderPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 5, 0, 0);
        borderPanel.add((Component)scrollPane, gbc);
    }

    public void aliasSelected(String alias) {
        LOG.debug("Alias selected: {}", (Object)alias);
        KeyProvider selectedKeyProvider = this.selectKeysStep.getSelectedKeyProvider();
        if (selectedKeyProvider == null) {
            LOG.error("An alias was selected even though no KeyProviderToUse could be found.");
        } else if (alias == null) {
            LOG.error("The selected alias was null, it could not be set!");
        } else {
            this.selectKeysStep.setSelectedAlias(selectedKeyProvider, alias);
            LOG.debug("Selected alias {}{}", (Object)alias, (Object)" was set in KeyProviderToUse.");
        }
    }

    private void selectSelectedAlias(KeyProvider keyProvider) {
        String selectedAlias = keyProvider.getSelectedAlias();
        LOG.debug("Selected Alias: {}", (Object)selectedAlias);
        if (selectedAlias == null) {
            selectedAlias = keyProvider.getDefaultAlias();
            if (selectedAlias != null) {
                this.selectKeysStep.setSelectedAlias(keyProvider, selectedAlias);
            }
            LOG.debug("Set selected defaultAlias: {}", (Object)selectedAlias);
        }
        String newAlias = null;
        for (CurvedToggleIconButton aliasButton : this.aliasList) {
            newAlias = aliasButton.getAlias();
            if (newAlias == null || !newAlias.equals(selectedAlias)) continue;
            LOG.debug("selecting aliasButton with alias {}", (Object)selectedAlias);
            aliasButton.setSelected(true);
            return;
        }
        if (newAlias == null) {
            return;
        }
        LOG.warn("alias {}{}", (Object)selectedAlias, (Object)" could not be set as selected because it was not found.");
        keyProvider.setSelectedAlias(newAlias);
        this.selectKeysStep.setSelectedAlias(keyProvider, newAlias);
    }

    private void updateAliasPanel() {
        LOG.debug("Updating the aliasPanel...");
        this.updateButtonPanel(this.aliasBorderPanel, this.aliasPanel, this.aliasList, this.aliasScrollPane, "step." + this.selectKeysStep.keyUsage.toString().toLowerCase() + ".error.noAliases");
        LOG.debug("aliasPanel updated.");
        KeyProvider selectedKeyProvider = this.selectKeysStep.getSelectedKeyProvider();
        if (selectedKeyProvider == null) {
            LOG.error("No KeyProviderToUse was found.");
            return;
        }
        this.selectSelectedAlias(selectedKeyProvider);
        this.revalidate();
        this.repaint();
    }

    private void updateIFDButton(IFDCurvedToggleIconButton button) {
        if (button == null) {
            LOG.warn("IFDCurvedToggleIconButton was null!");
            return;
        }
        if (!this.isIfdEnabled(button.getKeyProviderEntry())) {
            button.setToolTipText(Messages.getString((String)"selectkeys.ifd.nocard.tooltip"));
        } else if (button.getKeyProviderEntry().getKeyProviderType() != KeyProviderSource.SOFTWARE) {
            button.setToolTipText("");
        }
        LicenceTyp certificateLicenceType = Document.getInstance().getProductFunctions().getLicence(this.selectKeysStep.getLicenceTypKey() + "/certificate");
        button.setEnabled(this.isIfdEnabled(button.getKeyProviderEntry()) && certificateLicenceType.isVisible() && certificateLicenceType.isEditable() && !this.selectKeysStep.usePassword());
        if (button.getAction() != null) {
            button.getAction().setEnabled(this.isIfdEnabled(button.getKeyProviderEntry()) && certificateLicenceType.isVisible() && certificateLicenceType.isEditable() && !this.selectKeysStep.usePassword());
        }
    }

    private boolean isIfdEnabled(KeyProviderEntry entry) {
        if (entry == null) {
            return false;
        }
        if (entry.getKeyProviderType() == KeyProviderSource.SOFTWARE) {
            return Document.getInstance().getProductFunctions().getLicence(this.selectKeysStep.getLicenceTypKey() + "/certificate/software").isVisible();
        }
        return entry.getKeyProviderType() == KeyProviderSource.CARD;
    }

    protected void removeAllKeyProvidersFromStep() {
        LOG.trace("decrypt : selectkeys");
        LOG.debug("Removing all KeyProvidersToUse from step...");
        List keyProviderToUse = this.selectKeysStep.getKeyProviderToUse();
        if (keyProviderToUse == null || keyProviderToUse.isEmpty()) {
            LOG.trace("No keyProviderToUse.");
            return;
        }
        for (KeyProvider keyProvider : keyProviderToUse) {
            this.selectKeysStep.removeKeyProviderToUse(keyProvider);
        }
        LOG.debug("All KeyProvidersToUse were removed from step.");
    }

    public void stateChanged(ChangeEvent event) {
        LOG.trace("decrypt : selectkeys");
        LOG.info((Object)this.selectKeysStep.getParent());
        this.updateGui();
        this.skipStep.stateChanged(null);
    }

    private void updateGui() {
        LOG.trace("decrypt : selectkeys");
        try {
            KeyProvider keyProvider = this.getSelectedKeyProvider();
            if (keyProvider != null) {
                LOG.debug("loading KeyProviderToUse...");
                this.updateAndShowAliasPanel();
                this.showCertificateButton.setEnabled(true);
                this.selectKeyProviderToUseButton();
            } else {
                LOG.debug("Removing KeyProviderToUse from step because this KeyProvider type is not licenced...");
                this.removeAllKeyProvidersFromStep();
                this.aliasList.clear();
                this.layoutGui(false);
                this.showCertificateButton.setEnabled(false);
                this.selectKeyProviderToUseButton();
                LOG.debug("No KeyProviderToUse was found.");
            }
        }
        finally {
            if (this.selectKeysStep.getForm() != null) {
                this.changeRadioComponents();
            }
        }
    }

    public Certificate getSelectedCertificate() {
        return null;
    }

    public KeyProvider getSelectedKeyProvider() {
        LOG.trace("decrypt : selectkeys");
        if (this.selectKeysStep.getSelectedKeyProvider() != null) {
            return this.selectKeysStep.getSelectedKeyProvider();
        }
        List keyProviderToUse = this.selectKeysStep.getKeyProviderToUse();
        if (keyProviderToUse == null || keyProviderToUse.isEmpty()) {
            LOG.trace("Keine KeyProvider vorhanden.");
            return null;
        }
        LOG.trace(keyProviderToUse.get(0));
        return (KeyProvider)keyProviderToUse.get(0);
    }

    private void selectKeyProviderToUseButton() {
        LOG.trace("decrypt : selectkeys");
        List keyProviders = this.selectKeysStep.getKeyProviderToUse();
        if (keyProviders == null || keyProviders.isEmpty() || keyProviders.get(0) == null) {
            this.ifdGroup.clearSelection();
            return;
        }
        KeyProvider keyProvider = this.selectKeysStep.getSelectedKeyProvider() == null ? (KeyProvider)keyProviders.get(0) : this.selectKeysStep.getSelectedKeyProvider();
        this.ifdGroup.clearSelection();
        for (IFDCurvedToggleIconButton button : this.ifdList) {
            if (button.getIfdTag() == null || !button.getIfdTag().equals(keyProvider.getIFDName())) continue;
            button.setSelected(true);
            return;
        }
        LOG.warn("No button was found for KeyProviderToUse {}", (Object)keyProvider.getIFDName());
    }

    private void adjustScrollPaneSize(JScrollPane scrollPane, JScrollBar scrollBar, JPanel panel) {
        Dimension preferredPanelSize = panel.getPreferredSize();
        int height = (int)preferredPanelSize.getHeight();
        height = (int)((double)height + scrollBar.getPreferredSize().getHeight());
        scrollPane.setMinimumSize(new Dimension((int)preferredPanelSize.getWidth(), height));
        scrollPane.setPreferredSize(scrollPane.getMinimumSize());
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        JScrollBar scrollBar = (JScrollBar)e.getSource();
        if (scrollBar.equals(this.aliasScrollPane.getHorizontalScrollBar())) {
            this.adjustScrollPaneSize(this.aliasScrollPane, scrollBar, this.aliasPanel);
        } else if (scrollBar.equals(this.ifdScrollPane.getHorizontalScrollBar())) {
            this.adjustScrollPaneSize(this.ifdScrollPane, scrollBar, this.ifdPanel);
        }
    }

    public void aliasWasSelected() {
        LOG.trace("decrypt : selectkeys : do nothing");
        LOG.warn("The aliasWasSelected method should not be called in this class as it is not implemented!");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        LOG.trace("decrypt : selectkeys");
        this.reinitGUI();
    }

    private void reinitGUI() {
        LOG.trace("decrypt : selectkeys");
        this.initGui();
        JComponentUtils.setLookByLicence((JComponent)this, (LicenceTyp)this.selectKeysStep.getLicenceTyp());
        this.layoutGui(false);
        this.updateIfdList();
        this.layoutIfdPanel();
        this.updateGui();
    }

    public SkippableStep getSkippableStep() {
        return this.selectKeysStep;
    }

    public boolean getSkipStep() {
        return this.selectKeysStep.skipStep();
    }

    public void setSkipStep(boolean skip) {
        this.selectKeysStep.skipStep(skip);
    }

    public boolean isStepComplete() {
        LOG.trace("decrypt : selectkeys");
        return this.selectKeysStep.isStateComplete();
    }

    public void setActive(boolean active) {
        LOG.trace("decrypt : selectkeys");
        if (active) {
            LOG.debug("set active : decrypt : selectkeys");
            LOG.info("\n------------------------- Entschl\u00fcsseln/Schl\u00fcssel w\u00e4hlen ... ----------------------");
            SwingUtilities.invokeLater(() -> {
                block1: {
                    IFDCurvedToggleIconButton button;
                    if (this.ifdList.isEmpty()) break block1;
                    Iterator<IFDCurvedToggleIconButton> iterator = this.ifdList.iterator();
                    while (!(!iterator.hasNext() || (button = iterator.next()).isEnabled() && button.isVisible() && button.isFocusable())) {
                    }
                }
            });
            LOG.info("\n------------------------- Entschl\u00fcsseln/Schl\u00fcssel w\u00e4hlen : ausgewaehlt ----------------------");
        } else {
            this.selectKeysStep.setLastSelectedJComponent(null);
        }
    }

    public KeyUsage getKeyUsage() {
        return this.selectKeysStep.keyUsage;
    }

    @Override
    public void requestFocus() {
    }

    private void changeRadioComponents() {
        if (this.selectKeysStep.usePassword()) {
            this.usePassword.setSelected(true);
            this.usePassword.requestFocus();
            this.selectKeysStep.usePassword(true);
            JComponentUtils.disableAllComponents((JComponent)this.certificateBorderPanel);
            JComponentUtils.disableAllComponents((JComponent)this.ifdPanel);
            JComponentUtils.disableAllComponents((JComponent)this.aliasPanel);
            JComponentUtils.disableAllComponents((JComponent)this.showCertificateButton);
        } else {
            this.useCertificate.setSelected(true);
            this.useCertificate.requestFocus();
            this.selectKeysStep.usePassword(false);
            JComponentUtils.enableAllComponents((JComponent)this.certificateBorderPanel);
            JComponentUtils.enableAllComponents((JComponent)this.ifdPanel);
            JComponentUtils.enableAllComponents((JComponent)this.aliasPanel);
            JComponentUtils.enableAllComponents((JComponent)this.showCertificateButton);
            for (IFDCurvedToggleIconButton button : this.ifdList) {
                this.updateIFDButton(button);
            }
        }
    }

    public void terminalAdded(TerminalModel terminal) {
        LOG.trace("decrypt : selectkeys");
        this.reinitGUI();
    }

    public void terminalRemoved(TerminalModel terminal) {
        LOG.trace("decrypt : selectkeys");
        this.reinitGUI();
    }

    public void selectAlias(AbstractKeyProvider keyProvider) {
        LOG.trace("decrypt : selectkeys");
        this.selectKeysStep.setSelectedKeyProvider(keyProvider);
    }

    private KeyListener createKeyAdapterFor(final IFDCurvedToggleIconButton button) {
        button.setFocusTraversalKeysEnabled(false);
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isConsumed()) {
                    return;
                }
                switch (keyEvent.getKeyCode()) {
                    case 9: {
                        if (keyEvent.isShiftDown()) {
                            button.getParent().transferFocusBackward();
                            keyEvent.consume();
                            break;
                        }
                        button.transferFocus();
                        keyEvent.consume();
                        break;
                    }
                    case 39: 
                    case 40: {
                        SelectKeysView.this.ifdGroup.createListFromGroup();
                        IFDCurvedToggleIconButton next = SelectKeysView.this.ifdGroup.getNextFromFocused(button);
                        if (next == null || !next.isVisible() || !next.isEnabled()) {
                            button.transferFocus();
                            keyEvent.consume();
                            break;
                        }
                        next.requestFocusInWindow();
                        keyEvent.consume();
                        break;
                    }
                    case 37: 
                    case 38: {
                        SelectKeysView.this.ifdGroup.createListFromGroup();
                        IFDCurvedToggleIconButton previous = SelectKeysView.this.ifdGroup.getPreviousFromFocused(button);
                        if (previous == null || !previous.isVisible() || !previous.isEnabled()) {
                            button.transferFocusBackward();
                            keyEvent.consume();
                            break;
                        }
                        previous.requestFocus();
                        keyEvent.consume();
                        break;
                    }
                }
            }
        };
    }

    protected class IFDButtonGroup
    extends ButtonGroup {
        private static final long serialVersionUID = -7499109778321269525L;
        private List<IFDCurvedToggleIconButton> listFromGroup;

        protected IFDButtonGroup() {
        }

        protected void createListFromGroup() {
            this.listFromGroup = new ArrayList<IFDCurvedToggleIconButton>(this.getButtonCount());
            Enumeration<AbstractButton> elements = this.getElements();
            int ifdListIndex = -1;
            while (elements.hasMoreElements()) {
                IFDCurvedToggleIconButton button = (IFDCurvedToggleIconButton)elements.nextElement();
                button.setId(++ifdListIndex);
                this.listFromGroup.add(button);
            }
        }

        protected IFDCurvedToggleIconButton getNextFromFocused(IFDCurvedToggleIconButton focused) {
            if (focused.getId() == this.listFromGroup.size() - 1) {
                return this.listFromGroup.get(0);
            }
            return this.listFromGroup.get(focused.getId() + 1);
        }

        protected IFDCurvedToggleIconButton getPreviousFromFocused(IFDCurvedToggleIconButton focused) {
            if (focused.getId() == 0) {
                return this.listFromGroup.get(this.listFromGroup.size() - 1);
            }
            return this.listFromGroup.get(focused.getId() - 1);
        }
    }
}

