/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.decrypt.gui.step;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.DropSelectedFileHandler;
import de.bos_bremen.ecard.client.action.RemoveFileHandler;
import de.bos_bremen.ecard.client.action.SelectedFileHandler;
import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.control.process.ProcessName;
import de.bos_bremen.ecard.client.control.step.StepChangedListener;
import de.bos_bremen.ecard.client.decrypt.control.step.SelectFiles;
import de.bos_bremen.ecard.client.gui.view.component.CurvedBorder;
import de.bos_bremen.ecard.client.gui.view.component.DescriptionPanel;
import de.bos_bremen.ecard.client.gui.view.component.JComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.LocaleChanger;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IconButton;
import de.bos_bremen.ecard.client.gui.view.component.table.FileDropTargetHandler;
import de.bos_bremen.ecard.client.gui.view.component.table.processfile.ProcessFileTableFactory;
import de.bos_bremen.ecard.client.gui.view.component.table.processfile.ProcessFileTableI;
import de.bos_bremen.ecard.client.gui.view.component.table.processfile.ProcessFileTableListenerFactory;
import de.bos_bremen.ecard.client.gui.view.component.table.processfile.ProcessFileTableModelI;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.ProcessFileSeen;
import de.bos_bremen.ecard.client.model.ViewableProcessFile;
import de.bos_bremen.ecard.client.model.error.SignerException;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SelectFilesView
extends JPanel
implements StepChangedListener,
DropSelectedFileHandler,
RemoveFileHandler,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger(SelectFilesView.class);
    private final transient SelectFiles selectFilesStep;
    private transient ProcessFileTableI processFileTable;

    public SelectFilesView(SelectFiles step) {
        LOG.trace("decrypt : selectfiles");
        this.selectFilesStep = step;
        this.initGUI();
        this.selectFilesStep.addStateChangeListener(this);
        LocaleChanger.getInstance().addObserver((PropertyChangeListener)this);
    }

    private void initGUI() {
        LOG.trace("decrypt : selectfiles");
        this.setLayout(new BorderLayout());
        DescriptionPanel descPanel = new DescriptionPanel("step." + this.selectFilesStep.getStepName().toString());
        this.add((Component)descPanel, "North");
        this.processFileTable = ProcessFileTableFactory.createProcessFileTable((ProcessName)this.selectFilesStep.getParent().getProcessName());
        ((JTable)this.processFileTable).addMouseListener(ProcessFileTableListenerFactory.createProcessFileTableMouseListener((ProcessI)this.selectFilesStep.getParent()));
        final JScrollPane scrollPane = new JScrollPane((JTable)this.processFileTable);
        scrollPane.setBorder((Border)CurvedBorder.DEFAULT_BORDER);
        ((JTable)this.processFileTable).addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                scrollPane.setBorder((Border)CurvedBorder.FOCUSED_BORDER);
            }

            @Override
            public void focusLost(FocusEvent e) {
                scrollPane.setBorder((Border)CurvedBorder.DEFAULT_BORDER);
            }
        });
        String mnemonic = Messages.getResource((String)"view.step.selectfiles.list.header.mnemonic");
        KeyStroke ks = KeyStroke.getKeyStroke("alt " + mnemonic.charAt(0));
        int condition = 2;
        scrollPane.getInputMap(condition).put(ks, "selectTable");
        scrollPane.getActionMap().put("selectTable", new SetFocusOnTableAction());
        this.add((Component)scrollPane, "Center");
        new DropTarget(scrollPane, (DropTargetListener)new FileDropTargetHandler((DropSelectedFileHandler)this));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(2, 1));
        this.add((Component)buttonPanel, "West");
        Document documentInstance = Document.getInstance();
        IconButton selectFilesButtonAdd = new IconButton();
        selectFilesButtonAdd.setAction(documentInstance.getActionFactory().createSelectFile((SelectedFileHandler)this, "action.selectfile", 0, true, true));
        if (documentInstance.getProductFunctions().getLicence(this.selectFilesStep.getLicenceTypKey() + "/addfiles").isVisible()) {
            buttonPanel.add((Component)selectFilesButtonAdd);
            selectFilesButtonAdd.getAction().setEnabled(documentInstance.getProductFunctions().getLicence(this.selectFilesStep.getLicenceTypKey() + "/addfiles").isEditable());
        }
        IconButton selectFilesButtonRemove = new IconButton();
        selectFilesButtonRemove.setAction(documentInstance.getActionFactory().createRemoveFile((RemoveFileHandler)this, "action.removefile"));
        KeyStroke deleteKeyStroke = KeyStroke.getKeyStroke("DELETE");
        this.getInputMap(1).put(deleteKeyStroke, "deleteAction");
        this.getActionMap().remove("deleteAction");
        this.getActionMap().put("deleteAction", selectFilesButtonRemove.getAction());
        if (documentInstance.getProductFunctions().getLicence(this.selectFilesStep.getLicenceTypKey() + "/removefiles").isVisible()) {
            buttonPanel.add((Component)selectFilesButtonRemove);
            selectFilesButtonRemove.getAction().setEnabled(documentInstance.getProductFunctions().getLicence(this.selectFilesStep.getLicenceTypKey() + "/removefiles").isEditable());
        }
        if (!documentInstance.getProductFunctions().getLicence(this.selectFilesStep.getLicenceTypKey()).useInProcess()) {
            this.selectFilesStep.removeAllFiles();
        }
        this.stateChanged(null);
        JComponentUtils.setLookByLicence((JComponent)this, (LicenceTyp)this.selectFilesStep.getLicenceTyp());
    }

    public void stateChanged(ChangeEvent event) {
        LOG.trace("decrypt : selectfiles");
        ((ProcessFileTableModelI)this.processFileTable.getModel()).setDataVector(this.selectFilesStep.getFiles().toArray());
        this.processFileTable.setColumnWidth();
    }

    public File getLastFolder() {
        LOG.trace("decrypt : selectfiles");
        String lastUsedFolder = this.selectFilesStep.getApplicationProperties().getProperty("last_folder", null);
        File lastFolder = null;
        if (lastUsedFolder != null) {
            lastFolder = new File(lastUsedFolder);
        }
        return lastFolder;
    }

    public void setFileToLoad(File fileToLoad) {
        LOG.trace("decrypt : selectfiles");
        if (fileToLoad == null) {
            return;
        }
        if (!fileToLoad.isFile()) {
            LOG.warn("{}{}", (Object)fileToLoad.getName(), (Object)" is not a file");
            return;
        }
        if (this.fileExists(fileToLoad)) {
            LOG.warn("{}{}", (Object)fileToLoad.getName(), (Object)" is exists");
            return;
        }
        this.selectFilesStep.addFile(new ProcessFileSeen(fileToLoad));
        this.selectFilesStep.setApplicationProperty("last_folder", fileToLoad.getAbsolutePath());
    }

    public void setFilesToLoad(File[] filesToLoad) {
        LOG.trace("decrypt : selectfiles");
        if (filesToLoad == null || filesToLoad.length == 0) {
            return;
        }
        for (File file : filesToLoad) {
            this.setFileToLoad(file);
        }
    }

    public LicenceTyp getLicenceTyp() {
        LOG.trace("decrypt : selectfiles");
        return Document.getInstance().getProductFunctions().getLicence(this.selectFilesStep.getLicenceTypKey() + "/addfiles");
    }

    private boolean fileExists(File file) {
        String absoluteName = file.getAbsolutePath();
        List<ProcessFileSeen> files = this.selectFilesStep.getFiles();
        for (ViewableProcessFile viewableProcessFile : files) {
            if (!viewableProcessFile.getFile().getAbsolutePath().equals(absoluteName)) continue;
            return true;
        }
        return false;
    }

    public Object[] getFilesToRemove() {
        LOG.trace("decrypt : selectfiles");
        int[] selectedRows = this.processFileTable.getSelectedValues();
        Object[] objectsToRemove = new Object[selectedRows.length];
        List<ProcessFileSeen> alleFiles = this.selectFilesStep.getFiles();
        for (int i = 0; i < selectedRows.length; ++i) {
            objectsToRemove[i] = alleFiles.get(selectedRows[i]);
        }
        return objectsToRemove;
    }

    public void removeFiles(Object[] filesToRemove) {
        LOG.trace("decrypt : selectfiles");
        LOG.debug("removeFiles for {}{}", (Object)filesToRemove.length, (Object)" elemente");
        for (Object obj : filesToRemove) {
            if (!(obj instanceof ProcessFileSeen)) continue;
            ProcessFileSeen processFileSeen = (ProcessFileSeen)obj;
            this.selectFilesStep.removeFile(processFileSeen);
        }
        this.processFileTable.clearSelection();
    }

    public void refreshTable(int row) {
        LOG.info("SelectedFilesView.{}{}", (Object)this.selectFilesStep.getParent(), (Object)".refreshTable BEGIN");
        ProcessFileTableModelI model = (ProcessFileTableModelI)this.processFileTable.getModel();
        ViewableProcessFile file = model.getProcessFileAt(row);
        try {
            file.setSeen(true);
        }
        catch (SignerException e) {
            Document.getInstance().reportError(e, false, new Object[0]);
        }
        LOG.info("SelectedFilesView.refreshTable END");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        LOG.trace("decrypt : selectfiles");
        this.removeAll();
        this.initGUI();
        this.revalidate();
    }

    public void setActive(boolean active) {
        LOG.trace("decrypt : selectfiles");
        if (active) {
            LOG.debug("set active : decrypt : selectfiles");
            LOG.info("\n------------------------- Entschl\u00fcsseln/Dateiauswahl : ausgew\u00e4hlt ----------------------------");
        }
    }

    private class SetFocusOnTableAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent arg0) {
            SelectFilesView.this.processFileTable.requestFocusInWindow();
            ((JTable)SelectFilesView.this.processFileTable).getSelectionModel().setSelectionInterval(0, 0);
        }
    }
}

