/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.decrypt.gui;

import de.bos_bremen.ecard.client.AbstractProcessHelper;
import de.bos_bremen.ecard.client.control.process.ProcessFactory;
import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.decrypt.control.process.impl.DecryptProcess;
import de.bos_bremen.ecard.client.decrypt.model.formular.process.DecryptProcessFormular;
import de.bos_bremen.ecard.client.model.BooleanTriState;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.HashedFile;
import de.bos_bremen.ecard.client.model.ProcessSignedFile;
import de.bos_bremen.ecard.client.model.TargetFolderType;
import de.bos_bremen.ecard.client.model.error.SignerException;
import de.bos_bremen.ecard.client.model.formular.process.ProcessFormular;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DecryptProcessHelper
extends AbstractProcessHelper {
    private static final Logger LOG = LogManager.getLogger(DecryptProcessHelper.class);

    public ProcessFormular fillDecryptFormular(String serialnumber, String[] inputFile, TargetFolderType targetFolderType, String outputFolder, BooleanTriState extractZipArchiv, BooleanTriState usePassword, boolean replaceFiles) {
        ProcessFormular processesFormular = null;
        ProcessFactory processFactory = Document.getInstance().getProcessFactory();
        ProcessI process = processFactory.getProcess(DecryptProcess.PROCESS_NAME);
        LOG.info("fillSignFormular:getProcess {}", (Object)process);
        if (process != null && (processesFormular = processFactory.getProcessesFormular(process)) instanceof DecryptProcessFormular) {
            DecryptProcessFormular decryptFormular = (DecryptProcessFormular)processesFormular;
            decryptFormular.addBlockRequest();
            decryptFormular.setSerialnumber(serialnumber);
            ArrayList inputFileList = new ArrayList();
            try {
                this.getInputfiles(inputFile, inputFileList, true);
            }
            catch (SignerException e) {
                LOG.error("", (Throwable)e);
            }
            if (!inputFileList.isEmpty()) {
                ArrayList<HashedFile> inputFiles = new ArrayList<HashedFile>();
                for (ProcessSignedFile processSignedFile : inputFileList) {
                    inputFiles.add(processSignedFile.getFile());
                }
                decryptFormular.setSelectedFiles(inputFiles, replaceFiles);
            } else if (replaceFiles) {
                decryptFormular.removeAllFiles();
            }
            if (!targetFolderType.equals((Object)TargetFolderType.useDefault)) {
                decryptFormular.setTargetFolderType(TargetFolderType.valueOf((String)targetFolderType.toString()));
            }
            if (!"".equals(outputFolder)) {
                decryptFormular.setTargetFolder(outputFolder);
            }
            if (!BooleanTriState.useDefault.equals((Object)extractZipArchiv)) {
                decryptFormular.extractZipArchiv(BooleanTriState.yes.equals((Object)extractZipArchiv));
            }
            if (!BooleanTriState.useDefault.equals((Object)usePassword)) {
                decryptFormular.usePassword(BooleanTriState.yes.equals((Object)usePassword));
            }
            decryptFormular.removeBlockRequest();
        }
        LOG.info("fillSignFormular:return {}", (Object)processesFormular);
        return processesFormular;
    }
}

