/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.decrypt.control.step;

import de.bos_bremen.ecard.client.control.step.KeyProviderStep;
import de.bos_bremen.ecard.client.control.step.StepFactory;
import de.bos_bremen.ecard.client.decrypt.gui.step.SelectKeysView;
import de.bos_bremen.ecard.client.decrypt.model.formular.process.DecryptProcessFormular;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.KeyUsage;
import de.bos_bremen.ecard.client.model.formular.steps.StepFormular;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProvider;
import de.bos_bremen.ecard.client.model.keyprovider.SignServiceKey;
import de.bos_bremen.ecard.client.model.keyprovider.SoftwareKey;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.model.licence.ProductFunctions;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectKeys
extends KeyProviderStep {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SelectKeys.class);
    private static final String USE_PASSWORD_KEY = "usePassword";

    public SelectKeys() {
        super(StepFactory.StepName.selectkeys, KeyUsage.DECRYPT);
    }

    public void setJComponent() {
        this.viewPanel = new SelectKeysView(this);
    }

    public HashMap<String, LicenceTyp> getDefaultLicenceTypes() {
        HashMap<String, LicenceTyp> processLicenceTypes = new HashMap<String, LicenceTyp>();
        processLicenceTypes.put(this.getLicenceTypKey(), LicenceTyp.enable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/certificate", LicenceTyp.enable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/certificate/software", LicenceTyp.enable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/password", LicenceTyp.enable);
        return processLicenceTypes;
    }

    public boolean setProcessFormular(StepFormular form) {
        if (!(form instanceof DecryptProcessFormular)) {
            return false;
        }
        if (!super.setProcessFormular(form)) {
            return false;
        }
        this.form = form;
        DecryptProcessFormular decryptProcessFormular = (DecryptProcessFormular)this.form;
        Boolean usePassword = decryptProcessFormular.usePassword();
        if (usePassword == null) {
            decryptProcessFormular.usePassword(Boolean.valueOf(this.stepProperties.getProperty(USE_PASSWORD_KEY)));
        }
        if (usePassword == null) {
            usePassword = false;
        }
        if (usePassword.booleanValue()) {
            this.removeAllPropertiesProvider();
        }
        return true;
    }

    public boolean usePassword() {
        StepFormular stepFormular = this.form;
        if (!(stepFormular instanceof DecryptProcessFormular)) {
            return false;
        }
        DecryptProcessFormular decryptProcessFormular = (DecryptProcessFormular)stepFormular;
        if (decryptProcessFormular.usePassword() == null) {
            return false;
        }
        return decryptProcessFormular.usePassword();
    }

    public void usePassword(boolean usePassword) {
        StepFormular stepFormular = this.form;
        if (!(stepFormular instanceof DecryptProcessFormular)) {
            return;
        }
        DecryptProcessFormular decryptProcessFormular = (DecryptProcessFormular)stepFormular;
        decryptProcessFormular.usePassword(usePassword);
        this.stepProperties.put((Object)USE_PASSWORD_KEY, (Object)Boolean.toString(usePassword));
    }

    public boolean isStateComplete() {
        if (this.usePassword()) {
            return true;
        }
        boolean keyProviderOK = false;
        List keyProviderToUse = this.getKeyProviderToUse();
        if (keyProviderToUse == null) {
            return keyProviderOK;
        }
        if (keyProviderToUse.isEmpty()) {
            return keyProviderOK;
        }
        if (((KeyProvider)keyProviderToUse.get(0)).getSelectedAlias() == null) {
            return keyProviderOK;
        }
        ProductFunctions productFunctions = Document.getInstance().getProductFunctions();
        for (KeyProvider keyProvider : keyProviderToUse) {
            if (keyProvider instanceof SoftwareKey) {
                log.trace("KeyProvider : {}", (Object)keyProvider.getIFDName());
                if (!productFunctions.getLicence(this.getLicenceTypKey() + "/certificate/software").useInProcess()) continue;
                keyProviderOK = true;
                continue;
            }
            if (keyProvider instanceof SignServiceKey) {
                log.trace("KeyProvider : {}", (Object)keyProvider.getIFDName());
                if (!productFunctions.getLicence(this.getLicenceTypKey() + "/certificate/netsigner").useInProcess()) continue;
                keyProviderOK = keyProvider.getSelectedAlias() != null;
                continue;
            }
            log.trace("KeyProvider : {}", (Object)keyProvider.getIFDName());
            if (!productFunctions.getLicence(this.getLicenceTypKey() + "/certificate").useInProcess()) continue;
            keyProviderOK = true;
        }
        return keyProviderOK;
    }
}

