/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.decrypt.control.step;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.control.step.StepFactory;
import de.bos_bremen.ecard.client.control.step.WorkingResult;
import de.bos_bremen.ecard.client.control.step.working.WorkingStep;
import de.bos_bremen.ecard.client.decrypt.DecryptFunction;
import de.bos_bremen.ecard.client.decrypt.control.process.impl.DecryptConfig;
import de.bos_bremen.ecard.client.decrypt.gui.step.DecryptView;
import de.bos_bremen.ecard.client.decrypt.model.formular.process.DecryptProcessFormular;
import de.bos_bremen.ecard.client.gui.dialog.PasswordDialog;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.DetachableFile;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.KeyUsage;
import de.bos_bremen.ecard.client.model.SubsequentProcess;
import de.bos_bremen.ecard.client.model.TargetFolderType;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.error.ErrorObject;
import de.bos_bremen.ecard.client.model.error.FileExistException;
import de.bos_bremen.ecard.client.model.error.FileInUseException;
import de.bos_bremen.ecard.client.model.formular.steps.SelectTargetFolderFormular;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProvider;
import de.bos_bremen.ecard.client.model.licence.Licence;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.util.XMLProperties;
import de.bos_bremen.gov2.jca_provider.CipherNotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.CipherPINInputCancelledException;
import de.bos_bremen.gov2.jca_provider.CipherRetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.CipherWrongPINException;
import de.governikus.csl.ECardProgressListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.model.FileHeader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.operator.OperatorException;

public class Decrypt
extends WorkingStep {
    private static final Logger LOG = LogManager.getLogger(Decrypt.class);

    public Decrypt() {
        super(StepFactory.StepName.decrypt);
    }

    public void setJComponent() {
        this.viewPanel = new DecryptView(this);
    }

    public void setDefaults(XMLProperties propertiesForNode) {
        super.setDefaults(propertiesForNode);
        this.notifyAllStateChangeListener(null, propertiesForNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(SubsequentProcess process) {
        this.reset();
        DecryptProcessFormular decryptFormular = (DecryptProcessFormular)this.form;
        this.buildWorkingResult();
        Document documentInstance = Document.getInstance();
        if (!this.canMoveToTargetFolder(decryptFormular)) {
            this.finished(process, documentInstance.getWorkingResults().size());
            return;
        }
        Document.getInstance().notifyProgressListeners(ECardProgressListener.ProgressType.DECRYPT_CONTENT, -1);
        List workingResultList = documentInstance.getWorkingResults();
        int errorCounter = 0;
        boolean cancelled = false;
        for (int i = 0; workingResultList != null && i < workingResultList.size(); ++i) {
            documentInstance.resetLastErrorObject();
            WorkingResult workingResult = (WorkingResult)workingResultList.get(i);
            if (cancelled) {
                documentInstance.reportError(ErrorCode.FILE_CANCELLED, false, new Object[]{workingResult.getSourceFile()});
                workingResult.setCurrentState(WorkingResult.Status.ABORTED);
                continue;
            }
            if (!this.checkSourceFileBeforeProcess(workingResult, decryptFormular.getTargetFolderType())) {
                cancelled = documentInstance.getLastReportedErrorObject().abortError();
                ++errorCounter;
                continue;
            }
            workingResult.setCurrentState(WorkingResult.Status.WORKING);
            String resultFileName = this.getResultFileName(workingResult);
            LOG.debug("Decrypt ResultFileName : {}", (Object)resultFileName);
            WorkingStep.Repeat currentRepeat = this.canMoveToTargetFolder(decryptFormular, workingResult, resultFileName);
            if (WorkingStep.Repeat.CANCEL == this.lastRepeat) {
                cancelled = true;
                ++errorCounter;
                continue;
            }
            if (WorkingStep.Repeat.SKIP.equals((Object)currentRepeat) || WorkingStep.Repeat.SKIP_ALL.equals((Object)currentRepeat)) {
                ++errorCounter;
                continue;
            }
            List<File> decryptedDcuments = null;
            try {
                decryptedDcuments = Boolean.TRUE.equals(decryptFormular.usePassword()) ? this.passwordDecryption(workingResult) : this.keyDecryption(decryptFormular, workingResult);
            }
            catch (CMSException ex) {
                this.reportError(ex);
                cancelled = true;
                ++errorCounter;
            }
            catch (Exception ex) {
                LOG.error("", (Throwable)ex);
                cancelled = false;
                ++errorCounter;
                continue;
            }
            if (decryptedDcuments == null || decryptedDcuments.isEmpty()) {
                workingResult.setCurrentState(WorkingResult.Status.ERROR);
                continue;
            }
            try {
                File resultFile2;
                Boolean extractZipArchiv = decryptFormular.extractZipArchiv();
                if (extractZipArchiv != null && !extractZipArchiv.booleanValue()) {
                    for (File file : decryptedDcuments) {
                        resultFile2 = this.moveResultDocumentToTargetFolder(decryptFormular, (File)workingResult.getSourceFile(), file, resultFileName, false, false, false);
                        if (resultFile2 == null) continue;
                        workingResult.addResultFile(resultFile2);
                    }
                    workingResult.setCurrentState(WorkingResult.Status.FINISHED);
                    documentInstance.reportError(ErrorCode.FILE_PROCESSED, true, new Object[]{workingResult.getSourceFile()});
                    this.notifyProgressListener(null, workingResult);
                    continue;
                }
                for (File file : decryptedDcuments) {
                    resultFile2 = file.getName().toLowerCase().endsWith(".zip") ? this.moveResultDocumentToTargetFolder(decryptFormular, (File)workingResult.getSourceFile(), file, resultFileName, false, false, false, false, true) : this.moveResultDocumentToTargetFolder(decryptFormular, (File)workingResult.getSourceFile(), file, resultFileName, false, false, false);
                    if (resultFile2 == null) continue;
                    workingResult.addResultFile(resultFile2);
                }
                workingResult.setCurrentState(WorkingResult.Status.FINISHED);
                documentInstance.reportError(ErrorCode.FILE_PROCESSED, true, new Object[]{workingResult.getSourceFile()});
                this.notifyProgressListener(null, workingResult);
                boolean isZip = false;
                for (File resultFile2 : workingResult.getResult()) {
                    if (!resultFile2.getName().toLowerCase().endsWith(".zip")) continue;
                    isZip = true;
                }
                if (isZip) {
                    List<WorkingResult> list = this.extractZipArchiv(workingResult, decryptFormular);
                    if (documentInstance.getLastReportedErrorObject() != null && documentInstance.getLastReportedErrorObject().abortError()) {
                        cancelled = true;
                        continue;
                    }
                    if (list == null || !list.isEmpty()) {
                        workingResult.setCurrentState(WorkingResult.Status.UNZIPPED);
                        ++i;
                    } else {
                        WorkingResult tmpResult = new WorkingResult();
                        tmpResult.setCurrentState(WorkingResult.Status.ERROR);
                        ErrorObject errorObject = new ErrorObject();
                        errorObject.setErrorMessage(MessageFormat.format(Messages.getString((String)"step.decrypt.error.unzip"), workingResult.getResult().get(0)));
                        errorObject.setErrorCode(ErrorCode.CANNOT_UNZIP);
                        tmpResult.setErrorObject(errorObject);
                        list.add(tmpResult);
                        ++i;
                        ++errorCounter;
                    }
                    workingResultList.addAll(i, list);
                }
            }
            catch (FileExistException | FileInUseException ex) {
                LOG.error((Object)ex, ex);
                cancelled = true;
                ++errorCounter;
                workingResult.setCurrentState(WorkingResult.Status.ABORTED);
                continue;
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
                ++errorCounter;
                documentInstance.reportError(ErrorCode.UNKNOWN, true, new Object[0]);
                workingResult.setErrorObject(documentInstance.getLastReportedErrorObject());
                cancelled = documentInstance.getLastReportedErrorObject().abortError();
                continue;
            }
            finally {
                this.notifyProgressListener(null, workingResult);
            }
        }
        this.displayFinishDialog(cancelled, errorCounter);
        this.state = WorkingStep.WorkingState.CALLING_SUBSEQUENT_PROCESS;
        if (process != null) {
            super.callSubsequentProcess(process);
        }
        boolean extractZip = decryptFormular.extractZipArchiv() != null && decryptFormular.extractZipArchiv() != false;
        this.deleteOriginalFiles(workingResultList, extractZip, cancelled);
        this.state = WorkingStep.WorkingState.FINISHED;
        this.notifyProgressListener(null, workingResultList);
        this.notifyAllStateChangeListener(null, workingResultList);
        this.parent.isFinished(true);
    }

    private void deleteOriginalFiles(List<WorkingResult> workingResultList, boolean extractZip, boolean cancelled) {
        if (cancelled) {
            return;
        }
        DecryptConfig config = (DecryptConfig)this.parent.getConfig();
        if (!config.useDeleteSource()) {
            return;
        }
        for (WorkingResult workingResult : workingResultList) {
            DetachableFile sourceFile = workingResult.getSourceFile();
            List result = workingResult.getResult();
            if (result == null || result.isEmpty()) continue;
            File targetFile = (File)result.get(0);
            LOG.info("source file: {}", (Object)sourceFile);
            LOG.info("target file: {}", (Object)targetFile);
            if (sourceFile == null || targetFile == null) continue;
            try {
                Files.delete(sourceFile.toPath());
            }
            catch (IOException e) {
                LOG.debug("could not delete folder: {}", (Object)sourceFile);
            }
            if (!extractZip || !targetFile.getName().toLowerCase().endsWith(".zip")) continue;
            try {
                Files.delete(targetFile.toPath());
            }
            catch (IOException e) {
                LOG.debug("could not delete folder: {}", (Object)targetFile);
            }
        }
    }

    private void reportError(CMSException e) {
        ErrorCode errorCode = ErrorCode.UNKNOWN;
        Throwable throwable = e.getCause();
        if (throwable instanceof OperatorException) {
            OperatorException oe = (OperatorException)throwable;
            Throwable cause = oe.getCause();
            LOG.error("{}", (Object)(cause == null ? "" : cause.getMessage()));
            if (cause instanceof CipherPINInputCancelledException) {
                errorCode = ErrorCode.PIN_INPUT_CANCEL;
            } else if (cause instanceof CipherWrongPINException) {
                errorCode = ErrorCode.INVALID_PIN;
            } else if (cause instanceof CipherRetryCounterExpiredException) {
                errorCode = ErrorCode.INVALID_PIN;
            } else if (cause instanceof CipherNotYetInitializedException) {
                errorCode = ErrorCode.INVALID_PIN;
            } else if (e.getMessage().equals("recipientInformation not found")) {
                errorCode = ErrorCode.WRONG_KEY;
            }
        }
        Document.getInstance().reportError(errorCode, false, new Object[]{""});
    }

    private boolean isZIPEncytped(File file) {
        boolean bl;
        ZipFile zipFile = new ZipFile(file);
        try {
            zipFile.getFileHeaders();
            bl = zipFile.isEncrypted();
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        zipFile.close();
        return bl;
    }

    private void reset() {
        this.lastRepeat = null;
        this.fullRepeat = null;
        Document.getInstance().resetLastErrorObject();
    }

    private void finished(SubsequentProcess process, int errorCounter) {
        Document documentInstance = Document.getInstance();
        List workingResultList = documentInstance.getWorkingResults();
        documentInstance.notifyProgressListeners(ECardProgressListener.ProgressType.DECRYPT_CONTENT, 1);
        this.displayFinishDialog(true, errorCounter);
        this.state = WorkingStep.WorkingState.CALLING_SUBSEQUENT_PROCESS;
        if (process != null) {
            super.callSubsequentProcess(process);
        }
        this.state = WorkingStep.WorkingState.FINISHED;
        this.notifyProgressListener(null, workingResultList);
        this.notifyAllStateChangeListener(null, workingResultList);
        this.parent.isFinished(true);
    }

    private KeyProvider getKeyProvider(DecryptProcessFormular decryptFormular) {
        if (Boolean.FALSE.equals(decryptFormular.usePassword())) {
            List keyProviderList = decryptFormular.getKeyProvider(KeyUsage.DECRYPT);
            return (KeyProvider)keyProviderList.get(0);
        }
        return null;
    }

    private String getResultFileName(WorkingResult workingResult) {
        String fileName = workingResult.getSourceFile().getName();
        LOG.debug("Decrypt SourceFileName : {}", (Object)fileName);
        String resultFileName = fileName.substring(0, fileName.lastIndexOf("."));
        LOG.debug("Decrypt ResultFileName : {}", (Object)resultFileName);
        return resultFileName;
    }

    private boolean canMoveToTargetFolder(DecryptProcessFormular formular) {
        if (formular.getTargetFolderType() != TargetFolderType.oneSpecial) {
            return true;
        }
        if (Utils.canWrite((String)formular.getTargetFolder())) {
            return true;
        }
        Document documentInstance = Document.getInstance();
        documentInstance.reportError(ErrorCode.CANNOT_WRITE_TO_FOLDER, false, new Object[]{formular.getTargetFolder()});
        List workingResultList = documentInstance.getWorkingResults();
        for (WorkingResult workingResult : workingResultList) {
            workingResult.setErrorObject(documentInstance.getLastReportedErrorObject());
            workingResult.setCurrentState(WorkingResult.Status.ERROR);
        }
        return false;
    }

    private WorkingStep.Repeat canMoveToTargetFolder(DecryptProcessFormular decryptFormular, WorkingResult workingResult, String resultFileName) {
        Document documentInstance = Document.getInstance();
        LOG.debug("Decrypt ResultFileName : {}", (Object)resultFileName);
        WorkingStep.Repeat currentRepeat = this.canMoveDocumentsToTargetFolder(decryptFormular.getTargetFolderType(), decryptFormular.getTargetFolder(), decryptFormular.getLocalCopyFolder(), (File)workingResult.getSourceFile(), resultFileName, false, false);
        LOG.debug("Decrypt Repeat : {}", (Object)currentRepeat);
        if (WorkingStep.Repeat.CANCEL == currentRepeat || WorkingStep.Repeat.SKIP == currentRepeat || WorkingStep.Repeat.SKIP_ALL == currentRepeat) {
            workingResult.setCurrentState(WorkingResult.Status.ABORTED);
            LOG.trace("reportError ...");
            documentInstance.reportError(ErrorCode.FILE_CANCELLED, false, new Object[]{workingResult.getSourceFile()});
        }
        return currentRepeat;
    }

    private boolean decryptZip(File file, String password, List<File> decryptedFiles) {
        char[] passwordChar2740 = password.toCharArray();
        String password2740 = Arrays.toString(passwordChar2740);
        try {
            this.decrypt(file, password, decryptedFiles);
        }
        catch (IOException e) {
            try {
                this.decrypt(file, password2740, decryptedFiles);
            }
            catch (IOException ex) {
                Document.getInstance().reportError(ErrorCode.INVALID_PIN, false, new Object[]{"Ungueltiges Passwort. Die Datei kann nicht entschluesselt werden. Bitte geben Sie ein gueltiges Passwort an!"});
                return false;
            }
        }
        return true;
    }

    private boolean decrypt(File file, String password, List<File> decryptedFiles) throws IOException {
        try (ZipFile zipFile = new ZipFile(file);){
            if (zipFile.isEncrypted()) {
                zipFile.setPassword(password.toCharArray());
            }
            zipFile.extractAll(Decrypt.getTempFolder().getAbsolutePath());
            for (Object object : zipFile.getFileHeaders()) {
                File decryptedFile = new File(Decrypt.getTempFolder(), ((FileHeader)object).getFileName());
                decryptedFiles.add(decryptedFile);
            }
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<WorkingResult> extractZipArchiv(WorkingResult wr, SelectTargetFolderFormular formular) throws FileExistException, FileInUseException {
        ArrayList<WorkingResult> workingResults = new ArrayList<WorkingResult>();
        for (File resultFile : wr.getResult()) {
            if (resultFile.getName().toLowerCase().indexOf(".zip") == -1) continue;
            WorkingResult workingResult = new WorkingResult(new DetachableFile(resultFile));
            try {
                ZipEntry zipEntry;
                java.util.zip.ZipFile zipFile = new java.util.zip.ZipFile(resultFile);
                File extractFolder = resultFile.getParentFile();
                workingResult.addResultFile(extractFolder);
                workingResult.setCurrentState(WorkingResult.Status.WORKING);
                workingResults.add(workingResult);
                Enumeration<? extends ZipEntry> tempEntries = zipFile.entries();
                while (tempEntries.hasMoreElements()) {
                    zipEntry = tempEntries.nextElement();
                }
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    zipEntry = entries.nextElement();
                    if (zipEntry.isDirectory()) {
                        File subDir = new File(extractFolder, this.getPath(zipEntry.getName()));
                        if (!subDir.getCanonicalPath().startsWith(extractFolder.getCanonicalPath())) {
                            throw new FileInUseException("Zip file entry outside of target directory.");
                        }
                        if (subDir.mkdir()) continue;
                        LOG.debug("{}{}", (Object)subDir.getAbsolutePath(), (Object)" konnte nicht erstellt werden");
                        continue;
                    }
                    File outPutFile = new File(extractFolder, this.getPath(zipEntry.getName()));
                    if (!outPutFile.getCanonicalPath().startsWith(extractFolder.getCanonicalPath())) {
                        throw new FileInUseException("Zip file entry outside of target directory.");
                    }
                    this.createFolder(outPutFile.getParentFile());
                    InputStream istr = zipFile.getInputStream(zipEntry);
                    try (FileOutputStream ostr = new FileOutputStream(outPutFile);){
                        byte[] buf = new byte[4096];
                        int read = istr.read(buf);
                        while (read != -1) {
                            ((OutputStream)ostr).write(buf, 0, read);
                            read = istr.read(buf);
                        }
                        if (TargetFolderType.oneSpecial.equals((Object)formular.getTargetFolderType()) && formular.getTargetFolder().indexOf("://") != -1 && formular.getTargetFolder().indexOf("file:") == -1) {
                            String resultFileName = workingResult.getSourceFile().getName().substring(0, workingResult.getSourceFile().getName().lastIndexOf("."));
                            this.moveResultDocumentToTargetFolder(formular, new File(this.getPath(zipEntry.getName())), outPutFile, resultFileName, false, false, false, true, false);
                        }
                        workingResult.setCurrentState(WorkingResult.Status.FINISHED);
                    }
                    catch (IOException ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                    }
                    finally {
                        if (istr == null) continue;
                        try {
                            istr.close();
                        }
                        catch (Exception t) {
                            LOG.debug("");
                        }
                    }
                }
                zipFile.close();
            }
            catch (ZipException e) {
                LOG.error((Object)e, (Throwable)e);
                if (e.getMessage().startsWith("invalid CEN header")) {
                    Document.getInstance().reportError(ErrorCode.CANNOT_UNZIP, true, new Object[0]);
                    workingResult.setCurrentState(WorkingResult.Status.ERROR);
                    continue;
                }
                workingResult.setCurrentState(WorkingResult.Status.ERROR);
            }
            catch (IOException e) {
                LOG.error((Object)e, (Throwable)e);
                Document.getInstance().reportError(ErrorCode.CANNOT_WRITE_TO_FOLDER, true, new Object[]{""});
                workingResult.setErrorObject(Document.getInstance().getLastReportedErrorObject());
                workingResult.setCurrentState(WorkingResult.Status.ERROR);
            }
        }
        return workingResults;
    }

    private void createFolder(File outPutFile) {
        if (!outPutFile.exists()) {
            this.createFolder(outPutFile.getParentFile());
            if (outPutFile.getParentFile().exists() && !outPutFile.exists() && !outPutFile.mkdir()) {
                LOG.debug("Das Verzeichnis {}{}", (Object)outPutFile.getAbsolutePath(), (Object)" konnte nicht erstellt werden");
            }
        }
    }

    private String getPath(String absolutPath) {
        if (absolutPath.indexOf(":") != -1) {
            if (absolutPath.indexOf("/") != -1) {
                return absolutPath.substring(absolutPath.indexOf("/") + 1);
            }
            return absolutPath.substring(absolutPath.indexOf(":") + 1);
        }
        return absolutPath;
    }

    public SubsequentProcess getDefaultSubsequentProcess() {
        return Config.getInstance().getSubsequentProcess(this.parent.getSubsequentProcessUID());
    }

    public HashMap<String, LicenceTyp> getDefaultLicenceTypes() {
        HashMap<String, LicenceTyp> processLicenceTypes = new HashMap<String, LicenceTyp>();
        processLicenceTypes.put(this.getLicenceTypKey(), LicenceTyp.enable);
        processLicenceTypes.put(Licence.Keys.general_actions_settings_subsequentprocess.toString(), LicenceTyp.enable);
        return processLicenceTypes;
    }

    private List<File> keyDecryption(DecryptProcessFormular decryptFormular, WorkingResult workingResult) throws Exception {
        LOG.info("");
        KeyProvider keyProvider = this.getKeyProvider(decryptFormular);
        Document documentInstance = Document.getInstance();
        if (keyProvider == null) {
            LOG.warn("keyProvider is null");
            documentInstance.reportError(ErrorCode.WRONG_KEY, true, new Object[0]);
            workingResult.setCurrentState(WorkingResult.Status.ERROR);
            workingResult.setErrorObject(documentInstance.getLastReportedErrorObject());
            throw new IOException(ErrorCode.WRONG_KEY.getDescription());
        }
        String alias = keyProvider.getSelectedAlias();
        if (alias == null) {
            LOG.warn("alias is null");
            documentInstance.reportError(ErrorCode.WRONG_KEY, true, new Object[0]);
            workingResult.setCurrentState(WorkingResult.Status.ERROR);
            workingResult.setErrorObject(documentInstance.getLastReportedErrorObject());
            throw new IOException(ErrorCode.WRONG_KEY.getDescription());
        }
        X509Certificate cert = keyProvider.getCertificate();
        PrivateKey key = keyProvider.getKey();
        DetachableFile sourceFile = workingResult.getSourceFile();
        File decryptedFile = new File(Decrypt.getTempFolder(), "ECardEncrypt.p7m");
        DecryptFunction.certificateDecryption(key, cert, (File)sourceFile, decryptedFile);
        ArrayList<File> decryptedDcuments = new ArrayList<File>();
        decryptedDcuments.add(decryptedFile);
        return decryptedDcuments;
    }

    private List<File> passwordDecryption(WorkingResult workingResult) throws IOException {
        LOG.info("");
        Document documentInstance = Document.getInstance();
        if (!this.isZIPEncytped((File)workingResult.getSourceFile())) {
            documentInstance.reportError(ErrorCode.WRONG_KEY, true, new Object[0]);
            workingResult.setCurrentState(WorkingResult.Status.ERROR);
            workingResult.setErrorObject(documentInstance.getLastReportedErrorObject());
            throw new IOException(ErrorCode.WRONG_KEY.getDescription());
        }
        PasswordDialog decryptPasswordDialog = new PasswordDialog(workingResult.getSourceFile().getName(), false);
        decryptPasswordDialog.setVisible(true);
        if (!decryptPasswordDialog.usePassword()) {
            LOG.debug("{} : {}", (Object)ErrorCode.PIN_INPUT_CANCEL.getReturnCode(), (Object)ErrorCode.PIN_INPUT_CANCEL.getDescription());
            documentInstance.reportError(ErrorCode.PIN_INPUT_CANCEL, true, new Object[0]);
            workingResult.setCurrentState(WorkingResult.Status.ABORTED);
            workingResult.setErrorObject(documentInstance.getLastReportedErrorObject());
            throw new IOException(ErrorCode.PIN_INPUT_CANCEL.getDescription());
        }
        ArrayList<File> decryptedDcuments = new ArrayList<File>();
        if (!this.decryptZip((File)workingResult.getSourceFile(), decryptPasswordDialog.getPassword(), decryptedDcuments)) {
            return null;
        }
        return decryptedDcuments;
    }
}

