/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.decrypt;

import de.bos_bremen.gov2.jca_provider.eccipher.OCFECDHKeyAgreementSpi;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.cms.CMSEnvelopedDataParser;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JceKeyAgreeRecipientId;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientId;
import org.bouncycastle.operator.OperatorException;

public class DecryptFunction {
    private static final Logger LOG = LogManager.getLogger(DecryptFunction.class);
    public static final int BUFFER_SIZE = 8192;

    private DecryptFunction() {
        throw new IllegalStateException("Utility class");
    }

    public static void certificateDecryption(Key key, X509Certificate certificate, File inputFile, File decryptedFile) throws Exception {
        LOG.info("");
        try (FileInputStream inputStream = new FileInputStream(inputFile);
             FileOutputStream outputStream = new FileOutputStream(decryptedFile);){
            CMSEnvelopedDataParser ep = new CMSEnvelopedDataParser((InputStream)inputStream);
            RecipientInformationStore recipients = ep.getRecipientInfos();
            RecipientInformation recipientInformation = recipients.get((RecipientId)new JceKeyTransRecipientId(certificate));
            if (recipientInformation == null) {
                recipientInformation = recipients.get((RecipientId)new JceKeyAgreeRecipientId(certificate));
            }
            if (recipientInformation == null) {
                OperatorException ex = new OperatorException("recipientInformation not found");
                throw new CMSException("recipientInformation not found", (Exception)ex);
            }
            Recipient recipient = DecryptFunction.getRecipient((PrivateKey)key, certificate);
            CMSTypedStream recData = recipientInformation.getContentStream(recipient);
            InputStream cmsInStream = recData.getContentStream();
            byte[] buffer = new byte[8192];
            int readBytes = 0;
            while ((readBytes = cmsInStream.read(buffer)) > 0) {
                ((OutputStream)outputStream).write(buffer, 0, readBytes);
            }
            outputStream.flush();
        }
    }

    public static Recipient getRecipient(PrivateKey key, X509Certificate certificate) throws Exception {
        LOG.info("");
        return OCFECDHKeyAgreementSpi.createRecipient((PrivateKey)key, (Certificate)certificate);
    }
}

