/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.pades.validation.ByteRange;
import eu.europa.esig.dss.pades.validation.PdfSignatureDictionary;
import java.io.Serializable;
import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfSignatureDictionaryComparator
implements Comparator<PdfSignatureDictionary>,
Serializable {
    private static final long serialVersionUID = 1451660656464810618L;
    private static final Logger LOG = LoggerFactory.getLogger(PdfSignatureDictionaryComparator.class);

    @Override
    public int compare(PdfSignatureDictionary o1, PdfSignatureDictionary o2) {
        ByteRange byteRange1 = o1.getByteRange();
        ByteRange byteRange2 = o2.getByteRange();
        int begin1 = byteRange1.getFirstPartStart();
        int begin2 = byteRange2.getFirstPartStart();
        int length1 = byteRange1.getLength();
        int length2 = byteRange2.getLength();
        int end1 = byteRange1.getFirstPartEnd();
        int end2 = byteRange2.getFirstPartEnd();
        if (begin1 >= begin2 && length1 < end2) {
            return -1;
        }
        if (begin2 >= begin1 && length2 < end1) {
            return 1;
        }
        if (byteRange1.equals(byteRange2)) {
            LOG.warn("More than one signature with the same byte range !");
            return o1.getSigningDate().compareTo(o2.getSigningDate());
        }
        LOG.warn("Strange byte ranges (ByteRange : {} / ByteRange : {})", (Object)byteRange1, (Object)byteRange2);
        if (end1 < end2) {
            return -1;
        }
        if (end1 > end2) {
            return 1;
        }
        return o1.getSigningDate().compareTo(o2.getSigningDate());
    }
}

