/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.pdf.DSSDictionaryExtractionUtils;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import java.util.Map;

public abstract class AbstractPdfDssDict
implements PdfDssDict {
    private static final long serialVersionUID = 625347967057384829L;
    private final Map<Long, CRLBinary> crlMap;
    private final Map<Long, OCSPResponseBinary> ocspMap;
    private final Map<Long, CertificateToken> certMap;

    protected AbstractPdfDssDict(PdfDict dssDictionary) {
        this.certMap = DSSDictionaryExtractionUtils.getCertsFromArray(dssDictionary, this.getDictionaryName(), this.getCertArrayDictionaryName());
        this.ocspMap = DSSDictionaryExtractionUtils.getOCSPsFromArray(dssDictionary, this.getDictionaryName(), this.getOCSPArrayDictionaryName());
        this.crlMap = DSSDictionaryExtractionUtils.getCRLsFromArray(dssDictionary, this.getDictionaryName(), this.getCRLArrayDictionaryName());
    }

    protected abstract String getDictionaryName();

    protected abstract String getCertArrayDictionaryName();

    protected abstract String getCRLArrayDictionaryName();

    protected abstract String getOCSPArrayDictionaryName();

    @Override
    public Map<Long, CRLBinary> getCRLs() {
        return this.crlMap;
    }

    @Override
    public Map<Long, OCSPResponseBinary> getOCSPs() {
        return this.ocspMap;
    }

    @Override
    public Map<Long, CertificateToken> getCERTs() {
        return this.certMap;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.certMap == null ? 0 : this.certMap.hashCode());
        result = 31 * result + (this.crlMap == null ? 0 : this.crlMap.hashCode());
        result = 31 * result + (this.ocspMap == null ? 0 : this.ocspMap.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractPdfDssDict other = (AbstractPdfDssDict)obj;
        if (this.certMap == null ? other.certMap != null : !this.certMap.equals(other.certMap)) {
            return false;
        }
        if (this.crlMap == null ? other.crlMap != null : !this.crlMap.equals(other.crlMap)) {
            return false;
        }
        return !(this.ocspMap == null ? other.ocspMap != null : !this.ocspMap.equals(other.ocspMap));
    }
}

