/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.pdf.SigFieldPermissions;

public class PdfSignatureField {
    private final PdfDict sigFieldDict;

    public PdfSignatureField(PdfDict sigFieldDict) {
        this.sigFieldDict = sigFieldDict;
    }

    public String getFieldName() {
        return this.sigFieldDict.getStringValue("T");
    }

    public SigFieldPermissions getLockDictionary() {
        PdfDict lock = this.sigFieldDict.getAsDict("Lock");
        if (lock != null) {
            return PAdESUtils.extractPermissionsDictionary(lock);
        }
        return null;
    }

    public String toString() {
        return "PdfSignatureField {name=" + this.getFieldName() + '}';
    }
}

