/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades;

import eu.europa.esig.dss.cades.signature.CAdESTimestampParameters;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.pades.PAdESCommonParameters;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import eu.europa.esig.dss.pdf.PdfSignatureCache;
import eu.europa.esig.dss.spi.DSSUtils;
import java.util.Date;

public class PAdESTimestampParameters
extends CAdESTimestampParameters
implements PAdESCommonParameters {
    protected PdfSignatureCache pdfSignatureCache;
    protected Date timestampDate = new Date();
    private int timestampSize = 9472;
    private String timestampFilter = "Adobe.PPKLite";
    private String timestampSubFilter = "ETSI.RFC3161";
    private String appName;
    private SignatureImageParameters timestampImageParameters;
    private char[] passwordProtection;

    public PAdESTimestampParameters() {
    }

    public PAdESTimestampParameters(DigestAlgorithm digestAlgorithm) {
        super(digestAlgorithm);
    }

    PAdESTimestampParameters(CAdESTimestampParameters cadesTimestampParameters) {
        this(cadesTimestampParameters.getDigestAlgorithm());
    }

    @Override
    public String getFilter() {
        return this.timestampFilter;
    }

    public void setFilter(String timestampFilter) {
        this.timestampFilter = timestampFilter;
    }

    @Override
    public String getSubFilter() {
        return this.timestampSubFilter;
    }

    public void setSubFilter(String timestampSubFilter) {
        this.timestampSubFilter = timestampSubFilter;
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    @Override
    public SignatureImageParameters getImageParameters() {
        if (this.timestampImageParameters == null) {
            this.timestampImageParameters = new SignatureImageParameters();
        }
        return this.timestampImageParameters;
    }

    public void setImageParameters(SignatureImageParameters timestampImageParameters) {
        this.timestampImageParameters = timestampImageParameters;
    }

    @Override
    public int getContentSize() {
        return this.timestampSize;
    }

    public void setContentSize(int timestampSize) {
        this.timestampSize = timestampSize;
    }

    @Override
    public Date getSigningDate() {
        return this.timestampDate;
    }

    @Override
    public char[] getPasswordProtection() {
        return this.passwordProtection;
    }

    public void setPasswordProtection(char[] passwordProtection) {
        this.passwordProtection = passwordProtection;
    }

    @Override
    public String getDeterministicId() {
        return DSSUtils.getDeterministicId((Date)this.timestampDate, null);
    }

    @Override
    public PdfSignatureCache getPdfSignatureCache() {
        if (this.pdfSignatureCache == null) {
            this.pdfSignatureCache = new PdfSignatureCache();
        }
        return this.pdfSignatureCache;
    }

    @Override
    public void reinit() {
        this.pdfSignatureCache = null;
    }
}

