/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.inspect.velocity;

import de.governikus.csl.inspect.velocity.HTMLEscapingResourceBundle;
import de.governikus.csl.inspect.velocity.VelocityHelper;
import java.util.regex.Pattern;

public class VelocityHelperFO
extends VelocityHelper {
    public static final String ZERO_WIDTH_SPACE = "&#x200B;";
    private static final String LINEBREAK = "-&#x000A;";
    private static final String REG_EXP_URL = "(https?|ftp)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;()]*[-a-zA-Z0-9+&@#/%?=~_|!:,;]";
    private static final Pattern URL_PATTERN = Pattern.compile("(https?|ftp)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;()]*[-a-zA-Z0-9+&@#/%?=~_|!:,;]");

    public Pattern getURLPattern() {
        return URL_PATTERN;
    }

    public static String wrap(String data) {
        if (data == null || data.length() <= 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int cnt = 0; cnt < data.length(); ++cnt) {
            sb.append(ZERO_WIDTH_SPACE);
            sb.append(data.charAt(cnt));
        }
        return sb.substring(ZERO_WIDTH_SPACE.length());
    }

    public String escapeHTMLWrappableURL(Object data) {
        return HTMLEscapingResourceBundle.escapeHTMLWrappableURL((Object)data, (String)ZERO_WIDTH_SPACE);
    }

    public String escapeContent(String unescapedContent) {
        return HTMLEscapingResourceBundle.escapeHTML((Object)unescapedContent);
    }

    public String extractDigest(String url) {
        String digest = super.extractDigest(url);
        if (digest != null) {
            StringBuilder sb = new StringBuilder(url.length());
            for (int i = 0; i < digest.length(); ++i) {
                char actChar = digest.charAt(i);
                sb.append(actChar);
                if (i != (digest.length() - 1) / 2) continue;
                sb.append(LINEBREAK);
            }
            return sb.toString();
        }
        return null;
    }
}

