/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.inspect.fop;

import de.governikus.csl.inspect.fop.FOPRenderException;
import de.governikus.csl.inspect.fop.FOPRenderer;
import de.governikus.csl.inspect.fop.JARResourceResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.fop.apps.FopConfParser;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryBuilder;
import org.apache.fop.fonts.FontManager;
import org.apache.xmlgraphics.io.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FOPRendererFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(FOPRendererFactory.class);
    private static final Map<String, FopFactory> FACTORIES = new HashMap<String, FopFactory>();
    private static final String FOP_CACHE_FILE_SYSTEM_PROPERTY = "fop.cache-file";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FOPRenderer newInstance(String fopBaseConfig) throws FOPRenderException {
        FopFactory fopFactory;
        Map<String, FopFactory> map = FACTORIES;
        synchronized (map) {
            fopFactory = FACTORIES.get(fopBaseConfig);
            if (fopFactory == null) {
                try (InputStream cfgStream = FOPRendererFactory.class.getResourceAsStream(fopBaseConfig);){
                    FopConfParser fopConfParser = new FopConfParser(cfgStream, new URI("jarprotocol:/"), (ResourceResolver)new JARResourceResolver());
                    FopFactoryBuilder fopFactoryBuilder = fopConfParser.getFopFactoryBuilder();
                    fopFactoryBuilder.setAccessibility(true);
                    FontManager fontManager = fopFactoryBuilder.getFontManager();
                    String userHome = System.getProperty("user.home");
                    if (userHome == null || !new File(userHome).exists()) {
                        boolean redirectCacheFile = false;
                        String cacheFileValue = System.getProperty(FOP_CACHE_FILE_SYSTEM_PROPERTY);
                        if (cacheFileValue != null) {
                            File cacheFile = new File(cacheFileValue);
                            if (!cacheFile.exists()) {
                                try {
                                    boolean successFullyCreated = cacheFile.createNewFile();
                                    if (!successFullyCreated) {
                                        FOPRendererFactory.logUnabilityToCreateCacheFile(cacheFileValue, null);
                                    }
                                }
                                catch (IOException | SecurityException ex) {
                                    FOPRendererFactory.logUnabilityToCreateCacheFile(cacheFileValue, ex);
                                }
                            }
                            if (cacheFile.isFile() && cacheFile.canWrite()) {
                                redirectCacheFile = true;
                                fontManager.setCacheFile(cacheFile.toURI());
                            } else {
                                LOGGER.error("FOP cache-file system property '{}' does not denote a writable file: '{}'. FOP font-cache will be disabled!", (Object)FOP_CACHE_FILE_SYSTEM_PROPERTY, (Object)cacheFileValue);
                            }
                        } else {
                            LOGGER.error("no home directory found and no cache file specified, FOP font-cache will be disabled");
                        }
                        if (!redirectCacheFile) {
                            fontManager.disableFontCache();
                        }
                    }
                    fopFactory = fopFactoryBuilder.build();
                    FACTORIES.put(fopBaseConfig, fopFactory);
                }
                catch (Exception ex) {
                    throw new FOPRenderException("Cannot load or parse FOP configuration from '" + fopBaseConfig + "'!", ex);
                }
            }
        }
        return new FOPRenderer(fopFactory);
    }

    private static void logUnabilityToCreateCacheFile(String cacheFileValue, Exception ex) {
        String msg = "Cannot create FOP cache-file: '{}'! FOP font-cache will be disabled!";
        if (LOGGER.isDebugEnabled() && ex != null) {
            LOGGER.debug(msg, (Object)cacheFileValue, (Object)ex);
        } else {
            LOGGER.error(msg, (Object)cacheFileValue);
        }
    }
}

