/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.inspect.fop;

import de.governikus.csl.inspect.fop.FOOutputFormat;
import de.governikus.csl.inspect.fop.FOPRenderException;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.Version;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FormattingResults;
import org.apache.fop.pdf.PDFUAMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FOPRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(FOPRenderer.class);
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();
    private static final String PDF_UA_MODE = "pdf-ua-mode";
    private final FopFactory factory;
    private final FOUserAgent userAgent;
    private FOOutputFormat outFormat = FOOutputFormat.PDF;
    private PDFUAMode pdfUAMode = PDFUAMode.PDFUA_1;

    public FOPRenderer(FopFactory fopFactory) {
        this.factory = fopFactory;
        this.userAgent = fopFactory.newFOUserAgent();
    }

    public void setFOOutputFormat(FOOutputFormat format) {
        this.outFormat = format;
    }

    public void setPDFUAMode(PDFUAMode mode) {
        this.pdfUAMode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Source foSource, OutputStream out) {
        LOG.debug("Start rendering FOP...");
        this.userAgent.setAccessibility(true);
        this.userAgent.setKeepEmptyTags(false);
        this.userAgent.setPdfUAEnabled(true);
        if (this.outFormat == FOOutputFormat.PDF && this.pdfUAMode != PDFUAMode.DISABLED) {
            this.userAgent.getRendererOptions().put(PDF_UA_MODE, PDFUAMode.PDFUA_1);
        }
        try (BufferedOutputStream bufferedOutStream = new BufferedOutputStream(out);){
            Fop fop = null;
            FopFactory fopFactory = this.factory;
            synchronized (fopFactory) {
                fop = this.factory.newFop(this.outFormat.getFormatText(), this.userAgent, (OutputStream)bufferedOutStream);
            }
            Transformer identityTransformer = TRANSFORMER_FACTORY.newTransformer(foSource);
            identityTransformer.setParameter("fop-output-format", this.outFormat.getFormatText());
            identityTransformer.setParameter("fop-version", Version.getVersion());
            StreamSource nullSource = new StreamSource((InputStream)null);
            SAXResult resultPipeToFOP = new SAXResult(fop.getDefaultHandler());
            identityTransformer.transform(nullSource, resultPipeToFOP);
            ((OutputStream)bufferedOutStream).flush();
            FormattingResults foResults = fop.getResults();
            LOG.debug("Finished rendering FOP (generated {} pages)", (Object)foResults.getPageCount());
        }
        catch (Exception ex) {
            throw new FOPRenderException("Cannot render FOP", ex);
        }
    }
}

