/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.inspect.fo;

import de.governikus.csl.inspect.common.AbstractInspectionSheetOutput;
import de.governikus.csl.inspect.fo.FOPConfigurationConstants;
import de.governikus.csl.inspect.fop.FOPRenderer;
import de.governikus.csl.inspect.fop.FOPRendererFactory;
import de.governikus.csl.inspect.fop.PDFMetadata;
import de.governikus.csl.inspect.model.PreprocessedValidationReport;
import de.governikus.csl.inspect.velocity.HTMLEscapingResourceBundle;
import de.governikus.csl.inspect.velocity.VelocityHelper;
import de.governikus.csl.inspect.velocity.VelocityHelperFO;
import de.governikus.csl.uom.i18n.ChainingResourceBundle;
import de.governikus.csl.uom.output.LayoutException;
import de.governikus.csl.uom.output.SchemaConformityReport;
import de.governikus.csl.uom.util.TempDataManagerImpl;
import de.governikus.csl.uom.validate.ValidateResponse;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.utils.CslTimingUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.time.Instant;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.pdf.PDFUAMode;
import org.apache.velocity.VelocityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InspectionSheetPDF
extends AbstractInspectionSheetOutput {
    private static final Logger LOGGER = LoggerFactory.getLogger(InspectionSheetPDF.class);
    private static final String MAIN_TEMPLATE_FILE_PATH = "/xslfo/inspectionsheet.vm";

    public InspectionSheetPDF() {
        this(Locale.getDefault());
    }

    public InspectionSheetPDF(Locale locale) {
        this.setLocale(locale);
    }

    protected String getTemplateFilePath() {
        return MAIN_TEMPLATE_FILE_PATH;
    }

    public String getMimeType() {
        return "application/pdf";
    }

    public String getName() {
        return "PDF Inspection Sheet";
    }

    protected VelocityHelper getHelper() {
        return new VelocityHelperFO();
    }

    protected ResourceBundle getResourceBundle() {
        ChainingResourceBundle crb = new ChainingResourceBundle("inspectionsheet", this.getLocale());
        crb.addOverlay("xslfo/pdf_messages");
        return new HTMLEscapingResourceBundle((ResourceBundle)crb);
    }

    protected void appendToContext(VelocityContext context, ResourceBundle bundle, PreprocessedValidationReport pModel) {
        PDFMetadata metadata = (PDFMetadata)context.get("metadata");
        if (metadata == null) {
            metadata = new PDFMetadata(this.getLocale());
            context.put("metadata", (Object)metadata);
        }
        if (metadata.getAuthor() == null) {
            metadata.setAuthor(bundle.getString("metadata.author"));
        }
        if (metadata.getCreator() == null) {
            metadata.setCreator(bundle.getString("metadata.creator") + " " + this.getVersion());
        }
        if (metadata.getDescription() == null) {
            metadata.setDescription(bundle.getString("metadata.description"));
        }
        if (metadata.getTitle() == null) {
            metadata.setTitle(bundle.getString("metadata.title"));
        }
        if (metadata.getKeywords() == null) {
            metadata.setKeywords(bundle.getString("metadata.keywords"));
        }
        metadata.setCreationDate(pModel.getCreationTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaConformityReport layout(ValidateResponse validateResponse, OutputStream out) throws LayoutException {
        block29: {
            if (validateResponse == null) {
                throw new LayoutException("Empty validation result");
            }
            Map additionalConfig = this.getAdditionalSettings();
            if (!additionalConfig.containsKey(FOPConfigurationConstants.PDF_UA_MODE.getKey())) {
                additionalConfig.put(FOPConfigurationConstants.PDF_UA_MODE.getKey(), FOPConfigurationConstants.PDF_UA_MODE.getDefault());
            }
            TempDataManagerImpl tempDataManager = null;
            try {
                tempDataManager = new TempDataManagerImpl(VelocityHelperFO.createUUID());
                File tempFOFile = tempDataManager.createTempFile("", ".fo");
                try (FileOutputStream foStream = new FileOutputStream(tempFOFile);){
                    super.layout(validateResponse, (OutputStream)foStream);
                }
                catch (IOException io_ex) {
                    throw new LayoutException("Cannot create XSL-FO file at '" + tempFOFile + "'!", (Throwable)io_ex);
                }
                catch (LayoutException ex) {
                    if (ex.getCause() != null && ex.getCause() instanceof IOException) {
                        throw new LayoutException("Cannot create XSL-FO file at '" + tempFOFile + "'!", (Throwable)ex);
                    }
                    throw new LayoutException("Cannot render XSL-FO file to '" + tempFOFile + "' using template file '" + this.getTemplateFilePath() + "'!", (Throwable)ex);
                }
                if (tempFOFile.exists() && tempFOFile.length() > 0L) {
                    Instant start = null;
                    try {
                        if (CslTimingUtil.isTimingDebuggingEnabled()) {
                            start = Instant.now();
                        }
                        FOPRenderer fopRenderer = FOPRendererFactory.newInstance("/conf/fop_conf.xml");
                        fopRenderer.setPDFUAMode((PDFUAMode)this.getAdditionalSettings().getOrDefault(FOPConfigurationConstants.PDF_UA_MODE.getKey(), FOPConfigurationConstants.PDF_UA_MODE.getDefault()));
                        fopRenderer.render(new StreamSource(new FileInputStream(tempFOFile)), out);
                        if (CslTimingUtil.isTimingDebuggingEnabled() && start != null) {
                            LOGGER.debug("Creating PDF file for {} took {}", (Object)this.objName, (Object)Duration.between(start, Instant.now()));
                        }
                        break block29;
                    }
                    catch (IOException io_ex) {
                        throw new LayoutException("Cannot render PDF using XSL-FO template file '" + tempFOFile + "'!", (Throwable)io_ex);
                    }
                }
                throw new LayoutException("Cannot render PDF using missing or empty XSL-FO template file '" + tempFOFile + "'!");
            }
            finally {
                if (tempDataManager != null) {
                    tempDataManager.cleanUp();
                }
            }
        }
        if (this.isSchemaValidationEnabled()) {
            return new SchemaConformityReport(MajorTotalResult.INDETERMINATE, "This output plugin does not support schema validation");
        }
        return new SchemaConformityReport(MajorTotalResult.NOT_VALIDATED);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getVersion() {
        try (InputStream is = InspectionSheetPDF.class.getResourceAsStream("/csl_inspect_fo.version");){
            Properties versionProps = new Properties();
            versionProps.load(is);
            String string = versionProps.getProperty("componentVersion");
            return string;
        }
        catch (Throwable thr) {
            return "<UNKNOWN>";
        }
    }
}

