/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.AttributeCertificate;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CryptoProviderUtil {
    public static final String DEFAULT_ID_PREFIX = "id";
    private static final Logger LOG = LoggerFactory.getLogger(CryptoProviderUtil.class);
    public static String PROVIDER = "BC";

    private CryptoProviderUtil() {
    }

    public static Signature getSignatureInstance(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        return Signature.getInstance(algorithm, PROVIDER);
    }

    public static MessageDigest getMessageDigestInstance(String algorithmName) throws NoSuchAlgorithmException, NoSuchProviderException {
        return MessageDigest.getInstance(algorithmName, PROVIDER);
    }

    public static CertificateFactory getCertificateFactoryInstance(String type) throws CertificateException, NoSuchProviderException {
        return CertificateFactory.getInstance(type, PROVIDER);
    }

    public static CertStore createCertStore(Collection<? extends Certificate> trustedCerts) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        CollectionCertStoreParameters certStoreParameters = new CollectionCertStoreParameters(trustedCerts);
        CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)certStoreParameters, PROVIDER);
        return certStore;
    }

    public static KeyStore createKeyStore(String type) throws KeyStoreException, NoSuchProviderException {
        KeyStore keyStore = KeyStore.getInstance(type, PROVIDER);
        return keyStore;
    }

    public static KeyStore createKeyStore() throws KeyStoreException, NoSuchProviderException {
        return CryptoProviderUtil.createKeyStore("PKCS12");
    }

    public static X509Certificate loadCert(String file) throws IOException, CertificateException, NoSuchProviderException {
        try (InputStream is = CryptoProviderUtil.class.getClassLoader().getResourceAsStream(file);){
            X509Certificate x509Certificate = CryptoProviderUtil.loadCert(is);
            return x509Certificate;
        }
    }

    public static X509Certificate loadCert(InputStream stream) throws IOException, CertificateException, NoSuchProviderException {
        CertificateFactory certificateFactoryInstance = CryptoProviderUtil.getCertificateFactoryInstance("X509");
        X509Certificate cert = (X509Certificate)certificateFactoryInstance.generateCertificate(stream);
        return cert;
    }

    public static X509Certificate loadCert(byte[] cert) throws IOException, CertificateException, NoSuchProviderException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(cert);){
            X509Certificate x509Certificate = CryptoProviderUtil.loadCert(is);
            return x509Certificate;
        }
    }

    public static AttributeCertificate loadAttributeCertificate(InputStream stream) throws IOException {
        AttributeCertificate cert = null;
        try (ASN1InputStream asn1Stream = new ASN1InputStream(stream, 524288);){
            ASN1Primitive primitive = asn1Stream.readObject();
            cert = AttributeCertificate.getInstance((Object)primitive);
        }
        return cert;
    }

    public static AttributeCertificate loadAttributeCertificate(byte[] attributeCert) throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(attributeCert);){
            AttributeCertificate attributeCertificate = CryptoProviderUtil.loadAttributeCertificate(is);
            return attributeCertificate;
        }
    }

    public static boolean registerBouncyCastleIfNotAvailable() {
        boolean added = false;
        Provider provider = Security.getProvider("BC");
        if (provider == null) {
            provider = new BouncyCastleProvider();
            Security.addProvider(provider);
            LOG.trace("Add {}", (Object)provider.getInfo());
        }
        LOG.info("Registered JCE provider: {}", (Object)provider.getInfo());
        return added;
    }

    public static String createID(Certificate certificate) {
        if (certificate instanceof X509Certificate) {
            return CryptoProviderUtil.createID((X509Certificate)certificate);
        }
        return "";
    }

    public static String createID(X509Certificate certificate) {
        return CryptoProviderUtil.createID(certificate.getIssuerX500Principal(), certificate.getSerialNumber());
    }

    public static String createID(X500Principal x500Principal, BigInteger serialNumber) {
        return CryptoProviderUtil.createID(x500Principal.getName("RFC2253"), serialNumber);
    }

    public static String createID(String name, BigInteger serialNumber) {
        return "id_" + CryptoProviderUtil.createBase64(CryptoProviderUtil.createSHA256("name=" + name + ";serialNumber=" + serialNumber)).replaceAll(Pattern.quote("+"), "-").replaceAll(Pattern.quote("/"), "_").replaceAll(Pattern.quote("="), "~");
    }

    public static byte[] createSHA256(String string) {
        if (string == null || string.isEmpty()) {
            return new byte[0];
        }
        try {
            return MessageDigest.getInstance("SHA256").digest(string.getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException e) {
            return string.getBytes(StandardCharsets.UTF_8);
        }
    }

    public static String createBase64(byte[] data) {
        return Base64.getEncoder().encodeToString(data);
    }
}

