/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class ClassUtils {
    private static final Set<Class<?>> EMPTY_SET = Collections.emptySet();

    private ClassUtils() {
    }

    public static <T> Set<Class<? extends T>> findImplementingInterfaces(Class<?> searchClass, Class<T> typeClass) {
        return ClassUtils.findImplementingInterfaces(searchClass, typeClass, EMPTY_SET);
    }

    public static <T> Set<Class<? extends T>> findImplementingInterfaces(Class<?> searchClass, Class<T> typeClass, Class<?> ignoreClass) {
        return ClassUtils.findImplementingInterfaces(searchClass, typeClass, Collections.singleton(ignoreClass));
    }

    public static <T> Set<Class<? extends T>> findImplementingInterfaces(Class<?> searchClass, Class<T> typeClass, Set<Class<?>> ignoredClasses) {
        HashSet<Class<T>> result = new HashSet<Class<T>>();
        if (searchClass == null) {
            throw new IllegalArgumentException("class to find interfaces for can not be null");
        }
        if (typeClass == null) {
            throw new IllegalArgumentException("type class can not be null");
        }
        Set<Class<?>> lIgnoredClasses = ignoredClasses == null ? EMPTY_SET : ignoredClasses;
        Set<Class<? extends Object>> interfaceClasses = ClassUtils.findInterfaces(searchClass);
        for (Class<? extends Object> interfaceClass : interfaceClasses) {
            if (!Arrays.asList(interfaceClass.getInterfaces()).contains(typeClass)) continue;
            result.add(interfaceClass);
        }
        result.removeAll(lIgnoredClasses);
        return result;
    }

    public static Set<Class<? extends Object>> findInterfaces(Class<?> searchClass) {
        HashSet<Class<? extends Object>> result = new HashSet<Class<? extends Object>>();
        if (searchClass == null) {
            return result;
        }
        if (Object.class.equals(searchClass)) {
            return result;
        }
        if (searchClass.isInterface()) {
            result.add(searchClass);
        }
        for (Class<?> interfaceClass : searchClass.getInterfaces()) {
            result.add(interfaceClass);
            Set<Class<? extends Object>> subInterfaces = ClassUtils.findInterfaces(interfaceClass);
            if (subInterfaces.isEmpty()) continue;
            result.addAll(subInterfaces);
        }
        Set<Class<? extends Object>> subInterfaces = ClassUtils.findInterfaces(searchClass.getSuperclass());
        if (!subInterfaces.isEmpty()) {
            result.addAll(subInterfaces);
        }
        return result;
    }
}

