/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.types;

import de.governikus.csl.uom.types.CertificateList;
import de.governikus.csl.uom.types.CertificateListType;
import de.governikus.csl.uom.types.KeyValue;
import de.governikus.csl.uom.types.KeyValueType;
import de.governikus.csl.uom.types.ProxyConfiguration;
import de.governikus.csl.uom.types.ProxyConfigurationType;
import de.governikus.csl.uom.types.TransportConfiguration;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="TransportConfigurationType", propOrder={"proxyConfiguration", "trustedServerCerts", "acceptAllSSLServerCertificates", "clientServerAuthorizationKey", "connectionManagerTimeout", "connectionTimeout", "socketTimeout", "maxConnectionsPerHost", "signRequestKey", "signedResponseTrustedCerts"})
public class TransportConfigurationType
implements TransportConfiguration {
    @XmlElement(name="proxyConfiguration")
    private ProxyConfigurationType proxyConfiguration;
    @XmlElement(name="trustedServerCerts")
    private CertificateListType trustedServerCerts;
    @XmlElement(name="acceptAllSSLServerCertificates")
    private boolean acceptAllSSLServerCertificates;
    @XmlElement(name="clientServerAuthorizationKey")
    private KeyValueType clientServerAuthorizationKey;
    @XmlElement(name="connectionManagerTimeout")
    private long connectionManagerTimeout = 60000L;
    @XmlElement(name="connectionTimeout")
    private long connectionTimeout = 15000L;
    @XmlElement(name="socketTimeout")
    private long socketTimeout = 30000L;
    @XmlElement(name="maxConnectionsPerHost")
    private int maxConnectionsPerHost = 2;
    @XmlElement(name="signRequestKey")
    private KeyValueType signRequestKey;
    @XmlElement(name="signedResponseTrustedCerts")
    private CertificateListType signedResponseTrustedCerts;

    public TransportConfigurationType() {
        this.proxyConfiguration = new ProxyConfigurationType();
        this.trustedServerCerts = new CertificateListType();
    }

    public TransportConfigurationType(ProxyConfigurationType proxyConfiguration) {
        this.proxyConfiguration = proxyConfiguration;
        this.trustedServerCerts = new CertificateListType();
    }

    public TransportConfigurationType(String proxyHost, int proxyPort) {
        this(proxyHost, proxyPort, null, null);
    }

    public TransportConfigurationType(String proxyHost, int proxyPort, String proxyUser, String proxyPass) {
        this(proxyHost, proxyPort, proxyUser, proxyPass, null);
    }

    public TransportConfigurationType(String proxyHost, int proxyPort, String proxyUser, String proxyPass, List<String> noProxyHosts) {
        this.proxyConfiguration = new ProxyConfigurationType(proxyHost, proxyPort, proxyUser, proxyPass, noProxyHosts == null ? new ArrayList() : noProxyHosts);
        this.trustedServerCerts = new CertificateListType();
    }

    @Override
    public KeyValue getClientServerAuthorizationKey() {
        return this.clientServerAuthorizationKey;
    }

    @Override
    public long getConnectionManagerTimeout() {
        return this.connectionManagerTimeout;
    }

    @Override
    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public int getMaxConnectionsPerHost() {
        return this.maxConnectionsPerHost;
    }

    @Override
    public ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfiguration;
    }

    @Override
    public long getSocketTimeout() {
        return this.socketTimeout;
    }

    @Override
    public CertificateList getTrustedServerCerts() {
        return this.trustedServerCerts;
    }

    @Override
    public boolean isAcceptAllSSLServerCertificates() {
        return this.acceptAllSSLServerCertificates;
    }

    @Override
    public void setAcceptAllSSLServerCertificates(boolean acceptAllSSLServerCertificates) {
        this.acceptAllSSLServerCertificates = acceptAllSSLServerCertificates;
    }

    @Override
    public void setClientServerAuthorizationKey(KeyValueType clientServerAuthorizationKey) {
        this.clientServerAuthorizationKey = clientServerAuthorizationKey;
    }

    @Override
    public void setConnectionManagerTimeout(long connectionManagerTimeout) {
        this.connectionManagerTimeout = connectionManagerTimeout;
    }

    @Override
    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Override
    public void setMaxConnectionsPerHost(int maxConnectionsPerHost) {
        this.maxConnectionsPerHost = maxConnectionsPerHost;
    }

    @Override
    public void setProxyConfiguration(ProxyConfigurationType proxyConfiguration) {
        this.proxyConfiguration = proxyConfiguration;
    }

    @Override
    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    @Override
    public void setTrustedServerCerts(CertificateListType trustedServerCerts) {
        this.trustedServerCerts = trustedServerCerts;
    }

    @Override
    public CertificateList getSignedResponseTrustedCerts() {
        return this.signedResponseTrustedCerts;
    }

    @Override
    public void setSignedResponseTrustedCerts(CertificateListType signedResponseTrustedCerts) {
        this.signedResponseTrustedCerts = signedResponseTrustedCerts;
    }

    @Override
    public KeyValue getSignRequestKey() {
        return this.signRequestKey;
    }

    @Override
    public void setSignRequestKey(KeyValueType signRequestKey) {
        this.signRequestKey = signRequestKey;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.acceptAllSSLServerCertificates ? 1231 : 1237);
        result = 31 * result + (this.clientServerAuthorizationKey == null ? 0 : this.clientServerAuthorizationKey.hashCode());
        result = 31 * result + (int)(this.connectionManagerTimeout ^ this.connectionManagerTimeout >>> 32);
        result = 31 * result + (int)(this.connectionTimeout ^ this.connectionTimeout >>> 32);
        result = 31 * result + this.maxConnectionsPerHost;
        result = 31 * result + (this.proxyConfiguration == null ? 0 : this.proxyConfiguration.hashCode());
        result = 31 * result + (this.signRequestKey == null ? 0 : this.signRequestKey.hashCode());
        result = 31 * result + (this.signedResponseTrustedCerts == null ? 0 : this.signedResponseTrustedCerts.hashCode());
        result = 31 * result + (int)(this.socketTimeout ^ this.socketTimeout >>> 32);
        result = 31 * result + (this.trustedServerCerts == null ? 0 : this.trustedServerCerts.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        TransportConfigurationType other = (TransportConfigurationType)obj;
        if (this.acceptAllSSLServerCertificates != other.acceptAllSSLServerCertificates) {
            return false;
        }
        if (this.clientServerAuthorizationKey == null ? other.clientServerAuthorizationKey != null : !this.clientServerAuthorizationKey.equals(other.clientServerAuthorizationKey)) {
            return false;
        }
        if (this.connectionManagerTimeout != other.connectionManagerTimeout) {
            return false;
        }
        if (this.connectionTimeout != other.connectionTimeout) {
            return false;
        }
        if (this.maxConnectionsPerHost != other.maxConnectionsPerHost) {
            return false;
        }
        if (this.proxyConfiguration == null ? other.proxyConfiguration != null : !this.proxyConfiguration.equals(other.proxyConfiguration)) {
            return false;
        }
        if (this.signRequestKey == null ? other.signRequestKey != null : !this.signRequestKey.equals(other.signRequestKey)) {
            return false;
        }
        if (this.signedResponseTrustedCerts == null ? other.signedResponseTrustedCerts != null : !this.signedResponseTrustedCerts.equals(other.signedResponseTrustedCerts)) {
            return false;
        }
        if (this.socketTimeout != other.socketTimeout) {
            return false;
        }
        return !(this.trustedServerCerts == null ? other.trustedServerCerts != null : !this.trustedServerCerts.equals(other.trustedServerCerts));
    }
}

