/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.types;

import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public interface RecommendedProviders {
    public static final List<String> RECOMMENDED_PROVIDER_NAMES = Collections.unmodifiableList(Arrays.asList("CPP", "BC"));

    default public String recommendedProvider() {
        List<String> possibleRecommendedProviders = this.recommendedRegisteredProviders();
        if (possibleRecommendedProviders == null || possibleRecommendedProviders.isEmpty()) {
            return null;
        }
        return possibleRecommendedProviders.iterator().next();
    }

    default public List<String> recommendedRegisteredProviders() {
        ArrayList<String> result = new ArrayList<String>();
        for (String providerName : RECOMMENDED_PROVIDER_NAMES) {
            if (Security.getProvider(providerName) == null) continue;
            result.add(providerName);
        }
        return result;
    }
}

