/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.types;

import de.governikus.csl.uom.types.ProxyConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ProxyConfigurationType
implements ProxyConfiguration {
    private List<String> nonProxyHosts;
    private String proxyHost;
    private int proxyPort;
    private String username;
    private String password;
    private boolean ldapProxy;
    private boolean noCacheHeader;

    public ProxyConfigurationType(String proxyHost, int port) {
        this.proxyHost = proxyHost;
        this.proxyPort = port;
        this.nonProxyHosts = new ArrayList<String>();
    }

    public ProxyConfigurationType(String proxyHost, int port, String ... bypassedHosts) {
        this.proxyHost = proxyHost;
        this.proxyPort = port;
        this.nonProxyHosts = bypassedHosts != null && bypassedHosts.length > 0 ? Arrays.asList(bypassedHosts) : new ArrayList<String>();
    }

    public ProxyConfigurationType(String proxyHost, int port, List<String> nonProxyHosts) {
        this.proxyHost = proxyHost;
        this.proxyPort = port;
        this.nonProxyHosts = nonProxyHosts != null && nonProxyHosts.isEmpty() ? nonProxyHosts : new ArrayList<String>();
    }

    public ProxyConfigurationType() {
        this.nonProxyHosts = new ArrayList<String>();
    }

    public ProxyConfigurationType(String proxyHost, int proxyPort, String proxyUser, String proxyPass, List<String> nonProxyHosts) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.username = proxyUser;
        this.password = proxyPass;
        this.nonProxyHosts = nonProxyHosts != null && !nonProxyHosts.isEmpty() ? nonProxyHosts : new ArrayList<String>();
    }

    @Override
    public List<String> getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    @Override
    public String getProxyHost() {
        return this.proxyHost;
    }

    @Override
    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    @Override
    public int getProxyPort() {
        return this.proxyPort;
    }

    @Override
    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public boolean isLDAPProxy() {
        return this.ldapProxy;
    }

    @Override
    public void setLDAPProxy(boolean ldapProxy) {
        this.ldapProxy = ldapProxy;
    }

    @Override
    public boolean isNoCacheHeader() {
        return this.noCacheHeader;
    }

    @Override
    public void setNoCacheHeader(boolean noCacheHeader) {
        this.noCacheHeader = noCacheHeader;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ldapProxy ? 1231 : 1237);
        result = 31 * result + (this.noCacheHeader ? 1231 : 1237);
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.nonProxyHosts == null ? 0 : this.nonProxyHosts.hashCode());
        result = 31 * result + (this.proxyHost == null ? 0 : this.proxyHost.hashCode());
        result = 31 * result + this.proxyPort;
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        ProxyConfigurationType other = (ProxyConfigurationType)obj;
        if (this.ldapProxy != other.ldapProxy) {
            return false;
        }
        if (this.noCacheHeader != other.noCacheHeader) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.nonProxyHosts == null ? other.nonProxyHosts != null : !this.nonProxyHosts.equals(other.nonProxyHosts)) {
            return false;
        }
        if (this.proxyHost == null ? other.proxyHost != null : !this.proxyHost.equals(other.proxyHost)) {
            return false;
        }
        if (this.proxyPort != other.proxyPort) {
            return false;
        }
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }

    @Override
    public void setNonProxyHosts(List<String> nonProxyHosts) {
        this.nonProxyHosts = nonProxyHosts;
    }
}

