/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.types;

import de.governikus.csl.uom.types.KeyStoreValueType;
import de.governikus.csl.uom.types.KeyValue;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="KeyValueType", propOrder={"alias", "keyPassword"})
public class KeyValueType
extends KeyStoreValueType
implements KeyValue {
    private transient Key cache;
    @XmlElement(name="alias", required=true)
    private String alias;
    @XmlElement(name="keyPassword", required=false)
    private String keyPassword;

    public KeyValueType() {
    }

    public KeyValueType(byte[] value, String keystoreType, String providerName, String keystorePassword, String alias, String keyPassword) {
        super(value, keystoreType, providerName, keystorePassword);
        this.setAlias(alias);
        this.setKeyPassword(keyPassword);
    }

    public KeyValueType(KeyStore value, String keystorePassword, String alias, String keyPassword) throws IOException {
        super(value, keystorePassword);
        this.setAlias(alias);
        this.setKeyPassword(keyPassword);
        this.cache = this.key();
    }

    public KeyValueType(KeyValue copy) {
        super(copy);
        this.setAlias(copy.getAlias());
        this.setKeyPassword(copy.getKeyPassword());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        KeyValueType other = (KeyValueType)obj;
        if (this.alias == null ? other.alias != null : !this.alias.equals(other.alias)) {
            return false;
        }
        return !(this.keyPassword == null ? other.keyPassword != null : !this.keyPassword.equals(other.keyPassword));
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public String getKeyPassword() {
        return this.keyPassword;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.alias == null ? 0 : this.alias.hashCode());
        result = 31 * result + (this.keyPassword == null ? 0 : this.keyPassword.hashCode());
        return result;
    }

    @Override
    public void setAlias(String alias) {
        this.alias = alias;
        this.cache = null;
    }

    @Override
    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
        this.cache = null;
    }

    @Override
    public Key key() {
        if (this.cache == null) {
            this.cache = KeyValue.super.key();
        }
        return this.cache;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[providerName=" + this.providerName + ", keystorePath=" + this.keystorePath + ", value=" + this.value + ", keyStoreType=" + this.keystoreType + ", keystorePassword=" + this.keystorePassword + ", alias=" + this.alias + ", keyPassword=" + this.keyPassword + "]";
    }

    @Override
    public void fromObject(KeyStore value) throws IOException {
        try {
            super.fromObject(value);
        }
        finally {
            this.cache = null;
        }
    }

    @Override
    public void setValue(byte[] value) {
        try {
            super.setValue(value);
        }
        finally {
            this.cache = null;
        }
    }
}

