/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.types;

import de.governikus.csl.uom.types.KeyStoreValue;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;

public interface KeyValue
extends KeyStoreValue {
    public String getAlias();

    public String getKeyPassword();

    default public Key key() {
        String alias = this.getAlias();
        if (alias == null || alias.isEmpty()) {
            return null;
        }
        String keyPassword = this.getKeyPassword();
        try {
            return this.toObject().getKey(alias, keyPassword == null ? null : keyPassword.toCharArray());
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException generalSecurityException) {
            return null;
        }
    }

    @Override
    default public void fromObject(KeyStore value) throws IOException {
        try {
            KeyStoreValue.super.fromObject(value);
        }
        finally {
            if (value == null) {
                this.setAlias(null);
                this.setKeyPassword(null);
            }
        }
    }

    public void setAlias(String var1);

    public void setKeyPassword(String var1);

    default public Certificate certificate() {
        String alias = this.getAlias();
        if (alias == null || alias.isEmpty()) {
            return null;
        }
        KeyStore keyStore = this.keyStore();
        if (keyStore == null) {
            return null;
        }
        try {
            return keyStore.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            return null;
        }
    }

    default public Certificate[] certificateChain() {
        String alias = this.getAlias();
        if (alias == null || alias.isEmpty()) {
            return new Certificate[0];
        }
        KeyStore keyStore = this.keyStore();
        if (keyStore == null) {
            return new Certificate[0];
        }
        try {
            return keyStore.getCertificateChain(alias);
        }
        catch (KeyStoreException e) {
            return new Certificate[0];
        }
    }
}

