/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.types;

import de.governikus.csl.uom.types.AbstractByteArrayValueType;
import de.governikus.csl.uom.types.KeyStoreValue;
import java.io.IOException;
import java.security.KeyStore;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="KeyStoreValueType", propOrder={"providerName", "keystoreType", "keystorePath", "keystorePassword"})
public class KeyStoreValueType
extends AbstractByteArrayValueType<KeyStore, KeyStoreValue>
implements KeyStoreValue {
    @XmlElement(name="keystorePassword", required=true)
    protected String keystorePassword;
    @XmlElement(name="keystorePath", required=false)
    protected String keystorePath;
    @XmlElement(name="keystoreType", required=false)
    protected String keystoreType;
    @XmlElement(name="providerName", required=false)
    protected String providerName;
    private transient KeyStore cache;

    public KeyStoreValueType() {
    }

    public KeyStoreValueType(byte[] value, String keystoreType, String providerName, String keystorePassword) {
        super(value);
        this.setKeystoreType(keystoreType);
        this.setProviderName(providerName);
        this.setKeystorePassword(keystorePassword);
    }

    public KeyStoreValueType(KeyStore value, String keyStorePassword) throws IOException {
        this.setProviderName(Objects.requireNonNull(value).getProvider().getName());
        this.setKeystoreType(value.getType());
        this.setKeystorePassword(keyStorePassword);
        try {
            this.fromObject(value);
        }
        finally {
            this.cache = value;
            this.keystoreType = this.cache.getType();
            this.providerName = this.cache.getProvider().getName();
        }
    }

    public KeyStoreValueType(KeyStoreValue copy) {
        super(copy);
        if (copy != null) {
            this.setKeystoreType(copy.getKeystoreType());
            this.setKeystorePath(copy.getKeystorePath());
            this.setKeystorePassword(copy.getKeystorePassword());
            this.setProviderName(copy.getProviderName());
        }
        this.cache = copy.keyStore();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        KeyStoreValueType other = (KeyStoreValueType)obj;
        if (this.keystoreType == null ? other.keystoreType != null : !this.keystoreType.equals(other.keystoreType)) {
            return false;
        }
        if (this.keystorePassword == null ? other.keystorePassword != null : !this.keystorePassword.equals(other.keystorePassword)) {
            return false;
        }
        if (this.keystorePath == null ? other.keystorePath != null : !this.keystorePath.equals(other.keystorePath)) {
            return false;
        }
        return !(this.providerName == null ? other.providerName != null : !this.providerName.equals(other.providerName));
    }

    @Override
    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    @Override
    public String getKeystorePath() {
        return this.keystorePath;
    }

    @Override
    public String getKeystoreType() {
        return this.keystoreType;
    }

    @Override
    public String getProviderName() {
        return this.providerName;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.keystoreType == null ? 0 : this.keystoreType.hashCode());
        result = 31 * result + (this.keystorePassword == null ? 0 : this.keystorePassword.hashCode());
        result = 31 * result + (this.keystorePath == null ? 0 : this.keystorePath.hashCode());
        result = 31 * result + (this.providerName == null ? 0 : this.providerName.hashCode());
        return result;
    }

    @Override
    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    @Override
    public void setKeystorePath(String keystorePath) {
        this.keystorePath = keystorePath;
    }

    @Override
    public void setKeystoreType(String keyStoreType) {
        this.keystoreType = keyStoreType;
    }

    @Override
    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[providerName=" + this.providerName + ", keystorePath=" + this.keystorePath + ", value=" + this.value + ", keyStoreType=" + this.keystoreType + ", keystorePassword=" + this.keystorePassword + "]";
    }

    @Override
    public void fromObject(KeyStore value) throws IOException {
        try {
            KeyStoreValue.super.fromObject(value);
        }
        finally {
            this.cache = value;
        }
    }

    @Override
    public KeyStore toObject() {
        if (this.cache == null) {
            this.cache = KeyStoreValue.super.toObject();
            if (this.cache != null) {
                this.keystoreType = this.cache.getType();
                this.providerName = this.cache.getProvider().getName();
            }
        }
        return this.cache;
    }

    @Override
    public void setValue(byte[] value) {
        try {
            super.setValue(value);
        }
        finally {
            this.cache = null;
        }
    }
}

