/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.types;

import de.governikus.csl.uom.types.ByteArrayValue;
import de.governikus.csl.uom.types.CertificateValue;
import de.governikus.csl.uom.types.RecommendedProviders;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;

public interface KeyStoreValue
extends ByteArrayValue<KeyStore>,
RecommendedProviders {
    public static final String ORACLE_KEYSTORE_TYPE = "JKS";

    public String getProviderName();

    public void setProviderName(String var1);

    public String getKeystoreType();

    public String getKeystorePath();

    public String getKeystorePassword();

    default public KeyStore keyStore() {
        return this.toObject();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    default public KeyStore toObject() {
        try (InputStream stream = this.keyStoreStream();){
            if (stream == null) {
                KeyStore keyStore = null;
                return keyStore;
            }
            String keystoreType = this.getKeystoreType();
            if (keystoreType == null || keystoreType.isEmpty()) {
                KeyStore keyStore = null;
                return keyStore;
            }
            String providerName = this.getProviderName();
            KeyStore keystore = null;
            if (providerName != null && !providerName.isEmpty()) {
                keystore = KeyStore.getInstance(keystoreType, providerName);
            } else {
                String recommendedProviderName = this.recommendedProvider();
                keystore = ORACLE_KEYSTORE_TYPE.equals(keystoreType) ? KeyStore.getInstance(keystoreType) : KeyStore.getInstance(keystoreType, recommendedProviderName);
            }
            keystore.load(stream, this.getKeystorePassword().toCharArray());
            KeyStore keyStore = keystore;
            return keyStore;
        }
        catch (IOException | IllegalStateException | URISyntaxException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException exception) {
            return null;
        }
    }

    @Override
    default public void fromObject(KeyStore value) throws IOException {
        if (value == null) {
            this.setKeystorePassword(null);
            this.setKeystorePath(null);
            this.setKeystoreType(null);
            this.setProviderName(null);
            this.setValue(null);
            return;
        }
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            String keystorePassword = this.getKeystorePassword();
            try {
                value.store(stream, keystorePassword == null ? null : keystorePassword.toCharArray());
                this.setValue(stream.toByteArray());
            }
            catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new IOException(e);
            }
        }
    }

    default public URL keystorePathURL() throws URISyntaxException, MalformedURLException {
        String keystorePath = this.getKeystorePath();
        byte[] keystore = this.getValue();
        URL url = null;
        if (!(keystore != null && keystore.length != 0 || keystorePath == null || keystorePath.isEmpty())) {
            url = this.getClass().getResource(keystorePath);
            if (url == null) {
                url = CertificateValue.class.getResource("/" + keystorePath);
            }
            if (url == null && keystorePath.contains("/")) {
                File file;
                String kp = keystorePath;
                if (!kp.startsWith("file:/")) {
                    kp = "file:/" + kp;
                }
                if ((file = new File(new URI(kp))).exists() && file.isFile()) {
                    url = file.toURI().toURL();
                }
            }
        }
        return url;
    }

    default public void replacePathWithBytes(boolean clearKeyStorePath) throws IOException {
        KeyStore keyStore = this.keyStore();
        this.fromObject(keyStore);
        if (clearKeyStorePath) {
            this.setKeystorePath(null);
        }
    }

    default public InputStream keyStoreStream() throws IOException, URISyntaxException, MalformedURLException {
        byte[] keystore = this.getValue();
        InputStream stream = null;
        URL keystorePathURL = this.keystorePathURL();
        if (keystore != null && keystore.length > 0) {
            stream = new ByteArrayInputStream(keystore);
        } else if (keystorePathURL != null) {
            stream = keystorePathURL.openStream();
        }
        return stream;
    }

    public void setKeystorePath(String var1);

    public void setKeystoreType(String var1);

    public void setKeystorePassword(String var1);
}

