/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.types;

import de.governikus.csl.uom.types.AbstractByteArrayValueType;
import de.governikus.csl.uom.types.CertificateValue;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="CertificateValueType", propOrder={"type", "providerName", "certificatePath"})
public class CertificateValueType
extends AbstractByteArrayValueType<Certificate, CertificateValue>
implements CertificateValue {
    @XmlElement(name="type", defaultValue="X.509")
    private String type = "X.509";
    @XmlElement(name="providerName", required=false)
    protected String providerName;
    @XmlElement(name="certificatePath", required=false)
    protected String certificatePath;
    private transient Certificate cache = null;

    public CertificateValueType() {
    }

    public CertificateValueType(byte[] value) {
        super(value);
        if (this.toObject() == null) {
            throw new IllegalArgumentException("value does not represent a decodable certificate");
        }
    }

    public CertificateValueType(Certificate value) throws IOException {
        try {
            this.fromObject(value);
        }
        finally {
            this.cache = value;
        }
    }

    public CertificateValueType(CertificateValue copy) throws IOException {
        super(copy);
        this.type = copy == null ? null : copy.getType();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        CertificateValueType other = (CertificateValueType)obj;
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        if (this.certificatePath == null ? other.certificatePath != null : !this.certificatePath.equals(other.certificatePath)) {
            return false;
        }
        return !(this.providerName == null ? other.providerName != null : !this.providerName.equals(other.providerName));
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.certificatePath == null ? 0 : this.certificatePath.hashCode());
        result = 31 * result + (this.providerName == null ? 0 : this.providerName.hashCode());
        return result;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String toString() {
        Certificate value = this.toObject();
        StringBuilder certName = new StringBuilder();
        if (value != null) {
            certName.append("type: " + value.getType());
            if (value instanceof X509Certificate) {
                X509Certificate x509 = (X509Certificate)value;
                certName.append(", issuer: ");
                certName.append(x509.getIssuerX500Principal().toString());
                certName.append(", serial: ");
                certName.append(x509.getSerialNumber());
            } else {
                certName.append(", value: " + value);
            }
        } else {
            certName.append("misconfiguration, no certificate retrieved");
        }
        return this.getClass().getSimpleName() + "[providerName=" + this.providerName + ", certificatePath=" + this.certificatePath + ", type=" + this.type + ", value=" + this.value + ", " + certName + "]";
    }

    @Override
    public void fromObject(Certificate value) throws IOException {
        try {
            CertificateValue.super.fromObject(value);
        }
        finally {
            this.cache = value;
        }
    }

    @Override
    public Certificate toObject() {
        if (this.cache == null) {
            this.cache = CertificateValue.super.toObject();
            if (this.cache != null) {
                this.type = this.cache.getType();
            }
        }
        return this.cache;
    }

    @Override
    public void setValue(byte[] value) {
        try {
            super.setValue(value);
        }
        finally {
            this.cache = null;
        }
    }

    @Override
    public String getProviderName() {
        return this.providerName;
    }

    @Override
    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    @Override
    public String getCertificatePath() {
        return this.certificatePath;
    }

    @Override
    public void setCertificatePath(String certificatePath) {
        this.certificatePath = certificatePath;
    }
}

