/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.types;

import de.governikus.csl.uom.types.ByteArrayValue;
import de.governikus.csl.uom.types.RecommendedProviders;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;

public interface CertificateValue
extends ByteArrayValue<Certificate>,
RecommendedProviders {
    @Override
    default public void fromObject(Certificate value) throws IOException {
        if (value == null) {
            this.setType(null);
            this.setValue(null);
            return;
        }
        try {
            this.setType(value.getType());
            this.setValue(value.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new IOException(e);
        }
    }

    public String getProviderName();

    public void setProviderName(String var1);

    public String getType();

    public void setType(String var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    default public Certificate toObject() {
        try (InputStream stream = this.certificateStream();){
            String recommendedProviderName;
            if (stream == null) {
                Certificate certificate2 = null;
                return certificate2;
            }
            String type = this.getType();
            if (type == null || type.isEmpty()) {
                type = "X.509";
            }
            String providerName = this.getProviderName();
            CertificateFactory cf = null;
            cf = providerName != null && !providerName.isEmpty() ? CertificateFactory.getInstance(type, providerName) : ((recommendedProviderName = this.recommendedProvider()) == null || recommendedProviderName.isEmpty() ? CertificateFactory.getInstance(type) : CertificateFactory.getInstance(type, recommendedProviderName));
            Certificate certificate = cf.generateCertificate(stream);
            return certificate;
        }
        catch (IOException | URISyntaxException | NoSuchProviderException | CertificateException exception) {
            return null;
        }
    }

    default public Certificate certificate() {
        return this.toObject();
    }

    public String getCertificatePath();

    default public URL certificatePathURL() throws URISyntaxException, MalformedURLException {
        String certificatePath = this.getCertificatePath();
        byte[] certificate = this.getValue();
        URL url = null;
        if (!(certificate != null && certificate.length != 0 || certificatePath == null || certificatePath.isEmpty())) {
            url = this.getClass().getResource(certificatePath);
            if (url == null) {
                url = CertificateValue.class.getResource("/" + certificatePath);
            }
            if (url == null && certificatePath.contains("/")) {
                File file;
                String cp = certificatePath;
                if (!cp.startsWith("file:/")) {
                    cp = "file:/" + cp;
                }
                if ((file = new File(new URI(cp))).exists() && file.isFile()) {
                    url = file.toURI().toURL();
                }
            }
        }
        return url;
    }

    default public void replacePathWithBytes(boolean clearCertificatePath) throws IOException {
        Certificate certificate = this.certificate();
        this.fromObject(certificate);
        if (clearCertificatePath) {
            this.setCertificatePath(null);
        }
    }

    default public InputStream certificateStream() throws IOException, URISyntaxException, MalformedURLException {
        byte[] certificate = this.getValue();
        InputStream stream = null;
        URL certificatePathURL = this.certificatePathURL();
        if (certificate != null && certificate.length > 0) {
            stream = new ByteArrayInputStream(certificate);
        } else if (certificatePathURL != null) {
            stream = certificatePathURL.openStream();
        }
        return stream;
    }

    public void setCertificatePath(String var1);
}

