/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.types;

import de.governikus.csl.uom.types.SerializableValue;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public interface ByteArrayValue<T>
extends SerializableValue<T> {
    public static final String FINGERPRINT_JCE_DIGEST_ALGORITHM = "SHA1";

    public byte[] getValue();

    public void setValue(byte[] var1);

    default public byte[] getFingerprint() {
        try {
            byte[] v = this.getValue();
            if (v == null) {
                v = new byte[]{};
            }
            return MessageDigest.getInstance(FINGERPRINT_JCE_DIGEST_ALGORITHM).digest(v);
        }
        catch (NullPointerException | NoSuchAlgorithmException e) {
            return new byte[20];
        }
    }

    default public void setFingerprint(byte[] fingerprint) {
    }
}

