/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.res.impl;

import de.governikus.csl.uom.lock.LockState;
import de.governikus.csl.uom.res.LockableResourceState;
import de.governikus.csl.uom.res.ResourceFailedException;

public class SimpleLockableResourceState
implements LockableResourceState {
    public static final boolean DEFAULT_ENABLED = true;
    public static final LockState DEFAULT_STATE = LockState.NONE;
    public static final boolean DEFAULT_LOCKED = DEFAULT_STATE != LockState.NONE;
    private boolean enabled;
    private Object lock;
    private boolean locked;
    private LockState lockState;

    public SimpleLockableResourceState() {
        this(true, DEFAULT_STATE);
    }

    public SimpleLockableResourceState(boolean enabled, LockState lockState) {
        this.enabled = enabled;
        this.lockState = lockState == null ? DEFAULT_STATE : lockState;
        this.locked = this.lockState != LockState.NONE;
    }

    public SimpleLockableResourceState(boolean enabled) {
        this(enabled, DEFAULT_STATE);
    }

    public SimpleLockableResourceState(LockState lockState) {
        this(true, lockState);
    }

    private boolean checkLock(Object externalLock, boolean suppressException) {
        boolean valid;
        boolean bl = valid = this.lock == null || this.lock == externalLock;
        if (!valid && !suppressException) {
            throw new IllegalArgumentException("illegal lock");
        }
        return valid;
    }

    @Override
    public boolean isAbsent() {
        return false;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public synchronized boolean lock(Object lock, LockState newState) throws ResourceFailedException {
        LockState lNewState;
        LockState lockState = lNewState = newState == null ? LockState.NONE : newState;
        if (this.lockState == lNewState) {
            return false;
        }
        if (this.lockState.ordinal() > lNewState.ordinal()) {
            throw new IllegalStateException("can not lock to lower lock state, use unlock() to switch to lower lock state");
        }
        if (!this.checkLock(lock, true)) {
            throw new IllegalArgumentException("can not lock by another instance locked resource");
        }
        return this.updateState(lNewState, lock);
    }

    @Override
    public synchronized LockState getLockState() {
        return this.lockState;
    }

    @Override
    public synchronized boolean setEnabled(boolean enabled) {
        this.enabled = enabled;
        return true;
    }

    @Override
    public synchronized void setLockState(LockState lockState) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized boolean unlock(Object lock, LockState newState) {
        LockState lNewState;
        LockState lockState = lNewState = newState == null ? LockState.NONE : newState;
        if (this.lockState == lNewState) {
            return false;
        }
        if (this.lockState.ordinal() < lNewState.ordinal()) {
            throw new IllegalStateException("can not unlock to higher lock state, use lock() to switch to higher lock state");
        }
        this.checkLock(lock, false);
        return this.updateState(lNewState, lock);
    }

    private boolean updateState(LockState lNewState, Object lock) {
        this.lockState = lNewState;
        this.locked = LockState.NONE != this.lockState;
        this.lock = this.locked ? lock : null;
        return true;
    }
}

