/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.res.impl;

import de.governikus.csl.uom.res.AbstractKeyResourceReference;
import de.governikus.csl.uom.res.KeyFunctionSupportedAlgorithms;
import de.governikus.csl.uom.res.PublicKeyResourceReference;
import de.governikus.csl.uom.res.ResourceAreaType;
import de.governikus.csl.uom.res.ResourceComponentType;
import de.governikus.csl.uom.res.ResourceConstants;
import de.governikus.csl.uom.res.ResourceReferenceState;
import de.governikus.csl.uom.res.ResourceType;
import de.governikus.csl.uom.res.impl.PublicKeyResourceImpl;
import de.governikus.csl.uom.res.impl.ServiceResourceReferenceImpl;
import de.governikus.csl.uom.types.CertificateList;
import de.governikus.csl.uom.types.CertificateListType;
import de.governikus.csl.uom.types.CertificateValue;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;

public class PublicKeyResourceReferenceImpl
extends AbstractKeyResourceReference
implements PublicKeyResourceReference {
    private CertificateListType certificateChain;

    public PublicKeyResourceReferenceImpl() {
    }

    public PublicKeyResourceReferenceImpl(String name, ResourceComponentType resourceComponentType, ResourceAreaType resourceAreaType, List<Certificate> certificateChain, List<KeyFunctionSupportedAlgorithms> supportedAlgorithms) {
        super(name, ResourceType.CERTIFICATE, resourceComponentType, resourceAreaType, PublicKeyResourceImpl.class.getName(), supportedAlgorithms);
        this.initReference(certificateChain);
    }

    public PublicKeyResourceReferenceImpl(String name, ResourceComponentType resourceComponentType, ResourceAreaType resourceAreaType, List<Certificate> certificateChain, ResourceReferenceState resourceReferenceState, List<KeyFunctionSupportedAlgorithms> supportedAlgorithms) {
        super(name, ResourceType.CERTIFICATE, resourceComponentType, resourceAreaType, PublicKeyResourceImpl.class.getName(), resourceReferenceState == null ? ResourceConstants.SIMPLE_RESOURCE_REFERENCE_STATE : resourceReferenceState, supportedAlgorithms);
        this.initReference(certificateChain);
    }

    private void initReference(List<Certificate> certificateChain) {
        ArrayList<Certificate> tmp;
        ArrayList<Certificate> arrayList = tmp = certificateChain == null || certificateChain.isEmpty() ? new ArrayList<Certificate>() : new ArrayList<Certificate>(certificateChain);
        while (tmp.contains(null)) {
            tmp.remove(null);
        }
        if (tmp.isEmpty()) {
            throw new IllegalArgumentException("missing at least one certificate");
        }
        if (((Certificate)tmp.get(0)).getPublicKey() == null) {
            throw new IllegalArgumentException("first certificate does not possess required public key");
        }
        this.certificateChain = new CertificateListType(tmp);
        this.initAlgorithmFormat(certificateChain);
    }

    public PublicKeyResourceReferenceImpl(String name, ResourceComponentType resourceComponentType, ResourceAreaType resourceAreaType, List<Certificate> certificateChain, ResourceReferenceState resourceReferenceState, ServiceResourceReferenceImpl originatorServiceReference, List<KeyFunctionSupportedAlgorithms> supportedAlgorithms) {
        super(name, ResourceType.CERTIFICATE, resourceComponentType, resourceAreaType, PublicKeyResourceImpl.class.getName(), resourceReferenceState == null ? ResourceConstants.SIMPLE_RESOURCE_REFERENCE_STATE : resourceReferenceState, originatorServiceReference, supportedAlgorithms);
        this.initReference(certificateChain);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        PublicKeyResourceReferenceImpl other = (PublicKeyResourceReferenceImpl)obj;
        return !(this.certificateChain == null ? other.certificateChain != null : !this.certificateChain.equals(other.certificateChain));
    }

    @Override
    public CertificateValue getCertificate() {
        return this.certificateChain != null && !this.certificateChain.getCertificateValue().isEmpty() && this.certificateChain.getCertificateValue().get(0) != null ? (CertificateValue)this.certificateChain.getCertificateValue().get(0) : null;
    }

    @Override
    public PublicKey getPublicKey() {
        CertificateValue certificateValue = this.getCertificate();
        if (certificateValue == null) {
            return null;
        }
        Certificate certificate = certificateValue.certificate();
        if (certificate == null) {
            return null;
        }
        return certificate.getPublicKey();
    }

    @Override
    public CertificateList getCertificateChain() {
        return this.certificateChain;
    }

    @Override
    public String getAlgorithm() {
        if (this.algorithm == null) {
            this.algorithm = PublicKeyResourceReference.super.getAlgorithm();
        }
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        if (this.format == null) {
            this.format = PublicKeyResourceReference.super.getFormat();
        }
        return this.format;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.certificateChain == null ? 0 : this.certificateChain.hashCode());
        return result;
    }

    private void initAlgorithmFormat(List<Certificate> certificateChain) {
        super.setAlgorithm(certificateChain.get(0).getPublicKey().getAlgorithm());
        super.setFormat(certificateChain.get(0).getPublicKey().getFormat());
    }
}

