/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.res.impl;

import de.governikus.csl.uom.res.AbstractKeyResource;
import de.governikus.csl.uom.res.PublicKeyResource;
import de.governikus.csl.uom.res.PublicKeyResourceReference;
import de.governikus.csl.uom.res.ResourceFailedException;
import de.governikus.csl.uom.res.ResourceState;
import de.governikus.csl.uom.types.CertificateList;
import de.governikus.csl.uom.types.CertificateValue;
import java.security.PublicKey;
import java.util.Objects;

public class PublicKeyResourceImpl
extends AbstractKeyResource<PublicKey>
implements PublicKeyResource {
    public static final boolean DEFAULT_KEY_ACCESSIBLE = true;
    public static final String DEFAULT_JCE_PROVIDER = null;
    private static final long serialVersionUID = 1L;

    public PublicKeyResourceImpl() {
    }

    public PublicKeyResourceImpl(PublicKeyResourceReference resourceReference, String jceProviderName) {
        super(Objects.requireNonNull(resourceReference, "resource reference is required"), resourceReference.getPublicKey(), true, jceProviderName == null ? DEFAULT_JCE_PROVIDER : jceProviderName);
    }

    public PublicKeyResourceImpl(PublicKeyResourceReference resourceReference, ResourceState resourceState, String jceProviderName) {
        super(Objects.requireNonNull(resourceReference, "resource reference is required"), resourceState, resourceReference.getPublicKey(), true, jceProviderName == null ? DEFAULT_JCE_PROVIDER : jceProviderName);
    }

    @Override
    public PublicKey getPublicKey() {
        try {
            return (PublicKey)super.getKey();
        }
        catch (ResourceFailedException e) {
            return null;
        }
    }

    @Override
    public CertificateValue getCertificate() {
        PublicKeyResourceReference publicKeyResourceReference = (PublicKeyResourceReference)super.getReference();
        if (publicKeyResourceReference == null) {
            return null;
        }
        return publicKeyResourceReference.getCertificate();
    }

    @Override
    public CertificateList getCertificateChain() {
        PublicKeyResourceReference publicKeyResourceReference = (PublicKeyResourceReference)super.getReference();
        if (publicKeyResourceReference == null) {
            return null;
        }
        return publicKeyResourceReference.getCertificateChain();
    }
}

