/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.res.impl;

import de.governikus.csl.uom.res.AbstractKeyResourceReference;
import de.governikus.csl.uom.res.KeyFunctionSupportedAlgorithms;
import de.governikus.csl.uom.res.PrivateKeyResourceReference;
import de.governikus.csl.uom.res.ResourceAreaType;
import de.governikus.csl.uom.res.ResourceComponentType;
import de.governikus.csl.uom.res.ResourceConstants;
import de.governikus.csl.uom.res.ResourceReferenceState;
import de.governikus.csl.uom.res.ResourceType;
import de.governikus.csl.uom.res.impl.PrivateKeyResourceImpl;
import de.governikus.csl.uom.types.CertificateList;
import de.governikus.csl.uom.types.CertificateListType;
import de.governikus.csl.uom.types.CertificateValue;
import de.governikus.csl.utils.CryptoProviderUtil;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

public class PrivateKeyResourceReferenceImpl
extends AbstractKeyResourceReference
implements PrivateKeyResourceReference {
    private CertificateListType certificateChain;

    public PrivateKeyResourceReferenceImpl(String name, ResourceType resourceType, ResourceComponentType resourceComponentType, ResourceAreaType resourceAreaType, String typeResource, List<KeyFunctionSupportedAlgorithms> supportedAlgorithms) {
        super(name, resourceType, resourceComponentType, resourceAreaType, typeResource, supportedAlgorithms);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.certificateChain == null ? 0 : this.certificateChain.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        PrivateKeyResourceReferenceImpl other = (PrivateKeyResourceReferenceImpl)obj;
        return !(this.certificateChain == null ? other.certificateChain != null : !this.certificateChain.equals(other.certificateChain));
    }

    public PrivateKeyResourceReferenceImpl() {
    }

    public PrivateKeyResourceReferenceImpl(String name, ResourceType resourceType, ResourceAreaType resourceAreaType, String typeResource, ResourceReferenceState resourceReferenceState, List<KeyFunctionSupportedAlgorithms> supportedAlgorithms, ResourceComponentType resourceComponentType) {
        super(name, resourceType, resourceComponentType, resourceAreaType, typeResource, resourceReferenceState, supportedAlgorithms);
    }

    public PrivateKeyResourceReferenceImpl(String name, ResourceType resourceType, ResourceComponentType componentType, ResourceAreaType areaType, List<KeyFunctionSupportedAlgorithms> supportedAlgorithms) {
        super(name, resourceType, componentType, areaType, PrivateKeyResourceImpl.class.getName(), supportedAlgorithms);
    }

    public PrivateKeyResourceReferenceImpl(String name, ResourceAreaType resourceArea) {
        this(name, resourceArea, (List<Certificate>)null);
    }

    public PrivateKeyResourceReferenceImpl(String name) {
        this(name, ResourceAreaType.LOCAL);
    }

    public PrivateKeyResourceReferenceImpl(String name, List<KeyFunctionSupportedAlgorithms> supportedAlgorithms, ResourceComponentType componentType, ResourceAreaType resourceArea) {
        super(name, ResourceType.KEY, componentType, resourceArea, PrivateKeyResourceImpl.class.getName(), supportedAlgorithms);
    }

    public PrivateKeyResourceReferenceImpl(String name, List<KeyFunctionSupportedAlgorithms> supportedAlgorithms, ResourceComponentType componentType) {
        this(name, supportedAlgorithms, componentType, ResourceAreaType.LOCAL);
    }

    public PrivateKeyResourceReferenceImpl(String name, ResourceComponentType componentType, ResourceAreaType resourceArea, List<Certificate> certificateChain) {
        super(name, ResourceType.KEY, componentType, resourceArea, PrivateKeyResourceImpl.class.getName(), PrivateKeyResourceReferenceImpl.getDefaultSupportedAlgorithms(certificateChain));
        ArrayList<Certificate> tmp = certificateChain == null || certificateChain.isEmpty() ? new ArrayList<Certificate>() : new ArrayList<Certificate>(certificateChain);
        tmp.remove(null);
        this.certificateChain = new CertificateListType(tmp);
        this.initIdAlgorithmFormat(certificateChain);
    }

    public PrivateKeyResourceReferenceImpl(String name, ResourceComponentType componentType, List<Certificate> certificateChain) {
        this(name, componentType, ResourceAreaType.LOCAL, certificateChain);
    }

    public PrivateKeyResourceReferenceImpl(String name, ResourceAreaType resourceArea, List<Certificate> certificateChain) {
        super(name, ResourceType.KEY, ResourceComponentType.SOFTWARE, resourceArea, PrivateKeyResourceImpl.class.getName(), PrivateKeyResourceReferenceImpl.getDefaultSupportedAlgorithms(certificateChain));
        ArrayList<Certificate> tmp = certificateChain == null || certificateChain.isEmpty() ? new ArrayList<Certificate>() : new ArrayList<Certificate>(certificateChain);
        tmp.remove(null);
        this.certificateChain = new CertificateListType(tmp);
        this.initIdAlgorithmFormat(certificateChain);
    }

    public PrivateKeyResourceReferenceImpl(String name, List<Certificate> certificateChain) {
        this(name, ResourceAreaType.LOCAL, certificateChain);
    }

    private void initIdAlgorithmFormat(List<Certificate> certificateChain) {
        if (certificateChain != null && !certificateChain.isEmpty() && certificateChain.get(0) != null) {
            if (super.getComponentType().getIdPrefix() == null || "".equals(super.getComponentType().getIdPrefix())) {
                this.setId(CryptoProviderUtil.createID(this.getCertificate().certificate()));
            } else {
                String id = CryptoProviderUtil.createID(this.getCertificate().certificate()).replaceFirst("id", "");
                this.setId(super.getComponentType().getIdPrefix() + id);
            }
            super.setAlgorithm(certificateChain.get(0).getPublicKey().getAlgorithm());
            super.setFormat(certificateChain.get(0).getPublicKey().getFormat());
        }
    }

    public PrivateKeyResourceReferenceImpl(String name, ResourceComponentType componentType, ResourceAreaType resourceArea, ResourceReferenceState resourceReferenceState, List<Certificate> certificateChain) {
        this(name, ResourceType.KEY, componentType, resourceArea, PrivateKeyResourceImpl.class.getName(), resourceReferenceState, certificateChain);
    }

    public PrivateKeyResourceReferenceImpl(String name, ResourceComponentType componentType, ResourceReferenceState resourceReferenceState, List<Certificate> certificateChain) {
        this(name, componentType, ResourceAreaType.LOCAL, resourceReferenceState, certificateChain);
    }

    public PrivateKeyResourceReferenceImpl(String name, ResourceType resourceType, ResourceComponentType resourceComponentType, ResourceAreaType resourceAreaType, String typeResource, ResourceReferenceState resourceReferenceState, List<Certificate> certificateChain) {
        super(name, resourceType, resourceComponentType, resourceAreaType, typeResource, resourceReferenceState, PrivateKeyResourceReferenceImpl.getDefaultSupportedAlgorithms(certificateChain));
        ArrayList<Certificate> tmp = certificateChain == null || certificateChain.isEmpty() ? new ArrayList<Certificate>() : new ArrayList<Certificate>(certificateChain);
        tmp.remove(null);
        this.certificateChain = new CertificateListType(tmp);
        this.initIdAlgorithmFormat(certificateChain);
    }

    public PrivateKeyResourceReferenceImpl(String name, ResourceType resourceType, ResourceComponentType resourceComponentType, ResourceAreaType resourceAreaType, String typeResource, ResourceReferenceState resourceReferenceState, List<Certificate> certificateChain, List<KeyFunctionSupportedAlgorithms> keyFunctionSupportedAlgorithmsList) {
        super(name, resourceType, resourceComponentType, resourceAreaType, typeResource, resourceReferenceState, keyFunctionSupportedAlgorithmsList);
        ArrayList<Certificate> tmp = certificateChain == null || certificateChain.isEmpty() ? new ArrayList<Certificate>() : new ArrayList<Certificate>(certificateChain);
        tmp.remove(null);
        this.certificateChain = new CertificateListType(tmp);
        this.initIdAlgorithmFormat(certificateChain);
    }

    private static List<KeyFunctionSupportedAlgorithms> getDefaultSupportedAlgorithms(List<Certificate> certificateChain) {
        X509Certificate x509;
        boolean[] keyUsages;
        if (certificateChain == null || certificateChain.isEmpty()) {
            return ResourceConstants.DEFAULT_SUPPORTED_ALGORTHMS_ALL;
        }
        Certificate certificate = certificateChain.get(0);
        PublicKey publicKey = certificate.getPublicKey();
        if (publicKey == null) {
            return ResourceConstants.DEFAULT_SUPPORTED_ALGORTHMS_ALL;
        }
        boolean isRSA = "RSA".equals(publicKey.getAlgorithm());
        boolean isEC = "EC".equals(publicKey.getAlgorithm());
        if (certificate instanceof X509Certificate && (keyUsages = (x509 = (X509Certificate)certificate).getKeyUsage()) != null && keyUsages.length > 0) {
            ArrayList<KeyFunctionSupportedAlgorithms> result = new ArrayList<KeyFunctionSupportedAlgorithms>();
            if (PrivateKeyResourceReferenceImpl.isSet(keyUsages, 0) || PrivateKeyResourceReferenceImpl.isSet(keyUsages, 5) || PrivateKeyResourceReferenceImpl.isSet(keyUsages, 6)) {
                if (isRSA) {
                    result.add(ResourceConstants.DEFAULT_SUPPORTED_ALGORITHMS_RSA_AUTHENTICATE);
                }
                if (isEC) {
                    result.add(ResourceConstants.DEFAULT_SUPPORTED_ALGORITHMS_EC_AUTHENTICATE);
                }
            }
            if (PrivateKeyResourceReferenceImpl.isSet(keyUsages, 1)) {
                if (isRSA) {
                    result.add(ResourceConstants.DEFAULT_SUPPORTED_ALGORITHMS_RSA_SIGN);
                }
                if (isEC) {
                    result.add(ResourceConstants.DEFAULT_SUPPORTED_ALGORITHMS_EC_SIGN);
                }
            }
            if ((PrivateKeyResourceReferenceImpl.isSet(keyUsages, 2) || PrivateKeyResourceReferenceImpl.isSet(keyUsages, 3) || PrivateKeyResourceReferenceImpl.isSet(keyUsages, 7) || PrivateKeyResourceReferenceImpl.isSet(keyUsages, 4)) && isRSA) {
                result.add(ResourceConstants.DEFAULT_SUPPORTED_ALGORITHMS_RSA_ENCRYPT);
            }
            if ((PrivateKeyResourceReferenceImpl.isSet(keyUsages, 8) || PrivateKeyResourceReferenceImpl.isSet(keyUsages, 4)) && isRSA) {
                result.add(ResourceConstants.DEFAULT_SUPPORTED_ALGORITHMS_RSA_DECRYPT);
            }
            if (!result.isEmpty()) {
                return result;
            }
        }
        if (isRSA) {
            return ResourceConstants.DEFAULT_SUPPORTED_ALGORTHMS_RSA;
        }
        if ("EC".equals(publicKey.getAlgorithm())) {
            return ResourceConstants.DEFAULT_SUPPORTED_ALGORTHMS_EC;
        }
        return ResourceConstants.DEFAULT_SUPPORTED_ALGORTHMS_ALL;
    }

    private static boolean isSet(boolean[] keyUsages, int idx) {
        return keyUsages.length >= idx ? keyUsages[idx] : false;
    }

    @Override
    public final CertificateList getCertificateChain() {
        return this.certificateChain;
    }

    public final PrivateKeyResourceReferenceImpl setCertificateChain(CertificateListType certificateChain) {
        if (this.certificateChain == null) {
            this.certificateChain = certificateChain;
        }
        return this;
    }

    @Override
    public final CertificateValue getCertificate() {
        return this.certificateChain == null || this.certificateChain.getCertificateValue() == null || this.certificateChain.getCertificateValue().isEmpty() ? null : (CertificateValue)this.certificateChain.getCertificateValue().get(0);
    }

    @Override
    public PrivateKeyResourceReferenceImpl setFormat(String format) {
        super.setAlgorithm(format);
        return this;
    }

    @Override
    public PrivateKeyResourceReferenceImpl setAlgorithm(String algorithm) {
        super.setAlgorithm(algorithm);
        return this;
    }
}

