/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.res.impl;

import de.governikus.csl.uom.res.AbstractKeyResource;
import de.governikus.csl.uom.res.PrivateKeyResource;
import de.governikus.csl.uom.res.PrivateKeyResourceReference;
import de.governikus.csl.uom.res.ResourceAreaType;
import de.governikus.csl.uom.res.ResourceComponentType;
import de.governikus.csl.uom.res.ResourceState;
import de.governikus.csl.uom.res.impl.DelegateLockableResourceStateImpl;
import de.governikus.csl.uom.res.impl.DelegateResourceReferenceStateImpl;
import de.governikus.csl.uom.res.impl.ObjectConfigurationType;
import de.governikus.csl.uom.res.impl.PrivateKeyResourceReferenceImpl;
import de.governikus.csl.uom.res.impl.SimpleLockableResourceState;
import de.governikus.csl.uom.types.CertificateList;
import de.governikus.csl.uom.types.CertificateValue;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.List;

public class PrivateKeyResourceImpl
extends AbstractKeyResource<PrivateKey>
implements PrivateKeyResource {
    private static final ResourceAreaType DEFAULT_RESOURCE_AREA_TYPE = ObjectConfigurationType.RESOURCE_AREA_CONFIGURATION_DEFAULT.toObject();
    private static final boolean DEFAULT_PRIVATE_KEY_RESOURCE_STATE_CHANGEABLE = false;
    private static final long serialVersionUID = 1L;

    public PrivateKeyResourceImpl(PrivateKeyResourceReference resourceReference, PrivateKey privateKey, boolean accessible, String jceProviderName) {
        this(resourceReference, null, privateKey, accessible, jceProviderName);
    }

    public PrivateKeyResourceImpl(PrivateKeyResourceReference resourceReference, ResourceState resourceState, PrivateKey privateKey, boolean accessible, String jceProviderName) {
        super(resourceReference, resourceState, privateKey, accessible, jceProviderName);
    }

    public PrivateKeyResourceImpl(String name, PrivateKey privateKey, String jceProviderName, List<Certificate> chainCertificates) {
        this(new PrivateKeyResourceReferenceImpl(name, chainCertificates), null, privateKey, true, jceProviderName);
    }

    public PrivateKeyResourceImpl(String name, ResourceState resourceState, PrivateKey privateKey, String jceProviderName, List<Certificate> chainCertificates) {
        this(new PrivateKeyResourceReferenceImpl(name, chainCertificates), resourceState, privateKey, true, jceProviderName);
    }

    public PrivateKeyResourceImpl(String name, PrivateKey privateKey, String jceProviderName, List<Certificate> chainCertificates, boolean stateChangeable) {
        this(name, privateKey, jceProviderName, chainCertificates, stateChangeable, DEFAULT_RESOURCE_AREA_TYPE);
    }

    public PrivateKeyResourceImpl(String name, PrivateKey privateKey, String jceProviderName, List<Certificate> chainCertificates, boolean stateChangeable, ResourceAreaType resourceArea) {
        super(stateChangeable ? new PrivateKeyResourceReferenceImpl(name, ResourceComponentType.SOFTWARE, resourceArea, new DelegateResourceReferenceStateImpl(), chainCertificates) : new PrivateKeyResourceReferenceImpl(name, resourceArea, chainCertificates), stateChangeable ? new DelegateLockableResourceStateImpl<Object>(null) : null, privateKey, true, jceProviderName);
        if (stateChangeable) {
            SimpleLockableResourceState lrs = new SimpleLockableResourceState();
            DelegateLockableResourceStateImpl dState = (DelegateLockableResourceStateImpl)super.getState();
            dState.setDelegate(lrs);
            ((DelegateResourceReferenceStateImpl)super.getReference().getState()).setResourceState(lrs);
        }
    }

    public static PrivateKeyResourceImpl fromKeyStore(String name, KeyStore keyStore, String alias) {
        return PrivateKeyResourceImpl.fromKeyStore(name, keyStore, alias, false, DEFAULT_RESOURCE_AREA_TYPE);
    }

    public static PrivateKeyResourceImpl fromKeyStore(String name, KeyStore keyStore, String alias, ResourceAreaType resourceArea) {
        return PrivateKeyResourceImpl.fromKeyStore(name, keyStore, alias, false, resourceArea);
    }

    public static PrivateKeyResourceImpl fromKeyStore(String name, KeyStore keyStore, String alias, boolean stateChangeable) {
        return PrivateKeyResourceImpl.fromKeyStore(name, keyStore, alias, stateChangeable, DEFAULT_RESOURCE_AREA_TYPE);
    }

    public static PrivateKeyResourceImpl fromKeyStore(String name, KeyStore keyStore, String alias, boolean stateChangeable, ResourceAreaType resourceArea) {
        if (keyStore == null) {
            throw new IllegalArgumentException("KeyStore can not be null");
        }
        if (alias == null || alias.isEmpty()) {
            throw new IllegalArgumentException("alias can not be null or empty");
        }
        try {
            if (keyStore.isKeyEntry(alias)) {
                Key key = keyStore.getKey(alias, null);
                if (key instanceof PrivateKey) {
                    Certificate[] chainCertificates = keyStore.getCertificateChain(alias);
                    if (chainCertificates == null || chainCertificates.length == 0) {
                        throw new IllegalArgumentException("alias must specify a Key entry with certificate");
                    }
                    return PrivateKeyResourceImpl.fromKey(name, (PrivateKey)key, chainCertificates, keyStore.getProvider() == null ? null : keyStore.getProvider().getName(), stateChangeable, resourceArea);
                }
                if (key == null) {
                    throw new IllegalArgumentException("alias must specify a PrivateKey entry: null");
                }
                throw new IllegalArgumentException("alias must specify a PrivateKey entry: " + key.getClass().getName());
            }
            throw new IllegalArgumentException("alias must specify a key entry");
        }
        catch (NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new IllegalArgumentException("failed to access key: " + e.getMessage(), e);
        }
        catch (KeyStoreException e) {
            throw new IllegalArgumentException("failed to access keystore: " + e.getMessage(), e);
        }
    }

    public static PrivateKeyResourceImpl fromKey(String name, PrivateKey privateKey, Certificate[] chainCertificates, String providerName) {
        return PrivateKeyResourceImpl.fromKey(name, privateKey, chainCertificates, providerName, false, DEFAULT_RESOURCE_AREA_TYPE);
    }

    public static PrivateKeyResourceImpl fromKey(String name, PrivateKey privateKey, Certificate[] chainCertificates, String providerName, boolean stateChangeable) {
        return PrivateKeyResourceImpl.fromKey(name, privateKey, chainCertificates, providerName, stateChangeable, DEFAULT_RESOURCE_AREA_TYPE);
    }

    public static PrivateKeyResourceImpl fromKey(String name, PrivateKey privateKey, Certificate[] chainCertificates, String providerName, boolean stateChangeable, ResourceAreaType resourceArea) {
        return PrivateKeyResourceImpl.fromKey(name, privateKey, chainCertificates == null || chainCertificates.length == 0 ? null : Arrays.asList(chainCertificates), providerName, stateChangeable, resourceArea);
    }

    public static PrivateKeyResourceImpl fromKey(String name, PrivateKey privateKey, List<Certificate> chainCertificates, String providerName) {
        return PrivateKeyResourceImpl.fromKey(name, privateKey, chainCertificates, providerName, false, DEFAULT_RESOURCE_AREA_TYPE);
    }

    public static PrivateKeyResourceImpl fromKey(String name, PrivateKey privateKey, List<Certificate> chainCertificates, String providerName, ResourceAreaType resourceArea) {
        return PrivateKeyResourceImpl.fromKey(name, privateKey, chainCertificates, providerName, false, resourceArea);
    }

    public static PrivateKeyResourceImpl fromKey(String name, PrivateKey privateKey, List<Certificate> chainCertificates, String providerName, boolean stateChangeable) {
        return PrivateKeyResourceImpl.fromKey(name, privateKey, chainCertificates, providerName, stateChangeable, DEFAULT_RESOURCE_AREA_TYPE);
    }

    public static PrivateKeyResourceImpl fromKey(String name, PrivateKey privateKey, List<Certificate> chainCertificates, String providerName, boolean stateChangeable, ResourceAreaType resourceArea) {
        return new PrivateKeyResourceImpl(name, privateKey, providerName, chainCertificates, stateChangeable, resourceArea);
    }

    @Override
    public final CertificateValue getCertificate() {
        return ((PrivateKeyResourceReference)this.resourceReference).getCertificate();
    }

    @Override
    public final CertificateList getCertificateChain() {
        return ((PrivateKeyResourceReference)this.resourceReference).getCertificateChain();
    }
}

